--
-- PostgreSQL database dump
--

-- Dumped from database version 14.2
-- Dumped by pg_dump version 14.2

-- Started on 2022-12-21 15:10:43

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- TOC entry 35 (class 2615 OID 2452377)
-- Name: a_aeropuerto_superficie; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA a_aeropuerto_superficie;


ALTER SCHEMA a_aeropuerto_superficie OWNER TO postgres;

--
-- TOC entry 27 (class 2615 OID 2452378)
-- Name: catalogo_objetos; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA catalogo_objetos;


ALTER SCHEMA catalogo_objetos OWNER TO postgres;

--
-- TOC entry 33 (class 2615 OID 3376058)
-- Name: ct_miscelaneos; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ct_miscelaneos;


ALTER SCHEMA ct_miscelaneos OWNER TO postgres;

--
-- TOC entry 15 (class 2615 OID 3375805)
-- Name: d_limite_politico_administrativo; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA d_limite_politico_administrativo;


ALTER SCHEMA d_limite_politico_administrativo OWNER TO postgres;

--
-- TOC entry 39 (class 2615 OID 2452379)
-- Name: d_linderos_propiedad; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA d_linderos_propiedad;


ALTER SCHEMA d_linderos_propiedad OWNER TO postgres;

--
-- TOC entry 38 (class 2615 OID 2452380)
-- Name: gs_asociado_poblados; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA gs_asociado_poblados;


ALTER SCHEMA gs_asociado_poblados OWNER TO postgres;

--
-- TOC entry 30 (class 2615 OID 3375728)
-- Name: gs_comercio; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA gs_comercio;


ALTER SCHEMA gs_comercio OWNER TO postgres;

--
-- TOC entry 37 (class 2615 OID 2452381)
-- Name: gs_construcciones; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA gs_construcciones;


ALTER SCHEMA gs_construcciones OWNER TO postgres;

--
-- TOC entry 23 (class 2615 OID 2452382)
-- Name: gs_recreacion; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA gs_recreacion;


ALTER SCHEMA gs_recreacion OWNER TO postgres;

--
-- TOC entry 22 (class 2615 OID 2452383)
-- Name: ho_aguas_interiores; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_aguas_interiores;


ALTER SCHEMA ho_aguas_interiores OWNER TO postgres;

--
-- TOC entry 40 (class 2615 OID 2452384)
-- Name: ho_puertos_muelles; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_puertos_muelles;


ALTER SCHEMA ho_puertos_muelles OWNER TO postgres;

--
-- TOC entry 18 (class 2615 OID 2452385)
-- Name: ho_regulacion_zonas_restringidas; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_regulacion_zonas_restringidas;


ALTER SCHEMA ho_regulacion_zonas_restringidas OWNER TO postgres;

--
-- TOC entry 13 (class 2615 OID 2452386)
-- Name: ho_zonas_costeras; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_zonas_costeras;


ALTER SCHEMA ho_zonas_costeras OWNER TO postgres;

--
-- TOC entry 26 (class 2615 OID 2452387)
-- Name: ii_agropecuaria; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ii_agropecuaria;


ALTER SCHEMA ii_agropecuaria OWNER TO postgres;

--
-- TOC entry 31 (class 2615 OID 3375644)
-- Name: ii_estructura_asociada_industria; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ii_estructura_asociada_industria;


ALTER SCHEMA ii_estructura_asociada_industria OWNER TO postgres;

--
-- TOC entry 34 (class 2615 OID 3375489)
-- Name: ii_extraccion; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ii_extraccion;


ALTER SCHEMA ii_extraccion OWNER TO postgres;

--
-- TOC entry 11 (class 2615 OID 2452388)
-- Name: it_asociado_transportacion; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_asociado_transportacion;


ALTER SCHEMA it_asociado_transportacion OWNER TO postgres;

--
-- TOC entry 20 (class 2615 OID 2452389)
-- Name: it_cruces_enlaces; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_cruces_enlaces;


ALTER SCHEMA it_cruces_enlaces OWNER TO postgres;

--
-- TOC entry 17 (class 2615 OID 2452390)
-- Name: it_ferrocarriles; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_ferrocarriles;


ALTER SCHEMA it_ferrocarriles OWNER TO postgres;

--
-- TOC entry 36 (class 2615 OID 2452391)
-- Name: it_transporte_terrestre; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_transporte_terrestre;


ALTER SCHEMA it_transporte_terrestre OWNER TO postgres;

--
-- TOC entry 16 (class 2615 OID 3376014)
-- Name: m_infraestructura_defensa_operaciones; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA m_infraestructura_defensa_operaciones;


ALTER SCHEMA m_infraestructura_defensa_operaciones OWNER TO postgres;

--
-- TOC entry 32 (class 2615 OID 2452392)
-- Name: proyecto_qgis3; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA proyecto_qgis3;


ALTER SCHEMA proyecto_qgis3 OWNER TO postgres;

--
-- TOC entry 25 (class 2615 OID 17626)
-- Name: tiger; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA tiger;


ALTER SCHEMA tiger OWNER TO postgres;

--
-- TOC entry 28 (class 2615 OID 17882)
-- Name: tiger_data; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA tiger_data;


ALTER SCHEMA tiger_data OWNER TO postgres;

--
-- TOC entry 19 (class 2615 OID 17420)
-- Name: topology; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA topology;


ALTER SCHEMA topology OWNER TO postgres;

--
-- TOC entry 8141 (class 0 OID 0)
-- Dependencies: 19
-- Name: SCHEMA topology; Type: COMMENT; Schema: -; Owner: postgres
--

COMMENT ON SCHEMA topology IS 'PostGIS Topology schema';


--
-- TOC entry 29 (class 2615 OID 2452393)
-- Name: visualizacion; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA visualizacion;


ALTER SCHEMA visualizacion OWNER TO postgres;

--
-- TOC entry 6 (class 3079 OID 17619)
-- Name: address_standardizer; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS address_standardizer WITH SCHEMA public;


--
-- TOC entry 8142 (class 0 OID 0)
-- Dependencies: 6
-- Name: EXTENSION address_standardizer; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION address_standardizer IS 'Used to parse an address into constituent elements. Generally used to support geocoding address normalization step.';


--
-- TOC entry 5 (class 3079 OID 17608)
-- Name: fuzzystrmatch; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS fuzzystrmatch WITH SCHEMA public;


--
-- TOC entry 8143 (class 0 OID 0)
-- Dependencies: 5
-- Name: EXTENSION fuzzystrmatch; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION fuzzystrmatch IS 'determine similarities and distance between strings';


--
-- TOC entry 2 (class 3079 OID 16386)
-- Name: postgis; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis WITH SCHEMA public;


--
-- TOC entry 8144 (class 0 OID 0)
-- Dependencies: 2
-- Name: EXTENSION postgis; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis IS 'PostGIS geometry and geography spatial types and functions';


--
-- TOC entry 8 (class 3079 OID 18036)
-- Name: postgis_raster; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis_raster WITH SCHEMA public;


--
-- TOC entry 8145 (class 0 OID 0)
-- Dependencies: 8
-- Name: EXTENSION postgis_raster; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis_raster IS 'PostGIS raster types and functions';


--
-- TOC entry 4 (class 3079 OID 17581)
-- Name: postgis_sfcgal; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis_sfcgal WITH SCHEMA public;


--
-- TOC entry 8146 (class 0 OID 0)
-- Dependencies: 4
-- Name: EXTENSION postgis_sfcgal; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis_sfcgal IS 'PostGIS SFCGAL functions';


--
-- TOC entry 7 (class 3079 OID 17627)
-- Name: postgis_tiger_geocoder; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis_tiger_geocoder WITH SCHEMA tiger;


--
-- TOC entry 8147 (class 0 OID 0)
-- Dependencies: 7
-- Name: EXTENSION postgis_tiger_geocoder; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis_tiger_geocoder IS 'PostGIS tiger geocoder and reverse geocoder';


--
-- TOC entry 3 (class 3079 OID 17421)
-- Name: postgis_topology; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis_topology WITH SCHEMA topology;


--
-- TOC entry 8148 (class 0 OID 0)
-- Dependencies: 3
-- Name: EXTENSION postgis_topology; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis_topology IS 'PostGIS topology spatial types and functions';


SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- TOC entry 317 (class 1259 OID 2452394)
-- Name: aeropuerto_a; Type: TABLE; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE TABLE a_aeropuerto_superficie.aeropuerto_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'GB005'::character varying NOT NULL,
    nam character varying(80),
    acc integer NOT NULL,
    iko character varying(4),
    fuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'GB005'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE a_aeropuerto_superficie.aeropuerto_a OWNER TO postgres;

--
-- TOC entry 8149 (class 0 OID 0)
-- Dependencies: 317
-- Name: TABLE aeropuerto_a; Type: COMMENT; Schema: a_aeropuerto_superficie; Owner: postgres
--

COMMENT ON TABLE a_aeropuerto_superficie.aeropuerto_a IS 'Zona provista de un conjunto de pistas, instalaciones y servicios destinados al tráfico regular de aeronaves.';


--
-- TOC entry 318 (class 1259 OID 2452405)
-- Name: aeropuerto_a_gid_seq; Type: SEQUENCE; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE SEQUENCE a_aeropuerto_superficie.aeropuerto_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE a_aeropuerto_superficie.aeropuerto_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8150 (class 0 OID 0)
-- Dependencies: 318
-- Name: aeropuerto_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER SEQUENCE a_aeropuerto_superficie.aeropuerto_a_gid_seq OWNED BY a_aeropuerto_superficie.aeropuerto_a.gid;


--
-- TOC entry 319 (class 1259 OID 2452406)
-- Name: acc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.acc (
    acc integer NOT NULL,
    acc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.acc OWNER TO postgres;

--
-- TOC entry 443 (class 1259 OID 3372850)
-- Name: agg; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.agg (
    agg integer NOT NULL,
    agg_desc character varying(80)
);


ALTER TABLE catalogo_objetos.agg OWNER TO postgres;

--
-- TOC entry 320 (class 1259 OID 2452409)
-- Name: atc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.atc (
    atc integer NOT NULL,
    atc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.atc OWNER TO postgres;

--
-- TOC entry 444 (class 1259 OID 3372857)
-- Name: bcp; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.bcp (
    bcp integer NOT NULL,
    bcp_desc character varying(80)
);


ALTER TABLE catalogo_objetos.bcp OWNER TO postgres;

--
-- TOC entry 321 (class 1259 OID 2452412)
-- Name: bsc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.bsc (
    bsc integer NOT NULL,
    bsc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.bsc OWNER TO postgres;

--
-- TOC entry 322 (class 1259 OID 2452415)
-- Name: catalogo_objetos; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.catalogo_objetos (
    fcode character varying(5) NOT NULL,
    objeto character varying(80),
    descripcion character varying(350),
    gid integer NOT NULL
);


ALTER TABLE catalogo_objetos.catalogo_objetos OWNER TO postgres;

--
-- TOC entry 323 (class 1259 OID 2452418)
-- Name: catalogo_objetos_gid_seq; Type: SEQUENCE; Schema: catalogo_objetos; Owner: postgres
--

CREATE SEQUENCE catalogo_objetos.catalogo_objetos_gid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE catalogo_objetos.catalogo_objetos_gid_seq OWNER TO postgres;

--
-- TOC entry 8155 (class 0 OID 0)
-- Dependencies: 323
-- Name: catalogo_objetos_gid_seq; Type: SEQUENCE OWNED BY; Schema: catalogo_objetos; Owner: postgres
--

ALTER SEQUENCE catalogo_objetos.catalogo_objetos_gid_seq OWNED BY catalogo_objetos.catalogo_objetos.gid;


--
-- TOC entry 445 (class 1259 OID 3372863)
-- Name: cpa; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.cpa (
    cpa integer NOT NULL,
    cpa_desc character varying(80)
);


ALTER TABLE catalogo_objetos.cpa OWNER TO postgres;

--
-- TOC entry 324 (class 1259 OID 2452419)
-- Name: dit; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.dit (
    dit integer NOT NULL,
    dit_desc character varying(80)
);


ALTER TABLE catalogo_objetos.dit OWNER TO postgres;

--
-- TOC entry 325 (class 1259 OID 2452422)
-- Name: ela; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.ela (
    ela integer NOT NULL,
    ela_desc character varying(80)
);


ALTER TABLE catalogo_objetos.ela OWNER TO postgres;

--
-- TOC entry 326 (class 1259 OID 2452425)
-- Name: fco; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.fco (
    fco integer NOT NULL,
    fco_desc character varying(80)
);


ALTER TABLE catalogo_objetos.fco OWNER TO postgres;

--
-- TOC entry 446 (class 1259 OID 3372872)
-- Name: ffn; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.ffn (
    ffn integer NOT NULL,
    ffn_desc character varying(80)
);


ALTER TABLE catalogo_objetos.ffn OWNER TO postgres;

--
-- TOC entry 327 (class 1259 OID 2452428)
-- Name: fti; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.fti (
    fti integer NOT NULL,
    fti_desc character varying(80)
);


ALTER TABLE catalogo_objetos.fti OWNER TO postgres;

--
-- TOC entry 328 (class 1259 OID 2452431)
-- Name: fuc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.fuc (
    fuc integer NOT NULL,
    fuc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.fuc OWNER TO postgres;

--
-- TOC entry 329 (class 1259 OID 2452434)
-- Name: hct; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.hct (
    hct integer NOT NULL,
    hct_desc character varying(80)
);


ALTER TABLE catalogo_objetos.hct OWNER TO postgres;

--
-- TOC entry 330 (class 1259 OID 2452437)
-- Name: hyp; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.hyp (
    hyp integer NOT NULL,
    hyp_desc character varying(80)
);


ALTER TABLE catalogo_objetos.hyp OWNER TO postgres;

--
-- TOC entry 331 (class 1259 OID 2452440)
-- Name: kos; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.kos (
    kos integer NOT NULL,
    kos_desc character varying(80)
);


ALTER TABLE catalogo_objetos.kos OWNER TO postgres;

--
-- TOC entry 332 (class 1259 OID 2452443)
-- Name: loc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.loc (
    loc integer NOT NULL,
    loc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.loc OWNER TO postgres;

--
-- TOC entry 447 (class 1259 OID 3372882)
-- Name: mcc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.mcc (
    mcc integer NOT NULL,
    mcc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.mcc OWNER TO postgres;

--
-- TOC entry 333 (class 1259 OID 2452446)
-- Name: mes; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.mes (
    mes integer NOT NULL,
    mes_desc character varying(80)
);


ALTER TABLE catalogo_objetos.mes OWNER TO postgres;

--
-- TOC entry 448 (class 1259 OID 3372892)
-- Name: ppo; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.ppo (
    ppo integer NOT NULL,
    ppo_desc character varying(80)
);


ALTER TABLE catalogo_objetos.ppo OWNER TO postgres;

--
-- TOC entry 442 (class 1259 OID 3372831)
-- Name: psf; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.psf (
    psf integer NOT NULL,
    psf_desc character varying(80)
);


ALTER TABLE catalogo_objetos.psf OWNER TO postgres;

--
-- TOC entry 449 (class 1259 OID 3372898)
-- Name: pwc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.pwc (
    pwc integer NOT NULL,
    pwc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.pwc OWNER TO postgres;

--
-- TOC entry 334 (class 1259 OID 2452449)
-- Name: rdt; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rdt (
    rdt integer NOT NULL,
    rdt_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rdt OWNER TO postgres;

--
-- TOC entry 335 (class 1259 OID 2452452)
-- Name: rel; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rel (
    rel integer NOT NULL,
    rel_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rel OWNER TO postgres;

--
-- TOC entry 450 (class 1259 OID 3372904)
-- Name: res; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.res (
    res integer NOT NULL,
    res_desc character varying(80)
);


ALTER TABLE catalogo_objetos.res OWNER TO postgres;

--
-- TOC entry 336 (class 1259 OID 2452455)
-- Name: rgc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rgc (
    rgc integer NOT NULL,
    rgc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rgc OWNER TO postgres;

--
-- TOC entry 337 (class 1259 OID 2452458)
-- Name: rra; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rra (
    rra integer NOT NULL,
    rra_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rra OWNER TO postgres;

--
-- TOC entry 338 (class 1259 OID 2452461)
-- Name: rrc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rrc (
    rrc integer NOT NULL,
    rrc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rrc OWNER TO postgres;

--
-- TOC entry 339 (class 1259 OID 2452464)
-- Name: rst; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rst (
    rst integer NOT NULL,
    rst_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rst OWNER TO postgres;

--
-- TOC entry 451 (class 1259 OID 3372921)
-- Name: scc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.scc (
    scc integer NOT NULL,
    scc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.scc OWNER TO postgres;

--
-- TOC entry 340 (class 1259 OID 2452467)
-- Name: slt; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.slt (
    slt integer NOT NULL,
    slt_desc character varying(80)
);


ALTER TABLE catalogo_objetos.slt OWNER TO postgres;

--
-- TOC entry 341 (class 1259 OID 2452470)
-- Name: smc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.smc (
    smc integer NOT NULL,
    smc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.smc OWNER TO postgres;

--
-- TOC entry 452 (class 1259 OID 3372927)
-- Name: tfc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.tfc (
    tfc integer NOT NULL,
    tfc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.tfc OWNER TO postgres;

--
-- TOC entry 342 (class 1259 OID 2452473)
-- Name: tra; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.tra (
    tra integer NOT NULL,
    tra_desc character varying(80)
);


ALTER TABLE catalogo_objetos.tra OWNER TO postgres;

--
-- TOC entry 343 (class 1259 OID 2452476)
-- Name: tuc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.tuc (
    tuc integer NOT NULL,
    tuc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.tuc OWNER TO postgres;

--
-- TOC entry 344 (class 1259 OID 2452479)
-- Name: typ; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.typ (
    typ integer NOT NULL,
    typ_desc character varying(80)
);


ALTER TABLE catalogo_objetos.typ OWNER TO postgres;

--
-- TOC entry 345 (class 1259 OID 2452482)
-- Name: uuc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.uuc (
    uuc integer NOT NULL,
    uuc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.uuc OWNER TO postgres;

--
-- TOC entry 346 (class 1259 OID 2452485)
-- Name: wtc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.wtc (
    wtc integer NOT NULL,
    wtc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.wtc OWNER TO postgres;

--
-- TOC entry 347 (class 1259 OID 2452488)
-- Name: wti; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.wti (
    wti integer NOT NULL,
    wti_desc character varying(80)
);


ALTER TABLE catalogo_objetos.wti OWNER TO postgres;

--
-- TOC entry 512 (class 1259 OID 3376060)
-- Name: zona_sin_informacion_a; Type: TABLE; Schema: ct_miscelaneos; Owner: postgres
--

CREATE TABLE ct_miscelaneos.zona_sin_informacion_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'ZD020'::character varying NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'POLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'ZD020'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ct_miscelaneos.zona_sin_informacion_a OWNER TO postgres;

--
-- TOC entry 511 (class 1259 OID 3376059)
-- Name: zona_sin_informacion_a_gid_seq; Type: SEQUENCE; Schema: ct_miscelaneos; Owner: postgres
--

CREATE SEQUENCE ct_miscelaneos.zona_sin_informacion_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ct_miscelaneos.zona_sin_informacion_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8181 (class 0 OID 0)
-- Dependencies: 511
-- Name: zona_sin_informacion_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ct_miscelaneos; Owner: postgres
--

ALTER SEQUENCE ct_miscelaneos.zona_sin_informacion_a_gid_seq OWNED BY ct_miscelaneos.zona_sin_informacion_a.gid;


--
-- TOC entry 507 (class 1259 OID 3375809)
-- Name: limite_administrativo_l; Type: TABLE; Schema: d_limite_politico_administrativo; Owner: postgres
--

CREATE TABLE d_limite_politico_administrativo.limite_administrativo_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'FA000'::character varying NOT NULL,
    nm3 character varying(80),
    fuente character varying(250),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'FA000'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE d_limite_politico_administrativo.limite_administrativo_l OWNER TO postgres;

--
-- TOC entry 506 (class 1259 OID 3375808)
-- Name: limite_administrativo_l_gid_seq; Type: SEQUENCE; Schema: d_limite_politico_administrativo; Owner: postgres
--

CREATE SEQUENCE d_limite_politico_administrativo.limite_administrativo_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE d_limite_politico_administrativo.limite_administrativo_l_gid_seq OWNER TO postgres;

--
-- TOC entry 8182 (class 0 OID 0)
-- Dependencies: 506
-- Name: limite_administrativo_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: d_limite_politico_administrativo; Owner: postgres
--

ALTER SEQUENCE d_limite_politico_administrativo.limite_administrativo_l_gid_seq OWNED BY d_limite_politico_administrativo.limite_administrativo_l.gid;


--
-- TOC entry 541 (class 1259 OID 3484355)
-- Name: zona_administrativa_a; Type: TABLE; Schema: d_limite_politico_administrativo; Owner: postgres
--

CREATE TABLE d_limite_politico_administrativo.zona_administrativa_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'FA001'::character varying NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    name character varying(80),
    dpa_despro character varying(40),
    dpa_descan character varying(80),
    dpa_despar character varying(80),
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'POLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'FA001'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE d_limite_politico_administrativo.zona_administrativa_a OWNER TO postgres;

--
-- TOC entry 8183 (class 0 OID 0)
-- Dependencies: 541
-- Name: COLUMN zona_administrativa_a.txt; Type: COMMENT; Schema: d_limite_politico_administrativo; Owner: postgres
--

COMMENT ON COLUMN d_limite_politico_administrativo.zona_administrativa_a.txt IS 'Texto Asociado';


--
-- TOC entry 8184 (class 0 OID 0)
-- Dependencies: 541
-- Name: COLUMN zona_administrativa_a.name; Type: COMMENT; Schema: d_limite_politico_administrativo; Owner: postgres
--

COMMENT ON COLUMN d_limite_politico_administrativo.zona_administrativa_a.name IS 'Nombre';


--
-- TOC entry 8185 (class 0 OID 0)
-- Dependencies: 541
-- Name: COLUMN zona_administrativa_a.dpa_despro; Type: COMMENT; Schema: d_limite_politico_administrativo; Owner: postgres
--

COMMENT ON COLUMN d_limite_politico_administrativo.zona_administrativa_a.dpa_despro IS 'Nombre de la provincia.';


--
-- TOC entry 8186 (class 0 OID 0)
-- Dependencies: 541
-- Name: COLUMN zona_administrativa_a.dpa_descan; Type: COMMENT; Schema: d_limite_politico_administrativo; Owner: postgres
--

COMMENT ON COLUMN d_limite_politico_administrativo.zona_administrativa_a.dpa_descan IS 'Nombre del cantón.';


--
-- TOC entry 8187 (class 0 OID 0)
-- Dependencies: 541
-- Name: COLUMN zona_administrativa_a.dpa_despar; Type: COMMENT; Schema: d_limite_politico_administrativo; Owner: postgres
--

COMMENT ON COLUMN d_limite_politico_administrativo.zona_administrativa_a.dpa_despar IS 'Nombre de la parroquia';


--
-- TOC entry 540 (class 1259 OID 3484354)
-- Name: zona_administrativa_a_gid_seq; Type: SEQUENCE; Schema: d_limite_politico_administrativo; Owner: postgres
--

CREATE SEQUENCE d_limite_politico_administrativo.zona_administrativa_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE d_limite_politico_administrativo.zona_administrativa_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8188 (class 0 OID 0)
-- Dependencies: 540
-- Name: zona_administrativa_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: d_limite_politico_administrativo; Owner: postgres
--

ALTER SEQUENCE d_limite_politico_administrativo.zona_administrativa_a_gid_seq OWNED BY d_limite_politico_administrativo.zona_administrativa_a.gid;


--
-- TOC entry 348 (class 1259 OID 2452491)
-- Name: punto_control_p; Type: TABLE; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE TABLE d_linderos_propiedad.punto_control_p (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'ZB050'::character varying NOT NULL,
    acc integer NOT NULL,
    ela integer NOT NULL,
    zvh double precision,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'POINT'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'ZB050'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE d_linderos_propiedad.punto_control_p OWNER TO postgres;

--
-- TOC entry 8189 (class 0 OID 0)
-- Dependencies: 348
-- Name: TABLE punto_control_p; Type: COMMENT; Schema: d_linderos_propiedad; Owner: postgres
--

COMMENT ON TABLE d_linderos_propiedad.punto_control_p IS 'Objeto en el terreno de ubicación conocida, donde se ha determinado las coordenadas horizontal y/o vertical por métodos geodésicos o topográficos.';


--
-- TOC entry 349 (class 1259 OID 2452502)
-- Name: vertice_geodesico_p_gid_seq; Type: SEQUENCE; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE SEQUENCE d_linderos_propiedad.vertice_geodesico_p_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE d_linderos_propiedad.vertice_geodesico_p_gid_seq OWNER TO postgres;

--
-- TOC entry 8190 (class 0 OID 0)
-- Dependencies: 349
-- Name: vertice_geodesico_p_gid_seq; Type: SEQUENCE OWNED BY; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER SEQUENCE d_linderos_propiedad.vertice_geodesico_p_gid_seq OWNED BY d_linderos_propiedad.punto_control_p.gid;


--
-- TOC entry 350 (class 1259 OID 2452503)
-- Name: cementerio_a; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.cementerio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL030'::character varying NOT NULL,
    nam character varying(80),
    rel integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.cementerio_a OWNER TO postgres;

--
-- TOC entry 8191 (class 0 OID 0)
-- Dependencies: 350
-- Name: TABLE cementerio_a; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.cementerio_a IS 'Sitio de estructuras asociadas, utilizadas para el entierro de muertos.';


--
-- TOC entry 351 (class 1259 OID 2452514)
-- Name: cementerio_a_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.cementerio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.cementerio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8192 (class 0 OID 0)
-- Dependencies: 351
-- Name: cementerio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.cementerio_a_gid_seq OWNED BY gs_asociado_poblados.cementerio_a.gid;


--
-- TOC entry 352 (class 1259 OID 2452515)
-- Name: cerca_l; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.cerca_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL070'::character varying NOT NULL,
    fti integer NOT NULL,
    wti integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL070'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.cerca_l OWNER TO postgres;

--
-- TOC entry 8193 (class 0 OID 0)
-- Dependencies: 352
-- Name: TABLE cerca_l; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.cerca_l IS 'Barrera artificial construida por el hombre, de estructura relativamente liviana y que es utilizada como cercado o límite.';


--
-- TOC entry 353 (class 1259 OID 2452526)
-- Name: cerca_l_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.cerca_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.cerca_l_gid_seq OWNER TO postgres;

--
-- TOC entry 8194 (class 0 OID 0)
-- Dependencies: 353
-- Name: cerca_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.cerca_l_gid_seq OWNED BY gs_asociado_poblados.cerca_l.gid;


--
-- TOC entry 454 (class 1259 OID 3373061)
-- Name: choza_a; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.choza_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL099'::character varying NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL099'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.choza_a OWNER TO postgres;

--
-- TOC entry 8195 (class 0 OID 0)
-- Dependencies: 454
-- Name: TABLE choza_a; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.choza_a IS 'Construcción rústica, pequeña, sencilla e independiente que por lo general tiene una sola habitación individual multifunción.';


--
-- TOC entry 453 (class 1259 OID 3373060)
-- Name: choza_a_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.choza_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.choza_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8196 (class 0 OID 0)
-- Dependencies: 453
-- Name: choza_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.choza_a_gid_seq OWNED BY gs_asociado_poblados.choza_a.gid;


--
-- TOC entry 354 (class 1259 OID 2452527)
-- Name: escalinata_a; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.escalinata_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ150'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ150'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.escalinata_a OWNER TO postgres;

--
-- TOC entry 8197 (class 0 OID 0)
-- Dependencies: 354
-- Name: TABLE escalinata_a; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.escalinata_a IS 'Serie de escalones que sirven para subir a un plano más elevado o para bajar a un plano inferior. Para fines catastrales se levantarán únicamente las escalinatas públicas que permitan identificar el lindero de un predio.';


--
-- TOC entry 355 (class 1259 OID 2452538)
-- Name: escalinata_a_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.escalinata_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.escalinata_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8198 (class 0 OID 0)
-- Dependencies: 355
-- Name: escalinata_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.escalinata_a_gid_seq OWNED BY gs_asociado_poblados.escalinata_a.gid;


--
-- TOC entry 515 (class 1259 OID 3376095)
-- Name: muro_a; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.muro_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL260'::character varying NOT NULL,
    wti integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'POLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL260'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.muro_a OWNER TO postgres;

--
-- TOC entry 514 (class 1259 OID 3376094)
-- Name: muro_a_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.muro_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.muro_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8199 (class 0 OID 0)
-- Dependencies: 514
-- Name: muro_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.muro_a_gid_seq OWNED BY gs_asociado_poblados.muro_a.gid;


--
-- TOC entry 356 (class 1259 OID 2452539)
-- Name: muro_l; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.muro_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL260'::character varying NOT NULL,
    wti integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL260'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.muro_l OWNER TO postgres;

--
-- TOC entry 8200 (class 0 OID 0)
-- Dependencies: 356
-- Name: TABLE muro_l; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.muro_l IS 'Barrera hecha por el hombre de material resistente y que es utilizado como límite o para protección. Es aquel objeto que permite identificar el lindero de un predio.';


--
-- TOC entry 357 (class 1259 OID 2452550)
-- Name: muro_l_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.muro_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.muro_l_gid_seq OWNER TO postgres;

--
-- TOC entry 8201 (class 0 OID 0)
-- Dependencies: 357
-- Name: muro_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.muro_l_gid_seq OWNED BY gs_asociado_poblados.muro_l.gid;


--
-- TOC entry 358 (class 1259 OID 2452551)
-- Name: plaza_publica_a; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.plaza_publica_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL170'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL170'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.plaza_publica_a OWNER TO postgres;

--
-- TOC entry 8202 (class 0 OID 0)
-- Dependencies: 358
-- Name: TABLE plaza_publica_a; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.plaza_publica_a IS 'Sitio abierto que sirve como lugar de reunión pública, en una zona poblada para diversos usos.';


--
-- TOC entry 359 (class 1259 OID 2452562)
-- Name: plaza_publica_a_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.plaza_publica_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.plaza_publica_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8203 (class 0 OID 0)
-- Dependencies: 359
-- Name: plaza_publica_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.plaza_publica_a_gid_seq OWNED BY gs_asociado_poblados.plaza_publica_a.gid;


--
-- TOC entry 501 (class 1259 OID 3375731)
-- Name: estructura_no_construida_a; Type: TABLE; Schema: gs_comercio; Owner: postgres
--

CREATE TABLE gs_comercio.estructura_no_construida_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL014'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'POLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL014'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_comercio.estructura_no_construida_a OWNER TO postgres;

--
-- TOC entry 500 (class 1259 OID 3375730)
-- Name: estructura_no_construida_a_gid_seq; Type: SEQUENCE; Schema: gs_comercio; Owner: postgres
--

CREATE SEQUENCE gs_comercio.estructura_no_construida_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_comercio.estructura_no_construida_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8204 (class 0 OID 0)
-- Dependencies: 500
-- Name: estructura_no_construida_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_comercio; Owner: postgres
--

ALTER SEQUENCE gs_comercio.estructura_no_construida_a_gid_seq OWNED BY gs_comercio.estructura_no_construida_a.gid;


--
-- TOC entry 503 (class 1259 OID 3375762)
-- Name: instalacion_a; Type: TABLE; Schema: gs_comercio; Owner: postgres
--

CREATE TABLE gs_comercio.instalacion_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL011'::character varying NOT NULL,
    nam character varying(80),
    ffn integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'POLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL011'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_comercio.instalacion_a OWNER TO postgres;

--
-- TOC entry 502 (class 1259 OID 3375761)
-- Name: instalacion_a_gid_seq; Type: SEQUENCE; Schema: gs_comercio; Owner: postgres
--

CREATE SEQUENCE gs_comercio.instalacion_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_comercio.instalacion_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8205 (class 0 OID 0)
-- Dependencies: 502
-- Name: instalacion_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_comercio; Owner: postgres
--

ALTER SEQUENCE gs_comercio.instalacion_a_gid_seq OWNED BY gs_comercio.instalacion_a.gid;


--
-- TOC entry 456 (class 1259 OID 3373130)
-- Name: edificio_a; Type: TABLE; Schema: gs_construcciones; Owner: postgres
--

CREATE TABLE gs_construcciones.edificio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL015'::character varying NOT NULL,
    nam character varying(200),
    acc integer NOT NULL,
    psf integer NOT NULL,
    res integer NOT NULL,
    tfc integer NOT NULL,
    uuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry(MultiPolygon,32618) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL015'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_construcciones.edificio_a OWNER TO postgres;

--
-- TOC entry 8206 (class 0 OID 0)
-- Dependencies: 456
-- Name: TABLE edificio_a; Type: COMMENT; Schema: gs_construcciones; Owner: postgres
--

COMMENT ON TABLE gs_construcciones.edificio_a IS 'Construcción independiente, techada, generalmente con paredes; destinada al hábitat y/o actividades de personas. Para fines catastrales se incluye choza, misma que deberá ser catalogada en el atributo txt como "Choza".';


--
-- TOC entry 455 (class 1259 OID 3373129)
-- Name: edificio_a_gid_seq; Type: SEQUENCE; Schema: gs_construcciones; Owner: postgres
--

CREATE SEQUENCE gs_construcciones.edificio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_construcciones.edificio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8207 (class 0 OID 0)
-- Dependencies: 455
-- Name: edificio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_construcciones; Owner: postgres
--

ALTER SEQUENCE gs_construcciones.edificio_a_gid_seq OWNED BY gs_construcciones.edificio_a.gid;


--
-- TOC entry 360 (class 1259 OID 2452575)
-- Name: cancha_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.cancha_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK040'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    kos integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK040'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.cancha_a OWNER TO postgres;

--
-- TOC entry 8208 (class 0 OID 0)
-- Dependencies: 360
-- Name: TABLE cancha_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.cancha_a IS 'Lugar al aire libre destinado a eventos deportivos, ejercicio o juegos.';


--
-- TOC entry 361 (class 1259 OID 2452586)
-- Name: cancha_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.cancha_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.cancha_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8209 (class 0 OID 0)
-- Dependencies: 361
-- Name: cancha_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.cancha_a_gid_seq OWNED BY gs_recreacion.cancha_a.gid;


--
-- TOC entry 362 (class 1259 OID 2452587)
-- Name: estadio_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.estadio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK165'::character varying NOT NULL,
    nam character varying(80),
    acc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK165'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.estadio_a OWNER TO postgres;

--
-- TOC entry 8210 (class 0 OID 0)
-- Dependencies: 362
-- Name: TABLE estadio_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.estadio_a IS 'Campo deportivo parcial o totalmente rodeado por una estructura diseñada para permitir a los espectadores ver un evento de pie o sentados; a menudo diseñados en forma y tamaño para dar cabida a deportes específicos (por ejemplo: el fútbol).';


--
-- TOC entry 363 (class 1259 OID 2452598)
-- Name: estadio_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.estadio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.estadio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8211 (class 0 OID 0)
-- Dependencies: 363
-- Name: estadio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.estadio_a_gid_seq OWNED BY gs_recreacion.estadio_a.gid;


--
-- TOC entry 364 (class 1259 OID 2452599)
-- Name: parque_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.parque_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK120'::character varying NOT NULL,
    nam character varying(80),
    fuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK120'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.parque_a OWNER TO postgres;

--
-- TOC entry 8212 (class 0 OID 0)
-- Dependencies: 364
-- Name: TABLE parque_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.parque_a IS 'Área utilizada con propósitos recreacionales u ornamentales.';


--
-- TOC entry 365 (class 1259 OID 2452610)
-- Name: parque_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.parque_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.parque_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8213 (class 0 OID 0)
-- Dependencies: 365
-- Name: parque_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.parque_a_gid_seq OWNED BY gs_recreacion.parque_a.gid;


--
-- TOC entry 467 (class 1259 OID 3373597)
-- Name: paseo_maritimo_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.paseo_maritimo_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK165'::character varying NOT NULL,
    nam character varying(80),
    mcc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK190'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.paseo_maritimo_a OWNER TO postgres;

--
-- TOC entry 8214 (class 0 OID 0)
-- Dependencies: 467
-- Name: TABLE paseo_maritimo_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.paseo_maritimo_a IS 'Estructura que se extiende en el agua utilizada con propósitos recreacionales, no pretende ser un lugar de atraque de buques.';


--
-- TOC entry 466 (class 1259 OID 3373596)
-- Name: paseo_maritimo_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.paseo_maritimo_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.paseo_maritimo_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8215 (class 0 OID 0)
-- Dependencies: 466
-- Name: paseo_maritimo_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.paseo_maritimo_a_gid_seq OWNED BY gs_recreacion.paseo_maritimo_a.gid;


--
-- TOC entry 366 (class 1259 OID 2452611)
-- Name: piscina_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.piscina_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK170'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK170'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.piscina_a OWNER TO postgres;

--
-- TOC entry 8216 (class 0 OID 0)
-- Dependencies: 366
-- Name: TABLE piscina_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.piscina_a IS 'Construcción destinada a contener agua con fines de recreación y natación.';


--
-- TOC entry 367 (class 1259 OID 2452622)
-- Name: piscina_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.piscina_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.piscina_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8217 (class 0 OID 0)
-- Dependencies: 367
-- Name: piscina_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.piscina_a_gid_seq OWNED BY gs_recreacion.piscina_a.gid;


--
-- TOC entry 368 (class 1259 OID 2452623)
-- Name: plaza_toros_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.plaza_toros_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK166'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK166'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.plaza_toros_a OWNER TO postgres;

--
-- TOC entry 8218 (class 0 OID 0)
-- Dependencies: 368
-- Name: TABLE plaza_toros_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.plaza_toros_a IS 'Construcción generalmente circular u ovalada, de cielo abierto, rodeada por graderíos para los espectadores.';


--
-- TOC entry 369 (class 1259 OID 2452634)
-- Name: plaza_toros_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.plaza_toros_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.plaza_toros_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8219 (class 0 OID 0)
-- Dependencies: 369
-- Name: plaza_toros_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.plaza_toros_a_gid_seq OWNED BY gs_recreacion.plaza_toros_a.gid;


--
-- TOC entry 459 (class 1259 OID 3373202)
-- Name: recinto_ferial_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.recinto_ferial_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK090'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK090'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.recinto_ferial_a OWNER TO postgres;

--
-- TOC entry 8220 (class 0 OID 0)
-- Dependencies: 459
-- Name: TABLE recinto_ferial_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.recinto_ferial_a IS 'Área donde existen instalaciones permanentes al aire libre para realizar ferias, circos o exhibiciones.';


--
-- TOC entry 458 (class 1259 OID 3373201)
-- Name: recinto_ferial_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.recinto_ferial_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.recinto_ferial_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8221 (class 0 OID 0)
-- Dependencies: 458
-- Name: recinto_ferial_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.recinto_ferial_a_gid_seq OWNED BY gs_recreacion.recinto_ferial_a.gid;


--
-- TOC entry 462 (class 1259 OID 3373241)
-- Name: sitio_arqueologico_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.sitio_arqueologico_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL012'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL012'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.sitio_arqueologico_a OWNER TO postgres;

--
-- TOC entry 8222 (class 0 OID 0)
-- Dependencies: 462
-- Name: TABLE sitio_arqueologico_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.sitio_arqueologico_a IS 'Sitio donde se ha descubierto la existencia de restos de civilizaciones ancestrales o actividades humanas.';


--
-- TOC entry 461 (class 1259 OID 3373240)
-- Name: sitio_arqueologico_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.sitio_arqueologico_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.sitio_arqueologico_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8223 (class 0 OID 0)
-- Dependencies: 461
-- Name: sitio_arqueologico_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.sitio_arqueologico_a_gid_seq OWNED BY gs_recreacion.sitio_arqueologico_a.gid;


--
-- TOC entry 465 (class 1259 OID 3373528)
-- Name: zoologico_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.zoologico_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK180'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK180'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.zoologico_a OWNER TO postgres;

--
-- TOC entry 8224 (class 0 OID 0)
-- Dependencies: 465
-- Name: TABLE zoologico_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.zoologico_a IS 'Lugar donde los animales, generalmente salvajes, se mantienen en exposición al público, pueden reproducirse y ser estudiados.';


--
-- TOC entry 464 (class 1259 OID 3373527)
-- Name: zoologico_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.zoologico_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.zoologico_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8225 (class 0 OID 0)
-- Dependencies: 464
-- Name: zoologico_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.zoologico_a_gid_seq OWNED BY gs_recreacion.zoologico_a.gid;


--
-- TOC entry 518 (class 1259 OID 3376136)
-- Name: acequia_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.acequia_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH030'::character varying NOT NULL,
    hyp integer NOT NULL,
    dit integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'POLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.acequia_a OWNER TO postgres;

--
-- TOC entry 517 (class 1259 OID 3376135)
-- Name: acequia_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.acequia_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.acequia_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8226 (class 0 OID 0)
-- Dependencies: 517
-- Name: acequia_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.acequia_a_gid_seq OWNED BY ho_aguas_interiores.acequia_a.gid;


--
-- TOC entry 370 (class 1259 OID 2452635)
-- Name: acequia_l; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.acequia_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH030'::character varying NOT NULL,
    hyp integer NOT NULL,
    dit integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.acequia_l OWNER TO postgres;

--
-- TOC entry 8227 (class 0 OID 0)
-- Dependencies: 370
-- Name: TABLE acequia_l; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.acequia_l IS 'Excavación poco profunda construida en tierra con propósitos de drenaje o irrigación. Se debe levantar los dos lados de la acequia, no únicamente el eje. ';


--
-- TOC entry 371 (class 1259 OID 2452646)
-- Name: acequia_l_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.acequia_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.acequia_l_gid_seq OWNER TO postgres;

--
-- TOC entry 8228 (class 0 OID 0)
-- Dependencies: 371
-- Name: acequia_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.acequia_l_gid_seq OWNED BY ho_aguas_interiores.acequia_l.gid;


--
-- TOC entry 372 (class 1259 OID 2452647)
-- Name: acueducto_canal_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.acueducto_canal_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH010'::character varying NOT NULL,
    atc integer NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.acueducto_canal_a OWNER TO postgres;

--
-- TOC entry 8229 (class 0 OID 0)
-- Dependencies: 372
-- Name: TABLE acueducto_canal_a; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.acueducto_canal_a IS 'Cauce artificial que transporta agua en forma de flujo continuo desde un lugar en el que ésta es accesible para consumo u otros usos. ';


--
-- TOC entry 373 (class 1259 OID 2452658)
-- Name: acueducto_canal_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.acueducto_canal_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.acueducto_canal_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8230 (class 0 OID 0)
-- Dependencies: 373
-- Name: acueducto_canal_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.acueducto_canal_a_gid_seq OWNED BY ho_aguas_interiores.acueducto_canal_a.gid;


--
-- TOC entry 520 (class 1259 OID 3376170)
-- Name: acueducto_canal_l; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.acueducto_canal_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH010'::character varying NOT NULL,
    atc integer NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.acueducto_canal_l OWNER TO postgres;

--
-- TOC entry 519 (class 1259 OID 3376169)
-- Name: acueducto_canal_l_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.acueducto_canal_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.acueducto_canal_l_gid_seq OWNER TO postgres;

--
-- TOC entry 8231 (class 0 OID 0)
-- Dependencies: 519
-- Name: acueducto_canal_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.acueducto_canal_l_gid_seq OWNED BY ho_aguas_interiores.acueducto_canal_l.gid;


--
-- TOC entry 470 (class 1259 OID 3373652)
-- Name: estanque_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.estanque_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH081'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH081'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.estanque_a OWNER TO postgres;

--
-- TOC entry 8232 (class 0 OID 0)
-- Dependencies: 470
-- Name: TABLE estanque_a; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.estanque_a IS 'Depósito construido para recolección o almacenamiento de agua para consumo humano o agropecuario.';


--
-- TOC entry 469 (class 1259 OID 3373651)
-- Name: estanque_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.estanque_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.estanque_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8233 (class 0 OID 0)
-- Dependencies: 469
-- Name: estanque_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.estanque_a_gid_seq OWNED BY ho_aguas_interiores.estanque_a.gid;


--
-- TOC entry 374 (class 1259 OID 2452659)
-- Name: lago_laguna_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.lago_laguna_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH080'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH080'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.lago_laguna_a OWNER TO postgres;

--
-- TOC entry 8234 (class 0 OID 0)
-- Dependencies: 374
-- Name: TABLE lago_laguna_a; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.lago_laguna_a IS 'Cuerpo de agua, dulce o salada que se encuentra rodeada por tierra.';


--
-- TOC entry 375 (class 1259 OID 2452670)
-- Name: lago_laguna_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.lago_laguna_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.lago_laguna_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8235 (class 0 OID 0)
-- Dependencies: 375
-- Name: lago_laguna_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.lago_laguna_a_gid_seq OWNED BY ho_aguas_interiores.lago_laguna_a.gid;


--
-- TOC entry 473 (class 1259 OID 3373692)
-- Name: presa_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.presa_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BI020'::character varying NOT NULL,
    nam character varying(100),
    mcc integer NOT NULL,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry(MultiPolygon,32618) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BI020'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.presa_a OWNER TO postgres;

--
-- TOC entry 8236 (class 0 OID 0)
-- Dependencies: 473
-- Name: TABLE presa_a; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.presa_a IS 'Estructura generalmente de cemento armado, construida a través de un río, arroyo o canal  para contener o controlar el caudal.';


--
-- TOC entry 472 (class 1259 OID 3373691)
-- Name: presa_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.presa_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.presa_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8237 (class 0 OID 0)
-- Dependencies: 472
-- Name: presa_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.presa_a_gid_seq OWNED BY ho_aguas_interiores.presa_a.gid;


--
-- TOC entry 526 (class 1259 OID 3376264)
-- Name: presa_l; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.presa_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BI020'::character varying NOT NULL,
    nam character varying(80),
    mcc integer NOT NULL,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BI020'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.presa_l OWNER TO postgres;

--
-- TOC entry 525 (class 1259 OID 3376263)
-- Name: presa_l_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.presa_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.presa_l_gid_seq OWNER TO postgres;

--
-- TOC entry 8238 (class 0 OID 0)
-- Dependencies: 525
-- Name: presa_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.presa_l_gid_seq OWNED BY ho_aguas_interiores.presa_l.gid;


--
-- TOC entry 376 (class 1259 OID 2452671)
-- Name: rio_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.rio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH140'::character varying NOT NULL,
    nam character varying(100),
    na2 character varying(80),
    acc integer NOT NULL,
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH140'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.rio_a OWNER TO postgres;

--
-- TOC entry 8239 (class 0 OID 0)
-- Dependencies: 376
-- Name: TABLE rio_a; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.rio_a IS 'Curso de agua que fluye naturalmente.';


--
-- TOC entry 377 (class 1259 OID 2452682)
-- Name: rio_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.rio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.rio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8240 (class 0 OID 0)
-- Dependencies: 377
-- Name: rio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.rio_a_gid_seq OWNED BY ho_aguas_interiores.rio_a.gid;


--
-- TOC entry 378 (class 1259 OID 2452683)
-- Name: rio_l; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.rio_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH140'::character varying NOT NULL,
    nam character varying(100),
    na2 character varying(80),
    acc integer NOT NULL,
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH140'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.rio_l OWNER TO postgres;

--
-- TOC entry 8241 (class 0 OID 0)
-- Dependencies: 378
-- Name: TABLE rio_l; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.rio_l IS 'Curso de agua que fluye naturalmente.';


--
-- TOC entry 379 (class 1259 OID 2452694)
-- Name: rio_l_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.rio_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.rio_l_gid_seq OWNER TO postgres;

--
-- TOC entry 8242 (class 0 OID 0)
-- Dependencies: 379
-- Name: rio_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.rio_l_gid_seq OWNED BY ho_aguas_interiores.rio_l.gid;


--
-- TOC entry 529 (class 1259 OID 3376309)
-- Name: zanja_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.zanja_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH100'::character varying NOT NULL,
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'POLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH100'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.zanja_a OWNER TO postgres;

--
-- TOC entry 528 (class 1259 OID 3376308)
-- Name: zanja_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.zanja_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.zanja_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8243 (class 0 OID 0)
-- Dependencies: 528
-- Name: zanja_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.zanja_a_gid_seq OWNED BY ho_aguas_interiores.zanja_a.gid;


--
-- TOC entry 380 (class 1259 OID 2452695)
-- Name: zanja_l; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.zanja_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH100'::character varying NOT NULL,
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH100'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.zanja_l OWNER TO postgres;

--
-- TOC entry 8244 (class 0 OID 0)
-- Dependencies: 380
-- Name: TABLE zanja_l; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.zanja_l IS 'Excavación larga y estrecha que se hace en la tierra para echar los cimientos, conducir las aguas, defender los sembríos o usos semejantes. Se debe levantar los dos lados de la zanja, no únicamente el eje. ';


--
-- TOC entry 381 (class 1259 OID 2452706)
-- Name: zanja_l_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.zanja_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.zanja_l_gid_seq OWNER TO postgres;

--
-- TOC entry 8245 (class 0 OID 0)
-- Dependencies: 381
-- Name: zanja_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.zanja_l_gid_seq OWNED BY ho_aguas_interiores.zanja_l.gid;


--
-- TOC entry 476 (class 1259 OID 3373735)
-- Name: malecon_a; Type: TABLE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE TABLE ho_puertos_muelles.malecon_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BB043'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BB043'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_puertos_muelles.malecon_a OWNER TO postgres;

--
-- TOC entry 8246 (class 0 OID 0)
-- Dependencies: 476
-- Name: TABLE malecon_a; Type: COMMENT; Schema: ho_puertos_muelles; Owner: postgres
--

COMMENT ON TABLE ho_puertos_muelles.malecon_a IS 'Murallón que corre paralelo a la orilla del mar o de un río, con la finalidad de proteger de las aguas.';


--
-- TOC entry 475 (class 1259 OID 3373734)
-- Name: malecon_a_gid_seq; Type: SEQUENCE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE SEQUENCE ho_puertos_muelles.malecon_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_puertos_muelles.malecon_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8247 (class 0 OID 0)
-- Dependencies: 475
-- Name: malecon_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER SEQUENCE ho_puertos_muelles.malecon_a_gid_seq OWNED BY ho_puertos_muelles.malecon_a.gid;


--
-- TOC entry 482 (class 1259 OID 3373844)
-- Name: malecon_l; Type: TABLE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE TABLE ho_puertos_muelles.malecon_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BB043'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry(LineString,32618) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BB043'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_puertos_muelles.malecon_l OWNER TO postgres;

--
-- TOC entry 8248 (class 0 OID 0)
-- Dependencies: 482
-- Name: TABLE malecon_l; Type: COMMENT; Schema: ho_puertos_muelles; Owner: postgres
--

COMMENT ON TABLE ho_puertos_muelles.malecon_l IS 'Murallón que corre paralelo a la orilla del mar o de un río, con la finalidad de proteger de las aguas.';


--
-- TOC entry 481 (class 1259 OID 3373843)
-- Name: malecon_l_gid_seq; Type: SEQUENCE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE SEQUENCE ho_puertos_muelles.malecon_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_puertos_muelles.malecon_l_gid_seq OWNER TO postgres;

--
-- TOC entry 8249 (class 0 OID 0)
-- Dependencies: 481
-- Name: malecon_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER SEQUENCE ho_puertos_muelles.malecon_l_gid_seq OWNED BY ho_puertos_muelles.malecon_l.gid;


--
-- TOC entry 479 (class 1259 OID 3373782)
-- Name: muelle_a; Type: TABLE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE TABLE ho_puertos_muelles.muelle_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BB190'::character varying NOT NULL,
    nam character varying(80),
    loc integer NOT NULL,
    pwc integer NOT NULL,
    fuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry(MultiPolygon,32618) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BB190'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_puertos_muelles.muelle_a OWNER TO postgres;

--
-- TOC entry 8250 (class 0 OID 0)
-- Dependencies: 479
-- Name: TABLE muelle_a; Type: COMMENT; Schema: ho_puertos_muelles; Owner: postgres
--

COMMENT ON TABLE ho_puertos_muelles.muelle_a IS 'Obra construida en un puerto de mar o en la orilla de un río navegable para facilitar las tareas de carga, descarga y para atracar los barcos.';


--
-- TOC entry 478 (class 1259 OID 3373781)
-- Name: muelle_a_gid_seq; Type: SEQUENCE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE SEQUENCE ho_puertos_muelles.muelle_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_puertos_muelles.muelle_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8251 (class 0 OID 0)
-- Dependencies: 478
-- Name: muelle_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER SEQUENCE ho_puertos_muelles.muelle_a_gid_seq OWNED BY ho_puertos_muelles.muelle_a.gid;


--
-- TOC entry 485 (class 1259 OID 3373877)
-- Name: muelle_l; Type: TABLE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE TABLE ho_puertos_muelles.muelle_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BB190'::character varying NOT NULL,
    nam character varying(80),
    loc integer NOT NULL,
    pwc integer NOT NULL,
    fuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry(LineString,32618) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BB190'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_puertos_muelles.muelle_l OWNER TO postgres;

--
-- TOC entry 8252 (class 0 OID 0)
-- Dependencies: 485
-- Name: TABLE muelle_l; Type: COMMENT; Schema: ho_puertos_muelles; Owner: postgres
--

COMMENT ON TABLE ho_puertos_muelles.muelle_l IS 'Obra construida en un puerto de mar o en la orilla de un río navegable para facilitar las tareas de carga, descarga y para atracar los barcos.';


--
-- TOC entry 484 (class 1259 OID 3373876)
-- Name: muelle_l_gid_seq; Type: SEQUENCE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE SEQUENCE ho_puertos_muelles.muelle_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_puertos_muelles.muelle_l_gid_seq OWNER TO postgres;

--
-- TOC entry 8253 (class 0 OID 0)
-- Dependencies: 484
-- Name: muelle_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER SEQUENCE ho_puertos_muelles.muelle_l_gid_seq OWNED BY ho_puertos_muelles.muelle_l.gid;


--
-- TOC entry 382 (class 1259 OID 2452707)
-- Name: puerto_a; Type: TABLE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE TABLE ho_puertos_muelles.puerto_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BB005'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BB005'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_puertos_muelles.puerto_a OWNER TO postgres;

--
-- TOC entry 8254 (class 0 OID 0)
-- Dependencies: 382
-- Name: TABLE puerto_a; Type: COMMENT; Schema: ho_puertos_muelles; Owner: postgres
--

COMMENT ON TABLE ho_puertos_muelles.puerto_a IS 'Conjunto de obras, instalaciones y servicios que proporcionan el espacio necesario para la estancia de los buques mientras realizan operaciones de carga, descarga, almacenaje y tránsito de pasajeros.';


--
-- TOC entry 383 (class 1259 OID 2452718)
-- Name: puerto_a_gid_seq; Type: SEQUENCE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE SEQUENCE ho_puertos_muelles.puerto_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_puertos_muelles.puerto_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8255 (class 0 OID 0)
-- Dependencies: 383
-- Name: puerto_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER SEQUENCE ho_puertos_muelles.puerto_a_gid_seq OWNED BY ho_puertos_muelles.puerto_a.gid;


--
-- TOC entry 384 (class 1259 OID 2452719)
-- Name: granja_acuatica_a; Type: TABLE; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH050'::character varying NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH050'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a OWNER TO postgres;

--
-- TOC entry 8256 (class 0 OID 0)
-- Dependencies: 384
-- Name: TABLE granja_acuatica_a; Type: COMMENT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

COMMENT ON TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a IS 'Área cerrada de agua utilizada para la reproducción o cría de camarones, peces y similares. ';


--
-- TOC entry 385 (class 1259 OID 2452730)
-- Name: granja_acuatica_a_gid_seq; Type: SEQUENCE; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE SEQUENCE ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8257 (class 0 OID 0)
-- Dependencies: 385
-- Name: granja_acuatica_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER SEQUENCE ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq OWNED BY ho_regulacion_zonas_restringidas.granja_acuatica_a.gid;


--
-- TOC entry 386 (class 1259 OID 2452731)
-- Name: isla_a; Type: TABLE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE TABLE ho_zonas_costeras.isla_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BA030'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BA030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_zonas_costeras.isla_a OWNER TO postgres;

--
-- TOC entry 8258 (class 0 OID 0)
-- Dependencies: 386
-- Name: TABLE isla_a; Type: COMMENT; Schema: ho_zonas_costeras; Owner: postgres
--

COMMENT ON TABLE ho_zonas_costeras.isla_a IS 'Masa de tierra más pequeña que un continente y que está rodeada por agua.';


--
-- TOC entry 387 (class 1259 OID 2452742)
-- Name: isla_a_gid_seq; Type: SEQUENCE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE SEQUENCE ho_zonas_costeras.isla_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_zonas_costeras.isla_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8259 (class 0 OID 0)
-- Dependencies: 387
-- Name: isla_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER SEQUENCE ho_zonas_costeras.isla_a_gid_seq OWNED BY ho_zonas_costeras.isla_a.gid;


--
-- TOC entry 388 (class 1259 OID 2452743)
-- Name: orilla_l; Type: TABLE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE TABLE ho_zonas_costeras.orilla_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BA010'::character varying NOT NULL,
    acc integer NOT NULL,
    slt integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BA010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_zonas_costeras.orilla_l OWNER TO postgres;

--
-- TOC entry 8260 (class 0 OID 0)
-- Dependencies: 388
-- Name: TABLE orilla_l; Type: COMMENT; Schema: ho_zonas_costeras; Owner: postgres
--

COMMENT ON TABLE ho_zonas_costeras.orilla_l IS 'Línea donde una superficie está en contacto con un cuerpo de agua. ';


--
-- TOC entry 389 (class 1259 OID 2452754)
-- Name: orilla_l_gid_seq; Type: SEQUENCE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE SEQUENCE ho_zonas_costeras.orilla_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_zonas_costeras.orilla_l_gid_seq OWNER TO postgres;

--
-- TOC entry 8261 (class 0 OID 0)
-- Dependencies: 389
-- Name: orilla_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER SEQUENCE ho_zonas_costeras.orilla_l_gid_seq OWNED BY ho_zonas_costeras.orilla_l.gid;


--
-- TOC entry 390 (class 1259 OID 2452755)
-- Name: invernadero_a; Type: TABLE; Schema: ii_agropecuaria; Owner: postgres
--

CREATE TABLE ii_agropecuaria.invernadero_a (
    gid integer DEFAULT nextval(('ii_agropecuaria.invernadero_a_gid_seq'::text)::regclass) NOT NULL,
    fcode character varying(5) DEFAULT 'AJ110'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AJ110'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ii_agropecuaria.invernadero_a OWNER TO postgres;

--
-- TOC entry 8262 (class 0 OID 0)
-- Dependencies: 390
-- Name: TABLE invernadero_a; Type: COMMENT; Schema: ii_agropecuaria; Owner: postgres
--

COMMENT ON TABLE ii_agropecuaria.invernadero_a IS 'Edificio construido principalmente de material transparente en el que la temperatura y la humedad puede ser controlada para el cultivo y/o protección de plantas.';


--
-- TOC entry 391 (class 1259 OID 2452767)
-- Name: invernadero_a_gid_seq; Type: SEQUENCE; Schema: ii_agropecuaria; Owner: postgres
--

CREATE SEQUENCE ii_agropecuaria.invernadero_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ii_agropecuaria.invernadero_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8263 (class 0 OID 0)
-- Dependencies: 391
-- Name: invernadero_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ii_agropecuaria; Owner: postgres
--

ALTER SEQUENCE ii_agropecuaria.invernadero_a_gid_seq OWNED BY ii_agropecuaria.invernadero_a.gid;


--
-- TOC entry 532 (class 1259 OID 3376343)
-- Name: invernadero_p; Type: TABLE; Schema: ii_agropecuaria; Owner: postgres
--

CREATE TABLE ii_agropecuaria.invernadero_p (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AJ110'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'POINT'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AJ110'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ii_agropecuaria.invernadero_p OWNER TO postgres;

--
-- TOC entry 8264 (class 0 OID 0)
-- Dependencies: 532
-- Name: TABLE invernadero_p; Type: COMMENT; Schema: ii_agropecuaria; Owner: postgres
--

COMMENT ON TABLE ii_agropecuaria.invernadero_p IS 'Edificio construido principalmente de material transparente en el que la temperatura y la humedad puede ser controlada para el cultivo y/o protección de plantas.';


--
-- TOC entry 531 (class 1259 OID 3376342)
-- Name: invernadero_p_gid_seq; Type: SEQUENCE; Schema: ii_agropecuaria; Owner: postgres
--

CREATE SEQUENCE ii_agropecuaria.invernadero_p_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ii_agropecuaria.invernadero_p_gid_seq OWNER TO postgres;

--
-- TOC entry 8265 (class 0 OID 0)
-- Dependencies: 531
-- Name: invernadero_p_gid_seq; Type: SEQUENCE OWNED BY; Schema: ii_agropecuaria; Owner: postgres
--

ALTER SEQUENCE ii_agropecuaria.invernadero_p_gid_seq OWNED BY ii_agropecuaria.invernadero_p.gid;


--
-- TOC entry 498 (class 1259 OID 3375680)
-- Name: tuberia_l; Type: TABLE; Schema: ii_estructura_asociada_industria; Owner: postgres
--

CREATE TABLE ii_estructura_asociada_industria.tuberia_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ113'::character varying NOT NULL,
    acc integer NOT NULL,
    loc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ113'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ii_estructura_asociada_industria.tuberia_l OWNER TO postgres;

--
-- TOC entry 497 (class 1259 OID 3375679)
-- Name: tuberia_l_gid_seq; Type: SEQUENCE; Schema: ii_estructura_asociada_industria; Owner: postgres
--

CREATE SEQUENCE ii_estructura_asociada_industria.tuberia_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ii_estructura_asociada_industria.tuberia_l_gid_seq OWNER TO postgres;

--
-- TOC entry 8266 (class 0 OID 0)
-- Dependencies: 497
-- Name: tuberia_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ii_estructura_asociada_industria; Owner: postgres
--

ALTER SEQUENCE ii_estructura_asociada_industria.tuberia_l_gid_seq OWNED BY ii_estructura_asociada_industria.tuberia_l.gid;


--
-- TOC entry 492 (class 1259 OID 3375515)
-- Name: campo_petroleo_gas_a; Type: TABLE; Schema: ii_extraccion; Owner: postgres
--

CREATE TABLE ii_extraccion.campo_petroleo_gas_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AA052'::character varying NOT NULL,
    txt character varying(250),
    the_geom public.geometry(Polygon,32618) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'POLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AA052'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ii_extraccion.campo_petroleo_gas_a OWNER TO postgres;

--
-- TOC entry 491 (class 1259 OID 3375514)
-- Name: campo_petroleo_gas_a_gid_seq; Type: SEQUENCE; Schema: ii_extraccion; Owner: postgres
--

CREATE SEQUENCE ii_extraccion.campo_petroleo_gas_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ii_extraccion.campo_petroleo_gas_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8267 (class 0 OID 0)
-- Dependencies: 491
-- Name: campo_petroleo_gas_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ii_extraccion; Owner: postgres
--

ALTER SEQUENCE ii_extraccion.campo_petroleo_gas_a_gid_seq OWNED BY ii_extraccion.campo_petroleo_gas_a.gid;


--
-- TOC entry 494 (class 1259 OID 3375572)
-- Name: cantera_a; Type: TABLE; Schema: ii_extraccion; Owner: postgres
--

CREATE TABLE ii_extraccion.cantera_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AA012'::character varying NOT NULL,
    nam character varying(80),
    acc integer NOT NULL,
    ppo integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'POLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AA012'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ii_extraccion.cantera_a OWNER TO postgres;

--
-- TOC entry 493 (class 1259 OID 3375571)
-- Name: cantera_a_gid_seq; Type: SEQUENCE; Schema: ii_extraccion; Owner: postgres
--

CREATE SEQUENCE ii_extraccion.cantera_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ii_extraccion.cantera_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8268 (class 0 OID 0)
-- Dependencies: 493
-- Name: cantera_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ii_extraccion; Owner: postgres
--

ALTER SEQUENCE ii_extraccion.cantera_a_gid_seq OWNED BY ii_extraccion.cantera_a.gid;


--
-- TOC entry 392 (class 1259 OID 2452804)
-- Name: parqueadero_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.parqueadero_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ140'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ140'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.parqueadero_a OWNER TO postgres;

--
-- TOC entry 8269 (class 0 OID 0)
-- Dependencies: 392
-- Name: TABLE parqueadero_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.parqueadero_a IS 'Lugar destinado generalmente para estacionar vehículos.';


--
-- TOC entry 393 (class 1259 OID 2452815)
-- Name: parqueadero_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.parqueadero_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.parqueadero_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8270 (class 0 OID 0)
-- Dependencies: 393
-- Name: parqueadero_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.parqueadero_a_gid_seq OWNED BY it_asociado_transportacion.parqueadero_a.gid;


--
-- TOC entry 394 (class 1259 OID 2452816)
-- Name: paseo_peatonal_ciclovia_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP031'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP031'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a OWNER TO postgres;

--
-- TOC entry 8271 (class 0 OID 0)
-- Dependencies: 394
-- Name: TABLE paseo_peatonal_ciclovia_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a IS 'Franja de terreno pavimentada o mejorada que tiene por objeto servir como una vía para peatones, animales y/o vehículos no motorizado.';


--
-- TOC entry 395 (class 1259 OID 2452827)
-- Name: paseo_peatonal_ciclovia_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8272 (class 0 OID 0)
-- Dependencies: 395
-- Name: paseo_peatonal_ciclovia_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq OWNED BY it_asociado_transportacion.paseo_peatonal_ciclovia_a.gid;


--
-- TOC entry 535 (class 1259 OID 3376404)
-- Name: paseo_peatonal_ciclovia_l; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP031'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP031'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_l OWNER TO postgres;

--
-- TOC entry 534 (class 1259 OID 3376403)
-- Name: paseo_peatonal_ciclovia_l_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.paseo_peatonal_ciclovia_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_l_gid_seq OWNER TO postgres;

--
-- TOC entry 8273 (class 0 OID 0)
-- Dependencies: 534
-- Name: paseo_peatonal_ciclovia_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.paseo_peatonal_ciclovia_l_gid_seq OWNED BY it_asociado_transportacion.paseo_peatonal_ciclovia_l.gid;


--
-- TOC entry 396 (class 1259 OID 2452828)
-- Name: tunel_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.tunel_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ130'::character varying NOT NULL,
    nam character varying(80),
    tra integer NOT NULL,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry(MultiPolygon,32618) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ130'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.tunel_a OWNER TO postgres;

--
-- TOC entry 8274 (class 0 OID 0)
-- Dependencies: 396
-- Name: TABLE tunel_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.tunel_a IS 'Paso subterráneo o submarino, abierto para establecer comunicación.';


--
-- TOC entry 397 (class 1259 OID 2452839)
-- Name: tunel_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.tunel_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.tunel_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8275 (class 0 OID 0)
-- Dependencies: 397
-- Name: tunel_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.tunel_a_gid_seq OWNED BY it_asociado_transportacion.tunel_a.gid;


--
-- TOC entry 398 (class 1259 OID 2452840)
-- Name: puente_a; Type: TABLE; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE TABLE it_cruces_enlaces.puente_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ040'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    acc integer NOT NULL,
    bsc integer NOT NULL,
    ltn integer NOT NULL,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ040'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_cruces_enlaces.puente_a OWNER TO postgres;

--
-- TOC entry 8276 (class 0 OID 0)
-- Dependencies: 398
-- Name: TABLE puente_a; Type: COMMENT; Schema: it_cruces_enlaces; Owner: postgres
--

COMMENT ON TABLE it_cruces_enlaces.puente_a IS 'Estructura que conecta dos lugares y facilita el paso de una ruta de transporte (por ejemplo: carretera o ferrocarril) sobre un obstáculo del terreno (por ejemplo: cuerpo de agua, barranco y/o carretera).';


--
-- TOC entry 399 (class 1259 OID 2452851)
-- Name: puente_a_gid_seq; Type: SEQUENCE; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE SEQUENCE it_cruces_enlaces.puente_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_cruces_enlaces.puente_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8277 (class 0 OID 0)
-- Dependencies: 399
-- Name: puente_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER SEQUENCE it_cruces_enlaces.puente_a_gid_seq OWNED BY it_cruces_enlaces.puente_a.gid;


--
-- TOC entry 489 (class 1259 OID 3374039)
-- Name: estacion_ferrocarril_a; Type: TABLE; Schema: it_ferrocarriles; Owner: postgres
--

CREATE TABLE it_ferrocarriles.estacion_ferrocarril_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AN070'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AN070'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_ferrocarriles.estacion_ferrocarril_a OWNER TO postgres;

--
-- TOC entry 8278 (class 0 OID 0)
-- Dependencies: 489
-- Name: TABLE estacion_ferrocarril_a; Type: COMMENT; Schema: it_ferrocarriles; Owner: postgres
--

COMMENT ON TABLE it_ferrocarriles.estacion_ferrocarril_a IS 'Instalación en la que los pasajeros pueden subir y bajar de los trenes y/o cargar y descargar mercancías del transporte ferroviario.';


--
-- TOC entry 488 (class 1259 OID 3374038)
-- Name: estacion_ferrocarril_a_gid_seq; Type: SEQUENCE; Schema: it_ferrocarriles; Owner: postgres
--

CREATE SEQUENCE it_ferrocarriles.estacion_ferrocarril_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_ferrocarriles.estacion_ferrocarril_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8279 (class 0 OID 0)
-- Dependencies: 488
-- Name: estacion_ferrocarril_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_ferrocarriles; Owner: postgres
--

ALTER SEQUENCE it_ferrocarriles.estacion_ferrocarril_a_gid_seq OWNED BY it_ferrocarriles.estacion_ferrocarril_a.gid;


--
-- TOC entry 538 (class 1259 OID 3376438)
-- Name: ferrocarril_l; Type: TABLE; Schema: it_ferrocarriles; Owner: postgres
--

CREATE TABLE it_ferrocarriles.ferrocarril_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AN010'::character varying NOT NULL,
    nam character varying(80),
    acc integer NOT NULL,
    loc integer NOT NULL,
    ltn integer NOT NULL,
    rgc integer NOT NULL,
    rra integer NOT NULL,
    rrc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AN010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_ferrocarriles.ferrocarril_l OWNER TO postgres;

--
-- TOC entry 537 (class 1259 OID 3376437)
-- Name: ferrocarril_l_gid_seq; Type: SEQUENCE; Schema: it_ferrocarriles; Owner: postgres
--

CREATE SEQUENCE it_ferrocarriles.ferrocarril_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_ferrocarriles.ferrocarril_l_gid_seq OWNER TO postgres;

--
-- TOC entry 8280 (class 0 OID 0)
-- Dependencies: 537
-- Name: ferrocarril_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_ferrocarriles; Owner: postgres
--

ALTER SEQUENCE it_ferrocarriles.ferrocarril_l_gid_seq OWNED BY it_ferrocarriles.ferrocarril_l.gid;


--
-- TOC entry 400 (class 1259 OID 2452864)
-- Name: gasolinera_a; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.gasolinera_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ170'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ170'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.gasolinera_a OWNER TO postgres;

--
-- TOC entry 8281 (class 0 OID 0)
-- Dependencies: 400
-- Name: TABLE gasolinera_a; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.gasolinera_a IS 'Establecimiento en el cual se vende combustible y lubricantes generalmente para vehículos de motor.';


--
-- TOC entry 401 (class 1259 OID 2452875)
-- Name: gasolinera_a_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.gasolinera_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.gasolinera_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8282 (class 0 OID 0)
-- Dependencies: 401
-- Name: gasolinera_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.gasolinera_a_gid_seq OWNED BY it_transporte_terrestre.gasolinera_a.gid;


--
-- TOC entry 402 (class 1259 OID 2452876)
-- Name: intercambiador_vial_a; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.intercambiador_vial_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP020'::character varying NOT NULL,
    nam character varying(80),
    hct integer NOT NULL,
    rst integer NOT NULL,
    loc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP020'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.intercambiador_vial_a OWNER TO postgres;

--
-- TOC entry 8283 (class 0 OID 0)
-- Dependencies: 402
-- Name: TABLE intercambiador_vial_a; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.intercambiador_vial_a IS 'Conexión diseñada para facilitar el acceso del tráfico de una carretera a otra.';


--
-- TOC entry 403 (class 1259 OID 2452887)
-- Name: intercambiador_vial_a_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.intercambiador_vial_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.intercambiador_vial_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8284 (class 0 OID 0)
-- Dependencies: 403
-- Name: intercambiador_vial_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.intercambiador_vial_a_gid_seq OWNED BY it_transporte_terrestre.intercambiador_vial_a.gid;


--
-- TOC entry 404 (class 1259 OID 2452888)
-- Name: rodera_l; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.rodera_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP010'::character varying NOT NULL,
    typ integer NOT NULL,
    rst integer NOT NULL,
    hct integer NOT NULL,
    rdt integer,
    wtc integer NOT NULL,
    ltn integer NOT NULL,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.rodera_l OWNER TO postgres;

--
-- TOC entry 8285 (class 0 OID 0)
-- Dependencies: 404
-- Name: TABLE rodera_l; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.rodera_l IS 'Vía natural con poca o ninguna mejora por la que pueden transitar vehículos de doble tracción.';


--
-- TOC entry 405 (class 1259 OID 2452899)
-- Name: rodera_l_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.rodera_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.rodera_l_gid_seq OWNER TO postgres;

--
-- TOC entry 8286 (class 0 OID 0)
-- Dependencies: 405
-- Name: rodera_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.rodera_l_gid_seq OWNED BY it_transporte_terrestre.rodera_l.gid;


--
-- TOC entry 406 (class 1259 OID 2452900)
-- Name: sendero_l; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.sendero_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP050'::character varying NOT NULL,
    wtc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP050'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.sendero_l OWNER TO postgres;

--
-- TOC entry 8287 (class 0 OID 0)
-- Dependencies: 406
-- Name: TABLE sendero_l; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.sendero_l IS 'Camino angosto abierto por el tránsito de personas o animales.';


--
-- TOC entry 407 (class 1259 OID 2452911)
-- Name: sendero_l_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.sendero_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.sendero_l_gid_seq OWNER TO postgres;

--
-- TOC entry 8288 (class 0 OID 0)
-- Dependencies: 407
-- Name: sendero_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.sendero_l_gid_seq OWNED BY it_transporte_terrestre.sendero_l.gid;


--
-- TOC entry 408 (class 1259 OID 2452912)
-- Name: via_ruta_a; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.via_ruta_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP030'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    acc integer NOT NULL,
    rst integer NOT NULL,
    typ integer NOT NULL,
    hct integer NOT NULL,
    loc integer NOT NULL,
    ltn integer NOT NULL,
    mes integer NOT NULL,
    rdt integer,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.via_ruta_a OWNER TO postgres;

--
-- TOC entry 8289 (class 0 OID 0)
-- Dependencies: 408
-- Name: TABLE via_ruta_a; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.via_ruta_a IS 'Trayecto con una superficie especialmente preparada que se mantiene para ser usada por vehículos generalmente a motor. ';


--
-- TOC entry 409 (class 1259 OID 2452923)
-- Name: via_ruta_a_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.via_ruta_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.via_ruta_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8290 (class 0 OID 0)
-- Dependencies: 409
-- Name: via_ruta_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.via_ruta_a_gid_seq OWNED BY it_transporte_terrestre.via_ruta_a.gid;


--
-- TOC entry 509 (class 1259 OID 3376016)
-- Name: base_militar_a; Type: TABLE; Schema: m_infraestructura_defensa_operaciones; Owner: postgres
--

CREATE TABLE m_infraestructura_defensa_operaciones.base_militar_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'SU001'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'POLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32618)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'SU001'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE m_infraestructura_defensa_operaciones.base_militar_a OWNER TO postgres;

--
-- TOC entry 508 (class 1259 OID 3376015)
-- Name: base_militar_a_gid_seq; Type: SEQUENCE; Schema: m_infraestructura_defensa_operaciones; Owner: postgres
--

CREATE SEQUENCE m_infraestructura_defensa_operaciones.base_militar_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE m_infraestructura_defensa_operaciones.base_militar_a_gid_seq OWNER TO postgres;

--
-- TOC entry 8291 (class 0 OID 0)
-- Dependencies: 508
-- Name: base_militar_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: m_infraestructura_defensa_operaciones; Owner: postgres
--

ALTER SEQUENCE m_infraestructura_defensa_operaciones.base_militar_a_gid_seq OWNED BY m_infraestructura_defensa_operaciones.base_militar_a.gid;


--
-- TOC entry 410 (class 1259 OID 2452924)
-- Name: qgis_projects; Type: TABLE; Schema: proyecto_qgis3; Owner: postgres
--

CREATE TABLE proyecto_qgis3.qgis_projects (
    name text NOT NULL,
    metadata jsonb,
    content bytea
);


ALTER TABLE proyecto_qgis3.qgis_projects OWNER TO postgres;

--
-- TOC entry 521 (class 1259 OID 3376202)
-- Name: acequia_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.acequia_a AS
 SELECT acequia_a.gid,
    acequia_a.fcode,
    catalogo_objetos.descripcion,
    hyp.hyp_desc,
    dit.dit_desc,
    acequia_a.txt,
    (acequia_a.the_geom)::public.geometry(Polygon,32618) AS the_geom
   FROM (((ho_aguas_interiores.acequia_a
     JOIN catalogo_objetos.catalogo_objetos ON (((acequia_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.hyp ON ((acequia_a.hyp = hyp.hyp)))
     JOIN catalogo_objetos.dit ON ((acequia_a.dit = dit.dit)));


ALTER TABLE visualizacion.acequia_a OWNER TO postgres;

--
-- TOC entry 411 (class 1259 OID 2452929)
-- Name: acequia_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.acequia_l AS
 SELECT acequia_l.gid,
    acequia_l.fcode,
    catalogo_objetos.descripcion,
    hyp.hyp_desc,
    dit.dit_desc,
    acequia_l.txt,
    (acequia_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM (((ho_aguas_interiores.acequia_l
     JOIN catalogo_objetos.hyp ON ((acequia_l.hyp = hyp.hyp)))
     JOIN catalogo_objetos.dit ON ((acequia_l.dit = dit.dit)))
     JOIN catalogo_objetos.catalogo_objetos ON (((acequia_l.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.acequia_l OWNER TO postgres;

--
-- TOC entry 412 (class 1259 OID 2452939)
-- Name: acueducto_canal_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.acueducto_canal_a AS
 SELECT acueducto_canal_a.gid,
    acueducto_canal_a.fcode,
    catalogo_objetos.descripcion,
    atc.atc_desc,
    smc.smc_desc,
    acueducto_canal_a.txt,
    (acueducto_canal_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (((ho_aguas_interiores.acueducto_canal_a
     JOIN catalogo_objetos.catalogo_objetos ON (((acueducto_canal_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.atc ON ((acueducto_canal_a.atc = atc.atc)))
     JOIN catalogo_objetos.smc ON ((acueducto_canal_a.smc = smc.smc)));


ALTER TABLE visualizacion.acueducto_canal_a OWNER TO postgres;

--
-- TOC entry 524 (class 1259 OID 3376256)
-- Name: acueducto_canal_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.acueducto_canal_l AS
 SELECT acueducto_canal_l.gid,
    acueducto_canal_l.fcode,
    catalogo_objetos.descripcion,
    atc.atc_desc,
    smc.smc_desc,
    acueducto_canal_l.txt,
    (acueducto_canal_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM (((ho_aguas_interiores.acueducto_canal_l
     JOIN catalogo_objetos.catalogo_objetos ON (((acueducto_canal_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.atc ON ((acueducto_canal_l.atc = atc.atc)))
     JOIN catalogo_objetos.smc ON ((acueducto_canal_l.smc = smc.smc)));


ALTER TABLE visualizacion.acueducto_canal_l OWNER TO postgres;

--
-- TOC entry 413 (class 1259 OID 2452944)
-- Name: aeropuerto_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.aeropuerto_a AS
 SELECT aeropuerto_a.gid,
    aeropuerto_a.fcode,
    catalogo_objetos.descripcion,
    aeropuerto_a.nam,
    acc.acc_desc,
    aeropuerto_a.iko,
    fuc.fuc_desc,
    aeropuerto_a.txt,
    (aeropuerto_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (((a_aeropuerto_superficie.aeropuerto_a
     JOIN catalogo_objetos.catalogo_objetos ON (((aeropuerto_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((aeropuerto_a.acc = acc.acc)))
     JOIN catalogo_objetos.fuc ON ((aeropuerto_a.fuc = fuc.fuc)));


ALTER TABLE visualizacion.aeropuerto_a OWNER TO postgres;

--
-- TOC entry 510 (class 1259 OID 3376044)
-- Name: base_militar_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.base_militar_a AS
 SELECT base_militar_a.gid,
    base_militar_a.fcode,
    catalogo_objetos.descripcion,
    base_militar_a.nam,
    base_militar_a.txt,
    (base_militar_a.the_geom)::public.geometry(Polygon,32618) AS the_geom
   FROM (m_infraestructura_defensa_operaciones.base_militar_a
     JOIN catalogo_objetos.catalogo_objetos ON (((base_militar_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.base_militar_a OWNER TO postgres;

--
-- TOC entry 495 (class 1259 OID 3375606)
-- Name: campo_petroleo_gas_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.campo_petroleo_gas_a AS
 SELECT campo_petroleo_gas_a.gid,
    campo_petroleo_gas_a.fcode,
    catalogo_objetos.descripcion,
    campo_petroleo_gas_a.txt,
    campo_petroleo_gas_a.the_geom
   FROM (ii_extraccion.campo_petroleo_gas_a
     JOIN catalogo_objetos.catalogo_objetos ON (((campo_petroleo_gas_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.campo_petroleo_gas_a OWNER TO postgres;

--
-- TOC entry 414 (class 1259 OID 2452954)
-- Name: cancha_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cancha_a AS
 SELECT cancha_a.gid,
    cancha_a.fcode,
    catalogo_objetos.descripcion,
    cancha_a.nam,
    smc.smc_desc,
    kos.kos_desc,
    cancha_a.txt,
    (cancha_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (((gs_recreacion.cancha_a
     JOIN catalogo_objetos.catalogo_objetos ON (((cancha_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((cancha_a.smc = smc.smc)))
     JOIN catalogo_objetos.kos ON ((cancha_a.kos = kos.kos)));


ALTER TABLE visualizacion.cancha_a OWNER TO postgres;

--
-- TOC entry 496 (class 1259 OID 3375617)
-- Name: cantera_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cantera_a AS
 SELECT cantera_a.gid,
    cantera_a.fcode,
    catalogo_objetos.descripcion,
    cantera_a.nam,
    acc.acc_desc,
    ppo.ppo_desc,
    cantera_a.txt,
    (cantera_a.the_geom)::public.geometry(Polygon,32618) AS the_geom
   FROM (((ii_extraccion.cantera_a
     JOIN catalogo_objetos.catalogo_objetos ON (((cantera_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((cantera_a.acc = acc.acc)))
     JOIN catalogo_objetos.ppo ON ((cantera_a.ppo = ppo.ppo)));


ALTER TABLE visualizacion.cantera_a OWNER TO postgres;

--
-- TOC entry 415 (class 1259 OID 2452959)
-- Name: cementerio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cementerio_a AS
 SELECT cementerio_a.gid,
    cementerio_a.fcode,
    catalogo_objetos.descripcion,
    cementerio_a.nam,
    rel.rel_desc,
    cementerio_a.txt,
    (cementerio_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((gs_asociado_poblados.cementerio_a
     JOIN catalogo_objetos.catalogo_objetos ON (((cementerio_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.rel ON ((cementerio_a.rel = rel.rel)));


ALTER TABLE visualizacion.cementerio_a OWNER TO postgres;

--
-- TOC entry 416 (class 1259 OID 2452964)
-- Name: cerca_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cerca_l AS
 SELECT cerca_l.gid,
    cerca_l.fcode,
    catalogo_objetos.descripcion,
    fti.fti_desc,
    wti.wti_desc,
    cerca_l.txt,
    (cerca_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM (((gs_asociado_poblados.cerca_l
     JOIN catalogo_objetos.catalogo_objetos ON (((cerca_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.fti ON ((cerca_l.fti = fti.fti)))
     JOIN catalogo_objetos.wti ON ((cerca_l.wti = wti.wti)));


ALTER TABLE visualizacion.cerca_l OWNER TO postgres;

--
-- TOC entry 522 (class 1259 OID 3376236)
-- Name: choza_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.choza_a AS
 SELECT choza_a.gid,
    choza_a.fcode,
    catalogo_objetos.descripcion,
    choza_a.txt,
    (choza_a.the_geom)::public.geometry(Polygon,32618) AS the_geom
   FROM (gs_asociado_poblados.choza_a
     JOIN catalogo_objetos.catalogo_objetos ON (((choza_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.choza_a OWNER TO postgres;

--
-- TOC entry 457 (class 1259 OID 3373164)
-- Name: edificio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.edificio_a AS
 SELECT edificio_a.gid,
    edificio_a.fcode,
    catalogo_objetos.descripcion,
    edificio_a.nam,
    acc.acc_desc,
    psf.psf_desc,
    res.res_desc,
    tfc.tfc_desc,
    uuc.uuc_desc,
    edificio_a.txt,
    edificio_a.the_geom
   FROM ((((((gs_construcciones.edificio_a
     JOIN catalogo_objetos.catalogo_objetos ON (((edificio_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((edificio_a.acc = acc.acc)))
     JOIN catalogo_objetos.psf ON ((edificio_a.psf = psf.psf)))
     JOIN catalogo_objetos.res ON ((edificio_a.res = res.res)))
     JOIN catalogo_objetos.tfc ON ((edificio_a.tfc = tfc.tfc)))
     JOIN catalogo_objetos.uuc ON ((edificio_a.uuc = uuc.uuc)));


ALTER TABLE visualizacion.edificio_a OWNER TO postgres;

--
-- TOC entry 417 (class 1259 OID 2452978)
-- Name: escalinata_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.escalinata_a AS
 SELECT escalinata_a.gid,
    escalinata_a.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    escalinata_a.txt,
    (escalinata_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((gs_asociado_poblados.escalinata_a
     JOIN catalogo_objetos.catalogo_objetos ON (((escalinata_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((escalinata_a.smc = smc.smc)));


ALTER TABLE visualizacion.escalinata_a OWNER TO postgres;

--
-- TOC entry 490 (class 1259 OID 3374062)
-- Name: estacion_ferrocarril_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.estacion_ferrocarril_a AS
 SELECT estacion_ferrocarril_a.gid,
    estacion_ferrocarril_a.fcode,
    catalogo_objetos.descripcion,
    estacion_ferrocarril_a.nam,
    estacion_ferrocarril_a.txt,
    (estacion_ferrocarril_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (it_ferrocarriles.estacion_ferrocarril_a
     JOIN catalogo_objetos.catalogo_objetos ON (((estacion_ferrocarril_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.estacion_ferrocarril_a OWNER TO postgres;

--
-- TOC entry 418 (class 1259 OID 2452983)
-- Name: estadio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.estadio_a AS
 SELECT estadio_a.gid,
    estadio_a.fcode,
    catalogo_objetos.descripcion,
    estadio_a.nam,
    acc.acc_desc,
    estadio_a.txt,
    (estadio_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((gs_recreacion.estadio_a
     JOIN catalogo_objetos.catalogo_objetos ON (((estadio_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((estadio_a.acc = acc.acc)));


ALTER TABLE visualizacion.estadio_a OWNER TO postgres;

--
-- TOC entry 471 (class 1259 OID 3373679)
-- Name: estanque_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.estanque_a AS
 SELECT estanque_a.gid,
    estanque_a.fcode,
    catalogo_objetos.descripcion,
    estanque_a.nam,
    estanque_a.txt,
    (estanque_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (ho_aguas_interiores.estanque_a
     JOIN catalogo_objetos.catalogo_objetos ON (((estanque_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.estanque_a OWNER TO postgres;

--
-- TOC entry 504 (class 1259 OID 3375794)
-- Name: estructura_no_construida_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.estructura_no_construida_a AS
 SELECT estructura_no_construida_a.gid,
    estructura_no_construida_a.fcode,
    catalogo_objetos.descripcion,
    estructura_no_construida_a.nam,
    smc.smc_desc,
    estructura_no_construida_a.txt,
    (estructura_no_construida_a.the_geom)::public.geometry(Polygon,32618) AS the_geom
   FROM ((gs_comercio.estructura_no_construida_a
     JOIN catalogo_objetos.catalogo_objetos ON (((estructura_no_construida_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((estructura_no_construida_a.smc = smc.smc)));


ALTER TABLE visualizacion.estructura_no_construida_a OWNER TO postgres;

--
-- TOC entry 539 (class 1259 OID 3376488)
-- Name: ferrocarril_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.ferrocarril_l AS
 SELECT ferrocarril_l.gid,
    ferrocarril_l.fcode,
    catalogo_objetos.descripcion,
    ferrocarril_l.nam,
    acc.acc_desc,
    loc.loc_desc,
    ferrocarril_l.ltn,
    rgc.rgc_desc,
    rra.rra_desc,
    rrc.rrc_desc,
    ferrocarril_l.txt,
    (ferrocarril_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM ((((((it_ferrocarriles.ferrocarril_l
     JOIN catalogo_objetos.catalogo_objetos ON (((ferrocarril_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((ferrocarril_l.acc = acc.acc)))
     JOIN catalogo_objetos.loc ON ((ferrocarril_l.loc = loc.loc)))
     JOIN catalogo_objetos.rgc ON ((ferrocarril_l.rgc = rgc.rgc)))
     JOIN catalogo_objetos.rra ON ((ferrocarril_l.rra = rra.rra)))
     JOIN catalogo_objetos.rrc ON ((ferrocarril_l.rrc = rrc.rrc)));


ALTER TABLE visualizacion.ferrocarril_l OWNER TO postgres;

--
-- TOC entry 419 (class 1259 OID 2452993)
-- Name: gasolinera_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.gasolinera_a AS
 SELECT gasolinera_a.gid,
    gasolinera_a.fcode,
    catalogo_objetos.descripcion,
    gasolinera_a.nam,
    gasolinera_a.txt,
    (gasolinera_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (it_transporte_terrestre.gasolinera_a
     JOIN catalogo_objetos.catalogo_objetos ON (((gasolinera_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.gasolinera_a OWNER TO postgres;

--
-- TOC entry 420 (class 1259 OID 2452997)
-- Name: granja_acuatica_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.granja_acuatica_a AS
 SELECT granja_acuatica_a.gid,
    granja_acuatica_a.fcode,
    catalogo_objetos.descripcion,
    granja_acuatica_a.txt,
    (granja_acuatica_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (ho_regulacion_zonas_restringidas.granja_acuatica_a
     JOIN catalogo_objetos.catalogo_objetos ON (((granja_acuatica_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.granja_acuatica_a OWNER TO postgres;

--
-- TOC entry 505 (class 1259 OID 3375800)
-- Name: instalacion_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.instalacion_a AS
 SELECT instalacion_a.gid,
    instalacion_a.fcode,
    catalogo_objetos.descripcion,
    instalacion_a.nam,
    ffn.ffn_desc,
    instalacion_a.txt,
    (instalacion_a.the_geom)::public.geometry(Polygon,32618) AS the_geom
   FROM ((gs_comercio.instalacion_a
     JOIN catalogo_objetos.catalogo_objetos ON (((instalacion_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.ffn ON ((instalacion_a.ffn = ffn.ffn)));


ALTER TABLE visualizacion.instalacion_a OWNER TO postgres;

--
-- TOC entry 421 (class 1259 OID 2453001)
-- Name: intercambiador_vial_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.intercambiador_vial_a AS
 SELECT intercambiador_vial_a.gid,
    intercambiador_vial_a.fcode,
    catalogo_objetos.descripcion,
    intercambiador_vial_a.nam,
    hct.hct_desc,
    rst.rst_desc,
    loc.loc_desc,
    intercambiador_vial_a.txt,
    (intercambiador_vial_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((((it_transporte_terrestre.intercambiador_vial_a
     JOIN catalogo_objetos.catalogo_objetos ON (((intercambiador_vial_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.hct ON ((intercambiador_vial_a.hct = hct.hct)))
     JOIN catalogo_objetos.rst ON ((intercambiador_vial_a.rst = rst.rst)))
     JOIN catalogo_objetos.loc ON ((intercambiador_vial_a.loc = loc.loc)));


ALTER TABLE visualizacion.intercambiador_vial_a OWNER TO postgres;

--
-- TOC entry 422 (class 1259 OID 2453006)
-- Name: invernadero_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.invernadero_a AS
 SELECT invernadero_a.gid,
    invernadero_a.fcode,
    catalogo_objetos.descripcion,
    invernadero_a.nam,
    invernadero_a.txt,
    (invernadero_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (ii_agropecuaria.invernadero_a
     JOIN catalogo_objetos.catalogo_objetos ON (((invernadero_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.invernadero_a OWNER TO postgres;

--
-- TOC entry 533 (class 1259 OID 3376369)
-- Name: invernadero_p; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.invernadero_p AS
 SELECT invernadero_p.gid,
    invernadero_p.fcode,
    catalogo_objetos.descripcion,
    invernadero_p.nam,
    invernadero_p.txt,
    (invernadero_p.the_geom)::public.geometry(Point,32618) AS the_geom
   FROM (ii_agropecuaria.invernadero_p
     JOIN catalogo_objetos.catalogo_objetos ON (((invernadero_p.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.invernadero_p OWNER TO postgres;

--
-- TOC entry 423 (class 1259 OID 2453010)
-- Name: isla_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.isla_a AS
 SELECT isla_a.gid,
    isla_a.fcode,
    catalogo_objetos.descripcion,
    isla_a.nam,
    isla_a.na2,
    isla_a.txt,
    (isla_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (ho_zonas_costeras.isla_a
     JOIN catalogo_objetos.catalogo_objetos ON (((isla_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.isla_a OWNER TO postgres;

--
-- TOC entry 424 (class 1259 OID 2453014)
-- Name: lago_laguna_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.lago_laguna_a AS
 SELECT lago_laguna_a.gid,
    lago_laguna_a.fcode,
    catalogo_objetos.descripcion,
    lago_laguna_a.nam,
    lago_laguna_a.na2,
    hyp.hyp_desc,
    lago_laguna_a.txt,
    (lago_laguna_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((ho_aguas_interiores.lago_laguna_a
     JOIN catalogo_objetos.catalogo_objetos ON (((lago_laguna_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.hyp ON ((lago_laguna_a.hyp = hyp.hyp)));


ALTER TABLE visualizacion.lago_laguna_a OWNER TO postgres;

--
-- TOC entry 477 (class 1259 OID 3373768)
-- Name: malecon_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.malecon_a AS
 SELECT malecon_a.gid,
    malecon_a.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    malecon_a.txt,
    (malecon_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((ho_puertos_muelles.malecon_a
     JOIN catalogo_objetos.catalogo_objetos ON (((malecon_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((malecon_a.smc = smc.smc)));


ALTER TABLE visualizacion.malecon_a OWNER TO postgres;

--
-- TOC entry 483 (class 1259 OID 3373871)
-- Name: malecon_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.malecon_l AS
 SELECT malecon_l.gid,
    malecon_l.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    malecon_l.txt,
    malecon_l.the_geom
   FROM ((ho_puertos_muelles.malecon_l
     JOIN catalogo_objetos.catalogo_objetos ON (((malecon_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((malecon_l.smc = smc.smc)));


ALTER TABLE visualizacion.malecon_l OWNER TO postgres;

--
-- TOC entry 480 (class 1259 OID 3373832)
-- Name: muelle_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.muelle_a AS
 SELECT muelle_a.gid,
    muelle_a.fcode,
    catalogo_objetos.descripcion,
    muelle_a.nam,
    loc.loc_desc,
    pwc.pwc_desc,
    fuc.fuc_desc,
    muelle_a.txt,
    muelle_a.the_geom
   FROM ((((ho_puertos_muelles.muelle_a
     JOIN catalogo_objetos.catalogo_objetos ON (((muelle_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.loc ON ((muelle_a.loc = loc.loc)))
     JOIN catalogo_objetos.pwc ON ((muelle_a.pwc = pwc.pwc)))
     JOIN catalogo_objetos.fuc ON ((muelle_a.fuc = fuc.fuc)));


ALTER TABLE visualizacion.muelle_a OWNER TO postgres;

--
-- TOC entry 486 (class 1259 OID 3373937)
-- Name: muelle_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.muelle_l AS
 SELECT muelle_a.gid,
    muelle_a.fcode,
    catalogo_objetos.descripcion,
    muelle_a.nam,
    loc.loc_desc,
    pwc.pwc_desc,
    fuc.fuc_desc,
    muelle_a.txt,
    (muelle_a.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM ((((ho_puertos_muelles.muelle_a
     JOIN catalogo_objetos.catalogo_objetos ON (((muelle_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.loc ON ((muelle_a.loc = loc.loc)))
     JOIN catalogo_objetos.pwc ON ((muelle_a.pwc = pwc.pwc)))
     JOIN catalogo_objetos.fuc ON ((muelle_a.fuc = fuc.fuc)));


ALTER TABLE visualizacion.muelle_l OWNER TO postgres;

--
-- TOC entry 516 (class 1259 OID 3376123)
-- Name: muro_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.muro_a AS
 SELECT muro_a.gid,
    muro_a.fcode,
    catalogo_objetos.descripcion,
    wti.wti_desc,
    muro_a.txt,
    (muro_a.the_geom)::public.geometry(Polygon,32618) AS the_geom
   FROM ((gs_asociado_poblados.muro_a
     JOIN catalogo_objetos.catalogo_objetos ON (((muro_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.wti ON ((muro_a.wti = wti.wti)));


ALTER TABLE visualizacion.muro_a OWNER TO postgres;

--
-- TOC entry 425 (class 1259 OID 2453019)
-- Name: muro_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.muro_l AS
 SELECT muro_l.gid,
    muro_l.fcode,
    catalogo_objetos.descripcion,
    wti.wti_desc,
    muro_l.txt,
    (muro_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM ((gs_asociado_poblados.muro_l
     JOIN catalogo_objetos.catalogo_objetos ON (((muro_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.wti ON ((muro_l.wti = wti.wti)));


ALTER TABLE visualizacion.muro_l OWNER TO postgres;

--
-- TOC entry 426 (class 1259 OID 2453024)
-- Name: orilla_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.orilla_l AS
 SELECT orilla_l.gid,
    orilla_l.fcode,
    catalogo_objetos.descripcion,
    acc.acc_desc,
    slt.slt_desc,
    orilla_l.txt,
    (orilla_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM (((ho_zonas_costeras.orilla_l
     JOIN catalogo_objetos.catalogo_objetos ON (((orilla_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((orilla_l.acc = acc.acc)))
     JOIN catalogo_objetos.slt ON ((orilla_l.slt = slt.slt)));


ALTER TABLE visualizacion.orilla_l OWNER TO postgres;

--
-- TOC entry 427 (class 1259 OID 2453029)
-- Name: parque_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.parque_a AS
 SELECT parque_a.gid,
    parque_a.fcode,
    catalogo_objetos.descripcion,
    parque_a.nam,
    fuc.fuc_desc,
    parque_a.txt,
    (parque_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((gs_recreacion.parque_a
     JOIN catalogo_objetos.catalogo_objetos ON (((parque_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.fuc ON ((parque_a.fuc = fuc.fuc)));


ALTER TABLE visualizacion.parque_a OWNER TO postgres;

--
-- TOC entry 428 (class 1259 OID 2453034)
-- Name: parqueadero_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.parqueadero_a AS
 SELECT parqueadero_a.gid,
    parqueadero_a.fcode,
    catalogo_objetos.descripcion,
    parqueadero_a.nam,
    smc.smc_desc,
    parqueadero_a.txt,
    (parqueadero_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((it_asociado_transportacion.parqueadero_a
     JOIN catalogo_objetos.catalogo_objetos ON (((parqueadero_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((parqueadero_a.smc = smc.smc)));


ALTER TABLE visualizacion.parqueadero_a OWNER TO postgres;

--
-- TOC entry 468 (class 1259 OID 3373628)
-- Name: paseo_maritimo_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.paseo_maritimo_a AS
 SELECT paseo_maritimo_a.gid,
    paseo_maritimo_a.fcode,
    catalogo_objetos.descripcion,
    paseo_maritimo_a.nam,
    mcc.mcc_desc,
    paseo_maritimo_a.txt,
    (paseo_maritimo_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((gs_recreacion.paseo_maritimo_a
     JOIN catalogo_objetos.catalogo_objetos ON (((paseo_maritimo_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.mcc ON ((paseo_maritimo_a.mcc = mcc.mcc)));


ALTER TABLE visualizacion.paseo_maritimo_a OWNER TO postgres;

--
-- TOC entry 429 (class 1259 OID 2453039)
-- Name: paseo_peatonal_ciclovia_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.paseo_peatonal_ciclovia_a AS
 SELECT paseo_peatonal_ciclovia_a.gid,
    paseo_peatonal_ciclovia_a.fcode,
    catalogo_objetos.descripcion,
    paseo_peatonal_ciclovia_a.nam,
    smc.smc_desc,
    paseo_peatonal_ciclovia_a.txt,
    (paseo_peatonal_ciclovia_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((it_asociado_transportacion.paseo_peatonal_ciclovia_a
     JOIN catalogo_objetos.catalogo_objetos ON (((paseo_peatonal_ciclovia_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((paseo_peatonal_ciclovia_a.smc = smc.smc)));


ALTER TABLE visualizacion.paseo_peatonal_ciclovia_a OWNER TO postgres;

--
-- TOC entry 536 (class 1259 OID 3376431)
-- Name: paseo_peatonal_ciclovia_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.paseo_peatonal_ciclovia_l AS
 SELECT paseo_peatonal_ciclovia_l.gid,
    paseo_peatonal_ciclovia_l.fcode,
    catalogo_objetos.descripcion,
    paseo_peatonal_ciclovia_l.nam,
    smc.smc_desc,
    paseo_peatonal_ciclovia_l.txt,
    (paseo_peatonal_ciclovia_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM ((it_asociado_transportacion.paseo_peatonal_ciclovia_l
     JOIN catalogo_objetos.catalogo_objetos ON (((paseo_peatonal_ciclovia_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((paseo_peatonal_ciclovia_l.smc = smc.smc)));


ALTER TABLE visualizacion.paseo_peatonal_ciclovia_l OWNER TO postgres;

--
-- TOC entry 430 (class 1259 OID 2453044)
-- Name: piscina_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.piscina_a AS
 SELECT piscina_a.gid,
    piscina_a.fcode,
    catalogo_objetos.descripcion,
    piscina_a.nam,
    piscina_a.txt,
    (piscina_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (gs_recreacion.piscina_a
     JOIN catalogo_objetos.catalogo_objetos ON (((piscina_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.piscina_a OWNER TO postgres;

--
-- TOC entry 431 (class 1259 OID 2453048)
-- Name: plaza_publica_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.plaza_publica_a AS
 SELECT plaza_publica_a.gid,
    plaza_publica_a.fcode,
    catalogo_objetos.descripcion,
    plaza_publica_a.nam,
    smc.smc_desc,
    plaza_publica_a.txt,
    (plaza_publica_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((gs_asociado_poblados.plaza_publica_a
     JOIN catalogo_objetos.catalogo_objetos ON (((plaza_publica_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((plaza_publica_a.smc = smc.smc)));


ALTER TABLE visualizacion.plaza_publica_a OWNER TO postgres;

--
-- TOC entry 432 (class 1259 OID 2453053)
-- Name: plaza_toros_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.plaza_toros_a AS
 SELECT plaza_toros_a.gid,
    plaza_toros_a.fcode,
    catalogo_objetos.descripcion,
    plaza_toros_a.nam,
    plaza_toros_a.txt,
    (plaza_toros_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (gs_recreacion.plaza_toros_a
     JOIN catalogo_objetos.catalogo_objetos ON (((plaza_toros_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.plaza_toros_a OWNER TO postgres;

--
-- TOC entry 474 (class 1259 OID 3373724)
-- Name: presa_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.presa_a AS
 SELECT presa_a.gid,
    presa_a.fcode,
    catalogo_objetos.descripcion,
    presa_a.nam,
    mcc.mcc_desc,
    tuc.tuc_desc,
    presa_a.txt,
    presa_a.the_geom
   FROM (((catalogo_objetos.catalogo_objetos
     JOIN ho_aguas_interiores.presa_a ON (((catalogo_objetos.fcode)::text = (presa_a.fcode)::text)))
     JOIN catalogo_objetos.mcc ON ((presa_a.mcc = mcc.mcc)))
     JOIN catalogo_objetos.tuc ON ((presa_a.tuc = tuc.tuc)));


ALTER TABLE visualizacion.presa_a OWNER TO postgres;

--
-- TOC entry 527 (class 1259 OID 3376296)
-- Name: presa_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.presa_l AS
 SELECT presa_l.gid,
    presa_l.fcode,
    catalogo_objetos.descripcion,
    presa_l.nam,
    mcc.mcc_desc,
    tuc.tuc_desc,
    presa_l.txt,
    (presa_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM (((ho_aguas_interiores.presa_l
     JOIN catalogo_objetos.catalogo_objetos ON (((presa_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.mcc ON ((presa_l.mcc = mcc.mcc)))
     JOIN catalogo_objetos.tuc ON ((presa_l.tuc = tuc.tuc)));


ALTER TABLE visualizacion.presa_l OWNER TO postgres;

--
-- TOC entry 487 (class 1259 OID 3374029)
-- Name: puente_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.puente_a AS
 SELECT puente_a.gid,
    puente_a.fcode,
    catalogo_objetos.descripcion,
    puente_a.nam,
    puente_a.na2,
    acc.acc_desc,
    bsc.bsc_desc,
    puente_a.ltn,
    tuc.tuc_desc,
    puente_a.txt,
    (puente_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM ((((it_cruces_enlaces.puente_a
     JOIN catalogo_objetos.catalogo_objetos ON (((puente_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((puente_a.acc = acc.acc)))
     JOIN catalogo_objetos.bsc ON ((puente_a.bsc = bsc.bsc)))
     JOIN catalogo_objetos.tuc ON ((puente_a.tuc = tuc.tuc)));


ALTER TABLE visualizacion.puente_a OWNER TO postgres;

--
-- TOC entry 433 (class 1259 OID 2453062)
-- Name: puerto_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.puerto_a AS
 SELECT puerto_a.gid,
    puerto_a.fcode,
    catalogo_objetos.descripcion,
    puerto_a.nam,
    puerto_a.txt,
    (puerto_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (ho_puertos_muelles.puerto_a
     JOIN catalogo_objetos.catalogo_objetos ON (((puerto_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.puerto_a OWNER TO postgres;

--
-- TOC entry 434 (class 1259 OID 2453066)
-- Name: punto_control_p; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.punto_control_p AS
 SELECT punto_control_p.gid,
    punto_control_p.fcode,
    catalogo_objetos.descripcion,
    acc.acc_desc,
    ela.ela_desc,
    punto_control_p.zvh,
    punto_control_p.txt,
    (punto_control_p.the_geom)::public.geometry(Point,32618) AS the_geom
   FROM (((d_linderos_propiedad.punto_control_p
     JOIN catalogo_objetos.catalogo_objetos ON (((punto_control_p.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((punto_control_p.acc = acc.acc)))
     JOIN catalogo_objetos.ela ON ((punto_control_p.ela = ela.ela)));


ALTER TABLE visualizacion.punto_control_p OWNER TO postgres;

--
-- TOC entry 460 (class 1259 OID 3373229)
-- Name: recinto_ferial_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.recinto_ferial_a AS
 SELECT recinto_ferial_a.gid,
    recinto_ferial_a.fcode,
    recinto_ferial_a.nam,
    recinto_ferial_a.txt,
    (recinto_ferial_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM gs_recreacion.recinto_ferial_a;


ALTER TABLE visualizacion.recinto_ferial_a OWNER TO postgres;

--
-- TOC entry 435 (class 1259 OID 2453071)
-- Name: rio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.rio_a AS
 SELECT rio_a.gid,
    rio_a.fcode,
    catalogo_objetos.descripcion,
    rio_a.nam,
    rio_a.na2,
    acc.acc_desc,
    hyp.hyp_desc,
    rio_a.txt,
    (rio_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (((catalogo_objetos.catalogo_objetos
     JOIN ho_aguas_interiores.rio_a ON (((catalogo_objetos.fcode)::text = (rio_a.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((rio_a.acc = acc.acc)))
     JOIN catalogo_objetos.hyp ON ((rio_a.hyp = hyp.hyp)));


ALTER TABLE visualizacion.rio_a OWNER TO postgres;

--
-- TOC entry 436 (class 1259 OID 2453076)
-- Name: rio_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.rio_l AS
 SELECT rio_l.gid,
    rio_l.fcode,
    catalogo_objetos.descripcion,
    rio_l.nam,
    rio_l.na2,
    acc.acc_desc,
    hyp.hyp_desc,
    rio_l.txt,
    (rio_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM (((catalogo_objetos.catalogo_objetos
     JOIN ho_aguas_interiores.rio_l ON (((catalogo_objetos.fcode)::text = (rio_l.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((rio_l.acc = acc.acc)))
     JOIN catalogo_objetos.hyp ON ((rio_l.hyp = hyp.hyp)));


ALTER TABLE visualizacion.rio_l OWNER TO postgres;

--
-- TOC entry 437 (class 1259 OID 2453081)
-- Name: rodera_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.rodera_l AS
 SELECT rodera_l.gid,
    rodera_l.fcode,
    catalogo_objetos.descripcion,
    typ.typ_desc,
    rst.rst_desc,
    hct.hct_desc,
    rdt.rdt_desc,
    wtc.wtc_desc,
    rodera_l.ltn,
    tuc.tuc_desc,
    rodera_l.txt,
    (rodera_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM (((((((it_transporte_terrestre.rodera_l
     JOIN catalogo_objetos.catalogo_objetos ON (((rodera_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.typ ON ((rodera_l.typ = typ.typ)))
     JOIN catalogo_objetos.hct ON ((rodera_l.hct = hct.hct)))
     JOIN catalogo_objetos.rst ON ((rodera_l.rst = rst.rst)))
     JOIN catalogo_objetos.rdt ON ((rodera_l.rdt = rdt.rdt)))
     JOIN catalogo_objetos.wtc ON ((rodera_l.wtc = wtc.wtc)))
     JOIN catalogo_objetos.tuc ON ((rodera_l.tuc = tuc.tuc)));


ALTER TABLE visualizacion.rodera_l OWNER TO postgres;

--
-- TOC entry 438 (class 1259 OID 2453086)
-- Name: sendero_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.sendero_l AS
 SELECT sendero_l.gid,
    sendero_l.fcode,
    catalogo_objetos.descripcion,
    wtc.wtc_desc,
    sendero_l.txt,
    (sendero_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM ((it_transporte_terrestre.sendero_l
     JOIN catalogo_objetos.catalogo_objetos ON (((sendero_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.wtc ON ((sendero_l.wtc = wtc.wtc)));


ALTER TABLE visualizacion.sendero_l OWNER TO postgres;

--
-- TOC entry 463 (class 1259 OID 3373263)
-- Name: sitio_arqueologico_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.sitio_arqueologico_a AS
 SELECT sitio_arqueologico_a.gid,
    sitio_arqueologico_a.fcode,
    sitio_arqueologico_a.nam,
    sitio_arqueologico_a.txt,
    (sitio_arqueologico_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM gs_recreacion.sitio_arqueologico_a;


ALTER TABLE visualizacion.sitio_arqueologico_a OWNER TO postgres;

--
-- TOC entry 499 (class 1259 OID 3375716)
-- Name: tuberia_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.tuberia_l AS
 SELECT tuberia_l.gid,
    tuberia_l.fcode,
    catalogo_objetos.descripcion,
    acc.acc_desc,
    loc.loc_desc,
    tuberia_l.txt,
    (tuberia_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM (((ii_estructura_asociada_industria.tuberia_l
     JOIN catalogo_objetos.catalogo_objetos ON (((tuberia_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((tuberia_l.acc = acc.acc)))
     JOIN catalogo_objetos.loc ON ((tuberia_l.loc = loc.loc)));


ALTER TABLE visualizacion.tuberia_l OWNER TO postgres;

--
-- TOC entry 439 (class 1259 OID 2453091)
-- Name: tunel_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.tunel_a AS
 SELECT tunel_a.gid,
    tunel_a.fcode,
    catalogo_objetos.descripcion,
    tunel_a.nam,
    tra.tra_desc,
    tuc.tuc_desc,
    tunel_a.txt,
    tunel_a.the_geom
   FROM (((it_asociado_transportacion.tunel_a
     JOIN catalogo_objetos.catalogo_objetos ON (((tunel_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.tra ON ((tunel_a.tra = tra.tra)))
     JOIN catalogo_objetos.tuc ON ((tunel_a.tuc = tuc.tuc)));


ALTER TABLE visualizacion.tunel_a OWNER TO postgres;

--
-- TOC entry 440 (class 1259 OID 2453096)
-- Name: via_ruta_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.via_ruta_a AS
 SELECT via_ruta_a.gid,
    via_ruta_a.fcode,
    catalogo_objetos.descripcion,
    via_ruta_a.nam,
    via_ruta_a.na2,
    acc.acc_desc,
    rst.rst_desc,
    typ.typ_desc,
    hct.hct_desc,
    loc.loc_desc,
    via_ruta_a.ltn,
    mes.mes_desc,
    rdt.rdt_desc,
    tuc.tuc_desc,
    via_ruta_a.txt,
    (via_ruta_a.the_geom)::public.geometry(MultiPolygon,32618) AS the_geom
   FROM (((((((((it_transporte_terrestre.via_ruta_a
     JOIN catalogo_objetos.catalogo_objetos ON (((via_ruta_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((via_ruta_a.acc = acc.acc)))
     JOIN catalogo_objetos.rst ON ((via_ruta_a.rst = rst.rst)))
     JOIN catalogo_objetos.typ ON ((via_ruta_a.typ = typ.typ)))
     JOIN catalogo_objetos.hct ON ((via_ruta_a.hct = hct.hct)))
     JOIN catalogo_objetos.loc ON ((via_ruta_a.loc = loc.loc)))
     JOIN catalogo_objetos.mes ON ((via_ruta_a.mes = mes.mes)))
     JOIN catalogo_objetos.rdt ON ((via_ruta_a.rdt = rdt.rdt)))
     JOIN catalogo_objetos.tuc ON ((via_ruta_a.tuc = tuc.tuc)));


ALTER TABLE visualizacion.via_ruta_a OWNER TO postgres;

--
-- TOC entry 530 (class 1259 OID 3376337)
-- Name: zanja_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.zanja_a AS
 SELECT zanja_a.gid,
    zanja_a.fcode,
    catalogo_objetos.descripcion,
    hyp.hyp_desc,
    zanja_a.txt,
    (zanja_a.the_geom)::public.geometry(Polygon,32618) AS the_geom
   FROM ((ho_aguas_interiores.zanja_a
     JOIN catalogo_objetos.catalogo_objetos ON (((zanja_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.hyp ON ((zanja_a.hyp = hyp.hyp)));


ALTER TABLE visualizacion.zanja_a OWNER TO postgres;

--
-- TOC entry 441 (class 1259 OID 2453101)
-- Name: zanja_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.zanja_l AS
 SELECT zanja_l.gid,
    zanja_l.fcode,
    catalogo_objetos.descripcion,
    hyp.hyp_desc,
    zanja_l.txt,
    (zanja_l.the_geom)::public.geometry(LineString,32618) AS the_geom
   FROM ((ho_aguas_interiores.zanja_l
     JOIN catalogo_objetos.catalogo_objetos ON (((zanja_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.hyp ON ((zanja_l.hyp = hyp.hyp)));


ALTER TABLE visualizacion.zanja_l OWNER TO postgres;

--
-- TOC entry 513 (class 1259 OID 3376082)
-- Name: zona_sin_informacion_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.zona_sin_informacion_a AS
 SELECT zona_sin_informacion_a.gid,
    zona_sin_informacion_a.fcode,
    catalogo_objetos.descripcion,
    zona_sin_informacion_a.txt,
    (zona_sin_informacion_a.the_geom)::public.geometry(Polygon,32618) AS the_geom
   FROM (ct_miscelaneos.zona_sin_informacion_a
     JOIN catalogo_objetos.catalogo_objetos ON (((zona_sin_informacion_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.zona_sin_informacion_a OWNER TO postgres;

--
-- TOC entry 523 (class 1259 OID 3376249)
-- Name: zoologico_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.zoologico_a AS
 SELECT zoologico_a.gid,
    zoologico_a.fcode,
    catalogo_objetos.descripcion,
    zoologico_a.nam,
    zoologico_a.txt,
    (zoologico_a.the_geom)::public.geometry(Polygon,32618) AS the_geom
   FROM (gs_recreacion.zoologico_a
     JOIN catalogo_objetos.catalogo_objetos ON (((zoologico_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.zoologico_a OWNER TO postgres;

--
-- TOC entry 6733 (class 2604 OID 2453106)
-- Name: aeropuerto_a gid; Type: DEFAULT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a ALTER COLUMN gid SET DEFAULT nextval('a_aeropuerto_superficie.aeropuerto_a_gid_seq'::regclass);


--
-- TOC entry 6739 (class 2604 OID 2453107)
-- Name: catalogo_objetos gid; Type: DEFAULT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.catalogo_objetos ALTER COLUMN gid SET DEFAULT nextval('catalogo_objetos.catalogo_objetos_gid_seq'::regclass);


--
-- TOC entry 7097 (class 2604 OID 3376063)
-- Name: zona_sin_informacion_a gid; Type: DEFAULT; Schema: ct_miscelaneos; Owner: postgres
--

ALTER TABLE ONLY ct_miscelaneos.zona_sin_informacion_a ALTER COLUMN gid SET DEFAULT nextval('ct_miscelaneos.zona_sin_informacion_a_gid_seq'::regclass);


--
-- TOC entry 7083 (class 2604 OID 3375812)
-- Name: limite_administrativo_l gid; Type: DEFAULT; Schema: d_limite_politico_administrativo; Owner: postgres
--

ALTER TABLE ONLY d_limite_politico_administrativo.limite_administrativo_l ALTER COLUMN gid SET DEFAULT nextval('d_limite_politico_administrativo.limite_administrativo_l_gid_seq'::regclass);


--
-- TOC entry 7160 (class 2604 OID 3484358)
-- Name: zona_administrativa_a gid; Type: DEFAULT; Schema: d_limite_politico_administrativo; Owner: postgres
--

ALTER TABLE ONLY d_limite_politico_administrativo.zona_administrativa_a ALTER COLUMN gid SET DEFAULT nextval('d_limite_politico_administrativo.zona_administrativa_a_gid_seq'::regclass);


--
-- TOC entry 6741 (class 2604 OID 2453108)
-- Name: punto_control_p gid; Type: DEFAULT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p ALTER COLUMN gid SET DEFAULT nextval('d_linderos_propiedad.vertice_geodesico_p_gid_seq'::regclass);


--
-- TOC entry 6748 (class 2604 OID 2453109)
-- Name: cementerio_a gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.cementerio_a_gid_seq'::regclass);


--
-- TOC entry 6755 (class 2604 OID 2453110)
-- Name: cerca_l gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.cerca_l_gid_seq'::regclass);


--
-- TOC entry 6957 (class 2604 OID 3373064)
-- Name: choza_a gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.choza_a ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.choza_a_gid_seq'::regclass);


--
-- TOC entry 6762 (class 2604 OID 2453111)
-- Name: escalinata_a gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.escalinata_a_gid_seq'::regclass);


--
-- TOC entry 7104 (class 2604 OID 3376098)
-- Name: muro_a gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_a ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.muro_a_gid_seq'::regclass);


--
-- TOC entry 6769 (class 2604 OID 2453112)
-- Name: muro_l gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.muro_l_gid_seq'::regclass);


--
-- TOC entry 6776 (class 2604 OID 2453113)
-- Name: plaza_publica_a gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.plaza_publica_a_gid_seq'::regclass);


--
-- TOC entry 7069 (class 2604 OID 3375734)
-- Name: estructura_no_construida_a gid; Type: DEFAULT; Schema: gs_comercio; Owner: postgres
--

ALTER TABLE ONLY gs_comercio.estructura_no_construida_a ALTER COLUMN gid SET DEFAULT nextval('gs_comercio.estructura_no_construida_a_gid_seq'::regclass);


--
-- TOC entry 7076 (class 2604 OID 3375765)
-- Name: instalacion_a gid; Type: DEFAULT; Schema: gs_comercio; Owner: postgres
--

ALTER TABLE ONLY gs_comercio.instalacion_a ALTER COLUMN gid SET DEFAULT nextval('gs_comercio.instalacion_a_gid_seq'::regclass);


--
-- TOC entry 6964 (class 2604 OID 3373133)
-- Name: edificio_a gid; Type: DEFAULT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a ALTER COLUMN gid SET DEFAULT nextval('gs_construcciones.edificio_a_gid_seq'::regclass);


--
-- TOC entry 6783 (class 2604 OID 2453115)
-- Name: cancha_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.cancha_a_gid_seq'::regclass);


--
-- TOC entry 6790 (class 2604 OID 2453116)
-- Name: estadio_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.estadio_a_gid_seq'::regclass);


--
-- TOC entry 6797 (class 2604 OID 2453117)
-- Name: parque_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.parque_a_gid_seq'::regclass);


--
-- TOC entry 6992 (class 2604 OID 3373600)
-- Name: paseo_maritimo_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.paseo_maritimo_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.paseo_maritimo_a_gid_seq'::regclass);


--
-- TOC entry 6804 (class 2604 OID 2453118)
-- Name: piscina_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.piscina_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.piscina_a_gid_seq'::regclass);


--
-- TOC entry 6811 (class 2604 OID 2453119)
-- Name: plaza_toros_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.plaza_toros_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.plaza_toros_a_gid_seq'::regclass);


--
-- TOC entry 6971 (class 2604 OID 3373205)
-- Name: recinto_ferial_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.recinto_ferial_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.recinto_ferial_a_gid_seq'::regclass);


--
-- TOC entry 6978 (class 2604 OID 3373244)
-- Name: sitio_arqueologico_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.sitio_arqueologico_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.sitio_arqueologico_a_gid_seq'::regclass);


--
-- TOC entry 6985 (class 2604 OID 3373531)
-- Name: zoologico_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.zoologico_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.zoologico_a_gid_seq'::regclass);


--
-- TOC entry 7111 (class 2604 OID 3376139)
-- Name: acequia_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.acequia_a_gid_seq'::regclass);


--
-- TOC entry 6818 (class 2604 OID 2453120)
-- Name: acequia_l gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.acequia_l_gid_seq'::regclass);


--
-- TOC entry 6825 (class 2604 OID 2453121)
-- Name: acueducto_canal_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.acueducto_canal_a_gid_seq'::regclass);


--
-- TOC entry 7118 (class 2604 OID 3376173)
-- Name: acueducto_canal_l gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_l ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.acueducto_canal_l_gid_seq'::regclass);


--
-- TOC entry 6999 (class 2604 OID 3373655)
-- Name: estanque_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.estanque_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.estanque_a_gid_seq'::regclass);


--
-- TOC entry 6832 (class 2604 OID 2453122)
-- Name: lago_laguna_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.lago_laguna_a_gid_seq'::regclass);


--
-- TOC entry 7006 (class 2604 OID 3373695)
-- Name: presa_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.presa_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.presa_a_gid_seq'::regclass);


--
-- TOC entry 7125 (class 2604 OID 3376267)
-- Name: presa_l gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.presa_l ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.presa_l_gid_seq'::regclass);


--
-- TOC entry 6839 (class 2604 OID 2453123)
-- Name: rio_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.rio_a_gid_seq'::regclass);


--
-- TOC entry 6846 (class 2604 OID 2453124)
-- Name: rio_l gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.rio_l_gid_seq'::regclass);


--
-- TOC entry 7132 (class 2604 OID 3376312)
-- Name: zanja_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.zanja_a_gid_seq'::regclass);


--
-- TOC entry 6853 (class 2604 OID 2453125)
-- Name: zanja_l gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.zanja_l_gid_seq'::regclass);


--
-- TOC entry 7013 (class 2604 OID 3373738)
-- Name: malecon_a gid; Type: DEFAULT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.malecon_a ALTER COLUMN gid SET DEFAULT nextval('ho_puertos_muelles.malecon_a_gid_seq'::regclass);


--
-- TOC entry 7027 (class 2604 OID 3373847)
-- Name: malecon_l gid; Type: DEFAULT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.malecon_l ALTER COLUMN gid SET DEFAULT nextval('ho_puertos_muelles.malecon_l_gid_seq'::regclass);


--
-- TOC entry 7020 (class 2604 OID 3373785)
-- Name: muelle_a gid; Type: DEFAULT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.muelle_a ALTER COLUMN gid SET DEFAULT nextval('ho_puertos_muelles.muelle_a_gid_seq'::regclass);


--
-- TOC entry 7034 (class 2604 OID 3373880)
-- Name: muelle_l gid; Type: DEFAULT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.muelle_l ALTER COLUMN gid SET DEFAULT nextval('ho_puertos_muelles.muelle_l_gid_seq'::regclass);


--
-- TOC entry 6860 (class 2604 OID 2453126)
-- Name: puerto_a gid; Type: DEFAULT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.puerto_a ALTER COLUMN gid SET DEFAULT nextval('ho_puertos_muelles.puerto_a_gid_seq'::regclass);


--
-- TOC entry 6867 (class 2604 OID 2453127)
-- Name: granja_acuatica_a gid; Type: DEFAULT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER TABLE ONLY ho_regulacion_zonas_restringidas.granja_acuatica_a ALTER COLUMN gid SET DEFAULT nextval('ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq'::regclass);


--
-- TOC entry 6874 (class 2604 OID 2453128)
-- Name: isla_a gid; Type: DEFAULT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.isla_a ALTER COLUMN gid SET DEFAULT nextval('ho_zonas_costeras.isla_a_gid_seq'::regclass);


--
-- TOC entry 6881 (class 2604 OID 2453129)
-- Name: orilla_l gid; Type: DEFAULT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l ALTER COLUMN gid SET DEFAULT nextval('ho_zonas_costeras.orilla_l_gid_seq'::regclass);


--
-- TOC entry 7139 (class 2604 OID 3376346)
-- Name: invernadero_p gid; Type: DEFAULT; Schema: ii_agropecuaria; Owner: postgres
--

ALTER TABLE ONLY ii_agropecuaria.invernadero_p ALTER COLUMN gid SET DEFAULT nextval('ii_agropecuaria.invernadero_p_gid_seq'::regclass);


--
-- TOC entry 7062 (class 2604 OID 3375683)
-- Name: tuberia_l gid; Type: DEFAULT; Schema: ii_estructura_asociada_industria; Owner: postgres
--

ALTER TABLE ONLY ii_estructura_asociada_industria.tuberia_l ALTER COLUMN gid SET DEFAULT nextval('ii_estructura_asociada_industria.tuberia_l_gid_seq'::regclass);


--
-- TOC entry 7048 (class 2604 OID 3375518)
-- Name: campo_petroleo_gas_a gid; Type: DEFAULT; Schema: ii_extraccion; Owner: postgres
--

ALTER TABLE ONLY ii_extraccion.campo_petroleo_gas_a ALTER COLUMN gid SET DEFAULT nextval('ii_extraccion.campo_petroleo_gas_a_gid_seq'::regclass);


--
-- TOC entry 7055 (class 2604 OID 3375575)
-- Name: cantera_a gid; Type: DEFAULT; Schema: ii_extraccion; Owner: postgres
--

ALTER TABLE ONLY ii_extraccion.cantera_a ALTER COLUMN gid SET DEFAULT nextval('ii_extraccion.cantera_a_gid_seq'::regclass);


--
-- TOC entry 6895 (class 2604 OID 2453133)
-- Name: parqueadero_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.parqueadero_a_gid_seq'::regclass);


--
-- TOC entry 6902 (class 2604 OID 2453134)
-- Name: paseo_peatonal_ciclovia_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq'::regclass);


--
-- TOC entry 7146 (class 2604 OID 3376407)
-- Name: paseo_peatonal_ciclovia_l gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_l ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.paseo_peatonal_ciclovia_l_gid_seq'::regclass);


--
-- TOC entry 6909 (class 2604 OID 2453135)
-- Name: tunel_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.tunel_a_gid_seq'::regclass);


--
-- TOC entry 6916 (class 2604 OID 2453136)
-- Name: puente_a gid; Type: DEFAULT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a ALTER COLUMN gid SET DEFAULT nextval('it_cruces_enlaces.puente_a_gid_seq'::regclass);


--
-- TOC entry 7041 (class 2604 OID 3374042)
-- Name: estacion_ferrocarril_a gid; Type: DEFAULT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.estacion_ferrocarril_a ALTER COLUMN gid SET DEFAULT nextval('it_ferrocarriles.estacion_ferrocarril_a_gid_seq'::regclass);


--
-- TOC entry 7153 (class 2604 OID 3376441)
-- Name: ferrocarril_l gid; Type: DEFAULT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_l ALTER COLUMN gid SET DEFAULT nextval('it_ferrocarriles.ferrocarril_l_gid_seq'::regclass);


--
-- TOC entry 6923 (class 2604 OID 2453138)
-- Name: gasolinera_a gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.gasolinera_a ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.gasolinera_a_gid_seq'::regclass);


--
-- TOC entry 6930 (class 2604 OID 2453139)
-- Name: intercambiador_vial_a gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.intercambiador_vial_a_gid_seq'::regclass);


--
-- TOC entry 6937 (class 2604 OID 2453140)
-- Name: rodera_l gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.rodera_l_gid_seq'::regclass);


--
-- TOC entry 6944 (class 2604 OID 2453141)
-- Name: sendero_l gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.sendero_l_gid_seq'::regclass);


--
-- TOC entry 6951 (class 2604 OID 2453142)
-- Name: via_ruta_a gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.via_ruta_a_gid_seq'::regclass);


--
-- TOC entry 7090 (class 2604 OID 3376019)
-- Name: base_militar_a gid; Type: DEFAULT; Schema: m_infraestructura_defensa_operaciones; Owner: postgres
--

ALTER TABLE ONLY m_infraestructura_defensa_operaciones.base_militar_a ALTER COLUMN gid SET DEFAULT nextval('m_infraestructura_defensa_operaciones.base_militar_a_gid_seq'::regclass);


--
-- TOC entry 7970 (class 0 OID 2452394)
-- Dependencies: 317
-- Data for Name: aeropuerto_a; Type: TABLE DATA; Schema: a_aeropuerto_superficie; Owner: postgres
--



--
-- TOC entry 7972 (class 0 OID 2452406)
-- Dependencies: 319
-- Data for Name: acc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.acc (acc, acc_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.acc (acc, acc_desc) VALUES (1, '1.- Exacta');
INSERT INTO catalogo_objetos.acc (acc, acc_desc) VALUES (2, '2.- Aproximada');
INSERT INTO catalogo_objetos.acc (acc, acc_desc) VALUES (3, '3.- Dudosa');
INSERT INTO catalogo_objetos.acc (acc, acc_desc) VALUES (7, '7.- Precisa');
INSERT INTO catalogo_objetos.acc (acc, acc_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 8065 (class 0 OID 3372850)
-- Dependencies: 443
-- Data for Name: agg; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.agg (agg, agg_desc) VALUES (0, '0.- Falso');
INSERT INTO catalogo_objetos.agg (agg, agg_desc) VALUES (1, '1.- Verdadero');


--
-- TOC entry 7973 (class 0 OID 2452409)
-- Dependencies: 320
-- Data for Name: atc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.atc (atc, atc_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.atc (atc, atc_desc) VALUES (1, '1.- Pozo Qanat');
INSERT INTO catalogo_objetos.atc (atc, atc_desc) VALUES (3, '3.- Acueducto subterráneo');
INSERT INTO catalogo_objetos.atc (atc, atc_desc) VALUES (4, '4.- Bajo el agua');
INSERT INTO catalogo_objetos.atc (atc, atc_desc) VALUES (5, '5.- Superficie');
INSERT INTO catalogo_objetos.atc (atc, atc_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 8066 (class 0 OID 3372857)
-- Dependencies: 444
-- Data for Name: bcp; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.bcp (bcp, bcp_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.bcp (bcp, bcp_desc) VALUES (1, '1.- Cruce fronterizo (oficial)');
INSERT INTO catalogo_objetos.bcp (bcp, bcp_desc) VALUES (2, '2.- Cruce fronterizo (no oficial)');
INSERT INTO catalogo_objetos.bcp (bcp, bcp_desc) VALUES (3, '3.- Punto de control de aduanas');
INSERT INTO catalogo_objetos.bcp (bcp, bcp_desc) VALUES (4, '4.- Puesto de control militar nacional');
INSERT INTO catalogo_objetos.bcp (bcp, bcp_desc) VALUES (5, '5.- Puesto de control militar no nacional');
INSERT INTO catalogo_objetos.bcp (bcp, bcp_desc) VALUES (6, '6.- Puntos de control insurgentes');
INSERT INTO catalogo_objetos.bcp (bcp, bcp_desc) VALUES (7, '7.- Punto de control de la fuerza de seguridad no militar');
INSERT INTO catalogo_objetos.bcp (bcp, bcp_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7974 (class 0 OID 2452412)
-- Dependencies: 321
-- Data for Name: bsc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (1, '1.- Arco abierto Spandrel');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (2, '2.- Voladizo');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (3, '3.- Cubierta');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (5, '5.- Flotante');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (6, '6.- De viga');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (7, '7.- Torre de suspensión');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (8, '8.- Entramado');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (9, '9.- Suspensión');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (12, '12.- Transportador');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (15, '15.- De losa');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (16, '16.- Viga y largero');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (19, '19.- Cuerda del arco del puente');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (22, '22.- Cubierto');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (26, '26.- Arco cerrado spandrel');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (27, '27.- Atirantado');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (28, '28.- Viaducto');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (31, '31.- Arco');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (32, '32.- Caballete');
INSERT INTO catalogo_objetos.bsc (bsc, bsc_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7975 (class 0 OID 2452415)
-- Dependencies: 322
-- Data for Name: catalogo_objetos; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AA051', 'Boca de Pozo', 'Equipo utilizado para mantener el control de un pozo, incluyen accesorios como válvulas.', 1);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AA052', 'Campo de Petróleo/Gas', 'Área donde se ha identificado la presencia de petróleo, aceite y/o gas natural.', 2);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AA012', 'Cantera', 'Explotación generalmente a cielo abierto de la que se obtienen rocas industriales, ornamentales y otros materiales usados en la construcción.', 3);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AA010', 'Mina', 'Excavación hecha en la tierra para la extracción de materiales de depósitos naturales.', 4);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AA050', 'Pozo', 'Excavación o perforación hecha en la tierra o mar para la extracción de líquidos o gases.', 5);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AA040', 'Torre de Perforación', 'Superestructura equipada para la perforación o el levantamiento de las operaciones de extracción y / o explotación de recursos naturales.', 6);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BB241', 'Astillero', 'Área  al lado del mar o un río importante, que incluye  instalaciones en las que los buques se construyen o reparan.', 7);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AC040', 'Instalación Petrolera', 'Área con instalaciones para la producción o distribución de petróleo, aceite y/o productos de gas natural.', 8);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AC000', 'Planta de Procesamiento', 'Instalación que incluye uno o más edificios utilizados para procesar materiales.', 9);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH220', 'Planta de Tratamiento de Agua', 'Instalaciones para el almacenamiento, purificación y suministro del agua para un área o una ciudad.', 10);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AE010', 'Planta Ensambladora', 'Edificio o grupo de edificios dedicados a combinar piezas fabricadas para obtener un producto terminado.', 11);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AC030', 'Tanque de Decantación', 'Sitio donde la materia sólida se precipita de un líquido mediante sedimentación.', 12);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH175', 'Abrevadero', 'Contenedor abierto de retención de agua para dar de beber a los animales.', 13);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AJ030', 'Corral', 'Lugar cerrado en el cual el ganado es custodiado temporalmente.', 14);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AJ080', 'Establo', 'Lugar cubierto adaptado para el refugio y alimentación del ganado y las aves.', 15);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AJ060', 'Hacienda', 'Lugar que puede ser de cualquier tamaño desde unas pocas hectáreas a miles de hectáreas, y puede estar especializada en una particular forma de producción de alimento y/o ganado.', 16);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AJ070', 'Rancho', 'Extensión de tierra, incluye las estructuras, cuyo principal uso es el pastoreo de ganado en general, puede presentar también cultivos.', 17);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH240', 'Sistema de Irrigación', 'Sistema para proveer de agua a la tierra, generalmente a través de una red de canales o tuberías.', 18);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AD010', 'Central Eléctrica', 'Edificio y equipamiento necesario para la generación de energía eléctrica.', 19);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AT030', 'Línea de Transmisión Eléctrica', 'Cable que transmite o distribuye energía eléctrica.', 20);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AD030', 'Subestación Eléctrica', 'Infraestructura localizada sobre la ruta de la línea de energía eléctrica en la cual se transforma  y/o se distribuye la energía.', 21);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AT010', 'Antena Parabólica', 'Objeto cóncavo utilizado para la transmisión o recepción de señales electromagnéticas.', 22);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AT060', 'Línea Telefónica', 'Sistema de comunicación que transmite señales eléctricas con información a distancias muy largas.', 23);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AT080', 'Torre de Comunicación', 'Estructura relativamente alta utilizada para transmitir, y/o recibir señales de comunicación electromagnéticas.', 24);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AF010', 'Chimenea', 'Estructura vertical que contiene un tubo o cañón para descarga de humo o gases de combustión.', 25);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AF070', 'Mechero', 'Tubería abierta en la cual los gases residuales son quemados.', 26);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AF030', 'Torre de Enfriamiento', 'Torre utilizada para enfriar líquidos.', 27);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AQ113', 'Tubería', 'Serie de tubos conectados para el transporte de sólidos, líquidos o gases.', 28);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AM010', 'Bodega', 'Área utilizada para almacenamiento de productos o suministros.', 29);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AM040', 'Pila Mineral', 'Montículo de productos mineros o de cantera, extraídos por el hombre, que no contienen materiales de desecho.', 30);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AM091', 'Silo', 'Contenedor cilíndrico cerrado, utilizado para guardar el grano o forraje.', 31);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AM070', 'Tanque de Almacenamiento', 'Depósito usado para el almacenamiento de líquidos y/o gases.', 32);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AM080', 'Torre de Agua', 'Torre que sirve de apoyo a un tanque elevado de almacenamiento de agua.', 33);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AB021', 'Difusor/Colector', 'Instalación artificial, generalmente subterránea donde los líquidos son evacuados.', 34);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AB030', 'Instalación para Procesamiento de Residuos', 'Sitio funcional con edificios y otras instalaciones, donde los residuos son procesados a través de  procedimientos químicos, físicos, biológicos o térmicos, o combinaciones de estos.', 35);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AB000', 'Vertedero/Basurero', 'Área para la recolección o depósito de materiales de desecho o descarga.', 36);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL135', 'Comunidad', 'Concentración de viviendas nativas, generalmente chozas, usualmente de construcción tradicional.', 37);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL015', 'Edificio', 'Estructura techada relativamente permanente, diseñada para algún uso particular.', 38);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL105', 'Poblado', 'Concentración continua ocupada de tiendas  o ligeras estructuras fijas (por ejemplo: chozas) que sirven como residencia.', 39);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL020', 'Zona Edificada', 'Área que contiene concentración de construcciones y/u otras estructuras.', 40);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL030', 'Cementerio', 'Sitio de estructuras asociadas, utilizadas para el entierro de muertos.', 41);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL070', 'Cerca', 'Barrera artificial construida por el hombre de estructura relativamente liviana utilizada como cercado o límite.', 42);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL099', 'Choza', 'Construcción rústica, pequeña, sencilla e independiente que por lo general tiene una sola habitación individual multifunción.', 43);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AQ150', 'Escalinata', 'Serie de escalones que sirven para subir a un plano más elevado o para bajar a un plano inferior.', 44);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL130', 'Monumento', 'Estructura levantada o mantenida en memoria a una persona o evento.', 45);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL260', 'Muro', 'Barrera hecha por el hombre de material resistente utilizado como límite o para protección.', 46);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL170', 'Plaza Pública', 'Sitio abierto y que sirve como lugar de reunión pública en una zona poblada para diversos usos.', 47);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH230', 'Pozo de Agua', 'Excavación o perforación hecha en la tierra para la extracción de agua.', 48);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL241', 'Torre', 'Estructura relativamente alta,  que puede presentarse sola o puede formar parte de otra estructura.', 49);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL240', 'Torre que no es para Comunicación', 'Torre  que se utiliza para fines distintos de la comunicación.', 50);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AG030', 'Complejo Comercial', 'Instalaciones comerciales de varios  almacenes, con restaurantes, lugares de entretenimiento y  otras empresas,  está completamente cubierto y cuenta con una amplia zona de estacionamiento.', 51);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BA011', 'Línea de Costa', 'Línea generada por el contacto entre la tierra y un cuerpo de agua afectado por mareas y definida por el nivel de la pleamar media.', 98);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL014', 'Estructura no Construida', 'Construcción económicamente independiente,  diseñada para apoyar las actividades humanas (por ejemplo:  agricultura,  industria o minería), pero no destinados a la ocupación humana y/o habitación.', 52);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL011', 'Instalación', 'Agrupación de instalaciones, situadas en la misma zona, que apoyan funciones particulares.', 53);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AK200', 'Balneario', 'Establecimiento que se levanta cerca de fuentes de aguas mineromedicinales (declaradas de utilidad pública) con la finalidad de utilizar sus propiedades terapéuticas y estéticas.', 54);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AK040', 'Cancha', 'Lugar al aire libre destinado a eventos deportivos, ejercicio o juegos.', 55);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AK160', 'Coliseo', 'Escenario parcial o totalmente rodeado por una estructura diseñada para permitir a los espectadores de pie o sentados visualizar un evento.  A menudo diseñados en forma y tamaño para dar cabida a deportes específicos (por ejemplo: fútbol, ​​baloncesto, etc.), teatro o actuaciones musicales.', 56);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AK165', 'Estadio', 'Campo deportivo parcial o totalmente rodeado por una estructura diseñada para permitir a los espectadores ver un evento de pie o sentados; a menudo diseñados en forma y tamaño para dar cabida a deportes específicos (por ejemplo: el fútbol).', 57);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AK121', 'Mirador', 'Área, generalmente en un lugar elevado, con infraestructura para observaciones del paisaje circundante.', 58);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AK120', 'Parque', 'Área utilizada con propósitos recreacionales u ornamentales.', 59);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AK030', 'Parque de Diversión', 'Instalación predominantemente artificial, equipada con dispositivos recreacionales.', 60);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AK190', 'Paseo Marítimo', 'Estructura que se extiende en el agua utilizada con propósitos recreacionales, no pretende ser un lugar de atraque de buques.', 61);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AK170', 'Piscina', 'Construcción destinada a contener agua con fines de recreación y natación.', 62);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AK130', 'Pista de Carreras', 'Superficie que se utiliza para competencias de carreras.', 63);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AK166', 'Plaza de Toros', 'Construcción generalmente circular u ovalada, de cielo abierto, rodeada por graderíos para los espectadores.', 64);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AK090', 'Recinto Ferial', 'Área donde existen instalaciones permanentes al aire libre para realizar ferias, circos o exhibiciones.', 65);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL200', 'Ruinas', 'Remanentes deteriorados de estructuras no especificadas.', 66);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL012', 'Sitio Arqueológico', 'Sitio donde se ha descubierto la existencia de restos de civilizaciones ancestrales o actividades humanas.', 67);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL201', 'Sitio Histórico', 'Sitio o área declarada de significado histórico nacional o provincial mantenido para el público.', 68);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AK110', 'Tribuna', 'Estructura elevada en vías, centros deportivos, etc. generalmente para la presentación especial de eventos al aire libre.', 69);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AK180', 'Zoológico', 'Lugar donde los animales, generalmente salvajes, se mantienen en exposición al público, pueden reproducirse y ser estudiados.', 70);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL142', 'Observatorio Astronómico', 'Edificio diseñado y equipado para realizar observaciones de objetos celestes, del espacio y del universo en su conjunto.', 71);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AN010', 'Ferrocarril', 'Una o más vías de ferrocarril que comprende una red utilizada para el transporte de pasajeros y/o bienes.', 72);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AN070', 'Estación de Ferrocarril', 'Instalación en la que los pasajeros pueden subir y bajar de los trenes y/o cargar  y descargar  mercancías del transporte ferroviario.', 73);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AQ180', 'Estación de Pesaje', 'Construcción y equipos asociados que se utilizan para examinar y pesar  los vehículos de motor.', 74);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AQ170', 'Gasolinera', 'Establecimiento en el cual se vende combustible y lubricantes generalmente para vehículos de motor.', 75);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AP020', 'Intercambiador Vial', 'Conexión diseñada para facilitar el acceso del tráfico de una carretera a  otra.', 76);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AP010', 'Rodera', 'Vía natural con poca o ninguna mejora por la que pueden transitar vehículos de doble tracción.', 77);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AP050', 'Sendero', 'Camino angosto abierto por el tránsito de personas o animales.', 78);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AP030', 'Vía o Ruta', 'Trayecto con una superficie especialmente  preparada que se mantiene para ser usada por vehículos generalmente a motor.', 79);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AT041', 'Transporte Aéreo por Cable', 'Sistema de transporte que consiste en cables de carga  unidos entre torres en los que están suspendidas las unidades (por ejemplo: tarabita, teleférico).', 80);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AQ070', 'Gabarra', 'Ruta definida que cruza una gabarra de una orilla a otra.', 81);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AQ040', 'Puente', 'Estructura que conecta dos lugares y facilita el paso  de una ruta de  transporte (por ejemplo:carretera o ferrocarril)  sobre un obstáculo del terreno (por ejemplo: cuerpo de agua, barranco y/o carretera).', 82);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AQ065', 'Alcantarilla', 'Estructura hecha por el hombre que permite el cruce de un cauce de agua bajo una vía u otra infraestructura, así como una construcción destinada a evacuar aguas residuales.', 83);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AP040', 'Control Vehicular', 'Barrera en una ruta de transporte (por ejemplo: una carretera, un ferrocarril, un túnel o un puente) que controla el paso (puede ser abierto o cerrado).', 84);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AQ036', 'Cuneta', 'Borde de hormigón, asfalto o piedras que forman parte de un canal a lo largo del borde de una calle o carretera.', 85);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AQ080', 'Estación de Gabarra', 'Lugar donde una gabarra toma o descarga su carga.', 86);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AM510', 'Estación de Transbordo', 'Complejo de edificios, instalaciones asociadas, carreteras y zonas adaptadas, utilizadas para el transbordo de pasajeros y carga entre los mismos o diferentes tipos de transporte.', 87);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AQ125', 'Estación de Transporte', 'Estación que sirve como un punto de parada a lo largo de una ruta de transporte.', 88);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AQ140', 'Parqueadero', 'Lugar destinado generalmente para estacionar vehículos.', 89);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AP034', 'Parterre', 'Obra o espacio vial entre dos rutas de transporte para separar el flujo del tráfico (por ejemplo, en sentido contrario).', 90);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AP031', 'Paseo Peatonal / Ciclovía', 'Franja de terreno pavimentada o mejorada que tiene por objeto servir como una vía para  peatones, animales y/o vehículos no motorizado.', 91);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AQ152', 'Puente Peatonal', 'Estructura elevada o suspendida que permite el  paso de peatones.', 92);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AQ060', 'Torre de Control', 'Estructura que alberga personas y equipos que cumplen con  la función de controlar el tráfico aéreo, náutico o de trenes.', 93);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AQ130', 'Túnel', 'Paso subterráneo o submarino, abierto para establecer comunicación.', 94);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH190', 'Albufera', 'Laguna natural que se forma en una bahía o entrada de mar cuya boca ha quedado cerrada por cordones de arena o arrecifes de coral.', 95);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BA023', 'Anteplaya', 'La parte de la costa o playa que se encuentra entre la línea de bajamar y el límite superior de la acción del oleaje normal (arena, grava, arcilla y barro).', 96);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BA030', 'Isla', 'Masa de tierra más pequeña que un continente y rodeada por agua.', 97);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BA040', 'Mar', 'Masa de agua salada que cubre la mayor parte de la superficie de la Tierra.', 99);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BA010', 'Orilla', 'Línea donde una superficie está en contacto con un cuerpo de agua.', 100);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BA050', 'Playa', 'Ribera del mar o de un río grande, formada de arenales en un superficie casi plana.', 101);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BA051', 'Dique', 'Barrera o construcción para contener o detener el agua.', 102);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BI030', 'Esclusa', 'Un par o una serie de compuertas utilizadas para levantar y bajar los barcos a medida que pasan desde el nivel del agua a otra.', 103);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BB043', 'Malecón', 'Murallón que corre paralelo a la orilla del mar o de un río, con la finalidad de proteger de las aguas.', 104);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BB190', 'Muelle', 'Obra construida en un puerto de mar o en la orilla de un río navegable para facilitar las tareas de carga, descarga y para atracar los barcos.', 105);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BB005', 'Puerto', 'Conjunto de obras, instalaciones y servicios que proporcionan el espacio necesario para la estancia de los buques mientras realizan operaciones de carga, descarga, almacenaje y tránsito de viajeros.', 106);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BB041', 'Rompeolas', 'Estructura avanzada hacia el mar que protege un puerto o playa de la acción de las olas.', 107);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BE015', 'Curva Batimétrica', 'Línea que conecta puntos de igual profundidad y por debajo del datum hidrográfico.', 108);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BC020', 'Boya', 'Objeto flotante que se sujeta al fondo del mar, de un lago o de un río, que sirve como ayuda a la navegación.', 109);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BC050', 'Faro', 'Estructura distintiva dentro o fuera de la costa con luz en su parte superior, diseñado para servir como una ayuda a la navegación.', 110);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BD120', 'Arrecife', 'Costa peñascosa, formada en el mar por roca o coral, casi a flor de agua, que constituye peligro para la navegación.', 111);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BD180', 'Naufragio', 'Ruinas de un barco hundido o irreversiblemente dañado.', 112);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BD110', 'Plataforma marina', 'Superficie plana levantada sobre el mar, como etapa de trabajo en la conducción de operaciones mar adentro.', 113);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BD130', 'Roca', 'Formación rocosa aislada, piedra o coral de gran tamaño, que constituye un peligro para la navegación.', 114);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH050', 'Granja Acuática', 'Área cerrada de agua utilizada para la reproducción o cría de camarones, peces y similares.', 115);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH030', 'Acequia', 'Excavación poco profunda construida en tierra con propósitos de drenaje o irrigación.', 116);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH010', 'Acueducto o Canal', 'Cauce artificial que transporta agua en forma de flujo continuo desde un lugar en el que ésta es accesible para consumo u otros usos.', 117);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH090', 'Área de Inundación', 'Área periódicamente cubierta por agua, excluyendo el agua por marea.', 118);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH011', 'Bocatoma', 'Lugar donde el agua es captada en un canal, tubería u otro cuerpo de agua.', 119);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH020', 'Canal de Navegación', 'Canal artificial sin flujo o flujo controlado, construido o usado para navegación.', 120);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH200', 'Característica Miscelánea de Drenaje de Superficie', 'Característica de drenaje de superficie la cual es de naturaleza menor y que no está incluida en otros elementos codificado en estas especificaciones.', 121);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH180', 'Cascada', 'Caída vertical de un curso de agua, producida por brusco desnivel del cauce.', 122);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH015', 'Ciénaga', 'Área permanentemente húmeda de la tierra formada por materia orgánica en descomposición y sobre todo de agua dulce estancada.', 123);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BI010', 'Cisterna', 'Contenedor cubierto, construido por el hombre utilizado para recolectar y almacenar el agua.', 124);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BI040', 'Compuerta', 'Puerta utilizada para regular el flujo de agua.', 125);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH130', 'Embalse', 'Depósito artificial en el que se almacenan las aguas de un río o un arroyo, generalmente mediante una presa o un dique que cierra la boca de un valle.', 126);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AQ116', 'Estación de Bombeo', 'Instalación para mover sólidos, líquidos o gases a través de presión o succión.', 127);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH081', 'Estanque', 'Depósito construido para recolección o almacenamiento de agua para consumo humano o agropecuario.', 128);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH155', 'Evaporador Salino', 'Piscina poco profunda, normalmente construida por el hombre, en donde se recoge sal por la evaporación natural del agua.', 129);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH080', 'Lago o Laguna', 'Cuerpo de agua, dulce o salada, rodeada por tierra.', 130);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH170', 'Manantial', 'Flujo natural de agua que brota en la superficie de la tierra.', 131);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BI020', 'Presa', 'Estructura generalmente de cemento armado, construida a través de un río, arroyo o canal  para contener o controlar el caudal.', 132);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH145', 'Punto Desvanecido', 'Lugar en el cual la corriente de agua desaparece o se desvanece en el terreno.', 133);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH120', 'Rápidos', 'Partes de un río, donde la corriente fluye con gran rapidez, debido a alteraciones en la superficie provocadas por obstrucciones tale como rocas y peñascos.', 134);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH140', 'Río', 'Curso de agua que fluye naturalmente.', 135);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AJ020', 'Sifón', 'Tubería utilizada para el transporte de líquidos de un nivel  a un nivel inferior, usando la diferencia de presión del líquido para forzar subir a la columna hasta un nivel más alto antes de que caiga a la salida.', 136);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH070', 'Vado', 'Sitio poco profundo en un río o corriente de agua utilizado para cruzar a pie, a caballo o en vehículo.', 137);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH100', 'Zanja', 'Excavación larga y estrecha que se hace en la tierra para echar los cimientos, conducir las aguas, defender los sembríos o usos semejantes.', 138);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('CA010', 'Curva de Nivel', 'Línea que conecta puntos que tienen el mismo valor de altura respecto al datum vertical.', 139);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('CA030', 'Punto Acotado/de Cota', 'Lugar designado con un valor de elevación relativa con respecto a un datum vertical.', 140);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('DB010', 'Acantilado', 'Superficie empinada vertical o dominante de una roca o de la tierra.', 141);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('DB170', 'Duna', 'Uno o varios montículos o lomas de arena por lo general formadas por el viento.', 142);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('DB029', 'Entrada de Cueva', 'Entrada a una serie interconectada de cámaras subterráneas.', 143);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('DB160', 'Estrato Rocoso', 'Importante afloramiento del lecho rocoso expuesto.', 144);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('DB061', 'Grieta', 'Hendidura, fisura, abertura muy fina en la superficie de la tierra, especialmente en la roca.', 145);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BJ099', 'Límite de Nieve', 'Capa permanente de hielo que cubre una extensión de tierra  o  la cima de una montaña.', 146);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('DB090', 'Terraplén', 'Montículo largo de tierra u otro material, realizado por el hombre, que se levanta para hacer una defensa, camino u otra obra semejante.', 147);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('DA010', 'Característica del Suelo', 'Región de la tierra que es homogénea con respecto a una característica del suelo.', 148);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH160', 'Salitral', 'Yacimiento natural cuyo lecho está cubierto con sal  incrustada.', 149);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH150', 'Salina', 'Mina de sal.', 150);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('DB185', 'Cráter', 'Depresión en el terreno en forma cóncava, generalmente redonda y con bordes escarpados.', 151);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL045', 'Objeto Agregado', 'Lugar que no aparece como un objeto específico, pero con cual la información específica es asociada.', 195);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BJ030', 'Glaciar', 'Gran masa o un río de hielo que se forma por acumulación y  compactación de la nieve en  un terreno alto que se mueve  lentamente por una pendiente o valle por encima de la línea de nieve.', 152);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('EC040', 'Desmonte', 'Zona de terreno donde se ha desbrozado la vegetación; para facilitar principalmente: el acceso de una carretera, ferrocarril, tubería, línea de transmisión eléctrica; demarcar una frontera; obtener línea de vista, o para impedir el progreso de los incendios forestales (un cortafuegos).', 153);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('ZD020', 'Zona sin Información', 'Área que carece de fuentes de cobertura adecuada o donde no se requiere información.', 154);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('EA010', 'Cultivo', 'Área que ha sido labrada para plantar diferentes cosechas; se incluyen terrenos con barbecho.', 155);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('EA030', 'Vivero', 'Lugar donde arbustos, flores, plantas y árboles se cultivan para transplante, semilla o injerto.', 156);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('EB020', 'Matorral', 'Zona cubierta principalmente por especies arbustivas no cultivadas, que están densamente enredadas entre sí.', 157);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('EB010', 'Pastizal', 'Vegetación herbácea o pasto que tienen poco o ningún tejido leñoso.', 158);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('EC005', 'Árbol', 'Planta perenne, de tronco leñoso que crece a una altura considerable y se ramifica a cierta distancia del suelo.', 159);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('EC015', 'Bosque', 'Área con alta densidad de árboles, a veces combinada con maleza y pasto.', 160);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('EC060', 'Claro de Bosque', 'Sitio en un bosque que ha sido limpiado, a menudo por la agricultura de corte, quema y/o como resultado de la tala maderera. También puede producirse por causas naturales, tales como un incendio forestal.', 161);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('EE020', 'Tierra sin Vegetación', 'Una zona con cobertura menor al 5 % o sin vegetación.', 162);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('ED030', 'Zona de Manglar', 'Denso matorral de mangle que está sujeto a inundación por mareas y formación de pantanos.', 163);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('ED020', 'Pantano', 'Terreno húmedo y lodoso, con un drenaje muy pobre, tiene cierto tipo de vegetación acuática y  dificulta el tránsito.', 164);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('FA000', 'Límite Administrativo', 'Límite entre zonas controladas administrativamente.', 165);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('FA001', 'Zona Administrativa', 'Área controlada mediante una autoridad administrativa.', 166);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('ZB030', 'Hito', 'Marca que indica un punto físico sobre la superficie de la tierra cuya posición ha sido medida.', 167);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('IA041', 'Manzana', 'Superficie de terreno o agrupación de lotes cuyo conjunto está delimitado por vías de transito y/o accidentes geográficos naturales.', 168);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('ZB060', 'Vértice Geodésico', 'Punto físico sobre la superficie de la tierra que tiene una posición conocida y se estableció como parte de una red geodésica.', 169);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('GB005', 'Aeropuerto', 'Zona provista de un conjunto de pistas, instalaciones y servicios destinados al tráfico regular de aeronaves.', 170);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('GB015', 'Estacionamiento de Aeronaves', 'Área definida, en un aeródromo terrestre/helipuerto, destinado a acoger aeronaves y helicópteros  para el embarque y desembarque de pasajeros, correo o carga y para abastecerse de combustible, estacionamiento  o mantenimiento.', 171);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('GB035', 'Helipuerto', 'Aeródromo utilizado para aterrizaje y despegue vertical de helicópteros.', 172);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('GB055', 'Pista de Aterrizaje', 'Área rectangular definida en un campo de aviación o aeropuerto, utilizada para despegue y aterrizaje de aeronaves.', 173);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('GB075', 'Pista de Rodadura', 'Ruta definida en un aeródromo, establecido para  el rodaje de aeronaves  y destinada a proporcionar un enlace de movimiento en tierra  entre una parte del aeródromo y otra.', 174);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('SU001', 'Base Militar', 'Conjunto de instalaciones destinadas para el uso militar, que proporcionan apoyo en combate, a fin de que cuenten con las mejores condiciones operativas para el cumplimiento de las tareas asignadas; brindando un soporte  logístico, técnico y de seguridad necesarios.', 175);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AT045', 'Estación de Radar', 'Instalación que utiliza el radar para detectar y analizar objetos (por ejemplo: aviones, buques, satélites artificiales, asteroides, y/o misiles) y/o fenómenos ambientales (por ejemplo: tornados).', 177);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AM065', 'Instalación de Almacenamiento de Municiones', 'Depósito para el almacenamiento y mantenimiento de municiones y explosivos (por ejemplo: bombas, misiles, ojivas, minas o municiones).', 178);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AH070', 'Puesto de Control', 'Lugar donde se registran, declaran y/o inspeccionan bienes y/o personas.', 179);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AL121', 'Zona de Artillería Anti-Aérea', 'Zona de instalaciones relacionadas (por ejemplo: edificios y/o equipos de radar) para el almacenamiento y emplazamiento de artillería anti-aérea.', 180);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('FC050', 'Área de Disparo y/o Práctica Naval', 'Área donde la fuerza naval (por ejemplo:buques o aeronaves) ejecutan ejercicios de disparo de munición  y lanzamiento de misiles en forma real.', 181);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('FA165', 'Área de Entrenamiento', 'Sitio destinado a la instrucción y adiestramiento especializado del personal movilizado para completar las dotaciones de guerra de las unidades y reparticiones del ejercito, así como para proporcionar los reemplazos necesarios a las tropas en combate.', 182);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('FC055', 'Área de Operaciones Navales', 'Área donde la fuerza naval ejecuta operaciones.', 183);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('FC200', 'Campo Minado', 'Parte del terreno sembrado de minas Antitanques y Antipersonal está destinado a retardar, desgastar y encauzar al adversario. En guerra naval es área de mar sembrada de minas antibuque y/o antisubmarinas, con el propósito de impedir el tráfico marítimo enemigo y/o proteger lugares de interés en el litoral, tales como puertos, bahías y canales.', 184);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('FA021', 'Límite Marítimo', 'Línea donde actividades determinadas o ciertos factores aplican tanto para la navegación u operación.', 185);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('FA015', 'Polígono de Tiro', 'Sitio designado con el propósito de disparar municiones y detonar explosivos.', 186);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('FA517', 'Unidad Militar', 'Área que es de responsabilidad de un comando jurisdiccional.', 187);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('FC046', 'Área de un Cuerpo de Agua', 'Cuerpo de agua geográficamente definido (por ejemplo: el mar u otras aguas navegables).', 188);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('ZI015', 'Colección de Nombres', 'Conjunto de nombres geográficos recogidos por una entidad de modelo que los utiliza para denotar una características junto con una ubicación geográfica adecuada para su uso en nomenclátor.', 189);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('DA031', 'Denominación de la Parcela de Tierra', 'Parcela de un territorio natural, definido por sus características geográficas y conocido por su propio nombre.', 190);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('ZD040', 'Nombre de Sitio', 'Sitio geográfico sobre la superficie de la tierra que tiene nombre propio.', 191);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('ZI005', 'Nombre Geográfico', 'Nombre usado para denotar un objeto y la información de relación para establecer el contexto del uso, por parte de una entidad de modelo específica (por ejemplo: base de datos geográfica).', 192);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('DB000', 'Superficie de la Tierra', 'Parte de la tierra geográficamente definida.', 193);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('ZI033', 'Series', 'Para representar las hojas que de acuerdo a la escala se dividen para cubrir el país', 194);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('ZD012', 'Punto de Información Geográfica', 'Región en la que múltiples características que tiene la misma función  se representa como  objeto contiguo agregado.', 196);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AI030', 'Campamento Militar', 'Instalaciones generalmente en terreno abierto que pueden ser movidas con facilidad, sirven como residencia a tiempo completo o temporal.', 176);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BD122', 'Banco de Arena', 'Acumulación de arena, grava o guijarros en el lecho de un río.', 0);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('BH165', 'Aliviadero', 'Estructura hidráulica destinada a permitir el pase libre o controlado del agua en los escurrimientos superficiales; siendo el aliviadero en exclusiva para el desagüe.', 0);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AQ035', 'Acera', 'Ruta pavimentada o mejorada para uso del peatón, normalmente se encuentra adyacente y paralela a una calle o carretera. ', 197);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AQ037', 'Bordillo', 'Borde de hormigón, asfalto o piedras que forman el borde de una acera a lo largo de la orilla de una calle o carretera. Se debe incluir aquellos que formen parte de los parterres.', 198);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('AJ110', 'Invernadero', 'Edificio construido principalmente de material transparente en el que la temperatura y la humedad puede ser controlada para el cultivo y/o protección de plantas.', 199);
INSERT INTO catalogo_objetos.catalogo_objetos (fcode, objeto, descripcion, gid) VALUES ('ZB050', 'Punto de Control', 'Objeto en el terreno de ubicación conocida, donde se ha determinado las coordenadas horizontal y/o vertical por métodos geodésicos o topográficos.', 200);


--
-- TOC entry 8067 (class 0 OID 3372863)
-- Dependencies: 445
-- Data for Name: cpa; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.cpa (cpa, cpa_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.cpa (cpa, cpa_desc) VALUES (1, '1.- Punto de referencia ');
INSERT INTO catalogo_objetos.cpa (cpa, cpa_desc) VALUES (2, '2.- Posición horizontal');
INSERT INTO catalogo_objetos.cpa (cpa, cpa_desc) VALUES (3, '3.- Posición horizontal y punto de referencia');
INSERT INTO catalogo_objetos.cpa (cpa, cpa_desc) VALUES (4, '4.- Posición astronómica');
INSERT INTO catalogo_objetos.cpa (cpa, cpa_desc) VALUES (5, '5.- Posición vertical');
INSERT INTO catalogo_objetos.cpa (cpa, cpa_desc) VALUES (8, '8.- Estación horizontal principal');
INSERT INTO catalogo_objetos.cpa (cpa, cpa_desc) VALUES (9, '9.- Estación horizontal secundaria');
INSERT INTO catalogo_objetos.cpa (cpa, cpa_desc) VALUES (10, '10.- Estación vertical principal');
INSERT INTO catalogo_objetos.cpa (cpa, cpa_desc) VALUES (11, '11.- Estación vertical secundaria');
INSERT INTO catalogo_objetos.cpa (cpa, cpa_desc) VALUES (12, '12.- Punto de triangulación');
INSERT INTO catalogo_objetos.cpa (cpa, cpa_desc) VALUES (13, '13.- Punto fijo');
INSERT INTO catalogo_objetos.cpa (cpa, cpa_desc) VALUES (14, '14.- Marca de un límite');
INSERT INTO catalogo_objetos.cpa (cpa, cpa_desc) VALUES (17, '17.- Punto de referencia de marea');
INSERT INTO catalogo_objetos.cpa (cpa, cpa_desc) VALUES (19, '19.- Gravedad');
INSERT INTO catalogo_objetos.cpa (cpa, cpa_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7977 (class 0 OID 2452419)
-- Dependencies: 324
-- Data for Name: dit; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.dit (dit, dit_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.dit (dit, dit_desc) VALUES (1, '1.- Irrigación');
INSERT INTO catalogo_objetos.dit (dit, dit_desc) VALUES (2, '2.- Drenaje');
INSERT INTO catalogo_objetos.dit (dit, dit_desc) VALUES (3, '3.- Aguas residuales');
INSERT INTO catalogo_objetos.dit (dit, dit_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7978 (class 0 OID 2452422)
-- Dependencies: 325
-- Data for Name: ela; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.ela (ela, ela_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.ela (ela, ela_desc) VALUES (1, '1.- Preciso');
INSERT INTO catalogo_objetos.ela (ela, ela_desc) VALUES (2, '2.- Aproximado');
INSERT INTO catalogo_objetos.ela (ela, ela_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7979 (class 0 OID 2452425)
-- Dependencies: 326
-- Data for Name: fco; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.fco (fco, fco_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.fco (fco, fco_desc) VALUES (1, '1.- Disperso');
INSERT INTO catalogo_objetos.fco (fco, fco_desc) VALUES (5, '5.- Divido en igual ancho');
INSERT INTO catalogo_objetos.fco (fco, fco_desc) VALUES (6, '6.- Dividido en diferente ancho');
INSERT INTO catalogo_objetos.fco (fco, fco_desc) VALUES (7, '7.- Sin divisiones');
INSERT INTO catalogo_objetos.fco (fco, fco_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 8068 (class 0 OID 3372872)
-- Dependencies: 446
-- Data for Name: ffn; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (2, '2.- Agricultura');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (3, '3.- Cultivo de productos agrícolas');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (9, '9.- Cría de animales');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (14, '14.- Pastoreo');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (15, '15.- Agricultura mixta');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (16, '16.- Migración de trabajo');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (17, '17.- Producto agrícola empacado');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (19, '19.- Caza');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (20, '20.- Explotación forestal');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (21, '21.- Silvicultura');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (27, '27.- Guardabosque');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (30, '30.- Pesca');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (35, '35.- Acuicultura');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (40, '40.- Explotación de minas y canteras');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (50, '50.- Mina de combustibles minerales sólidos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (60, '60.- Extracción de petróleo y/o gas');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (70, '70.- Minas de minerales metálicos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (81, '81.- Explotación de canteras');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (83, '83.- Minería química');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (84, '84.- Extracción de turba');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (85, '85.- Extracción de sal');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (87, '87.- Minería');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (91, '91.- Separación de gas/petróleo');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (92, '92.- Perforación');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (95, '95.- Planta de  Beneficio');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (99, '99.- Fábrica (Manufactura)');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (100, '100.- Fábrica de productos alimenticios');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (101, '101.- Procesamiento de alimentos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (102, '102.- Procesamiento de carne');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (103, '103.- Procesamiento de comida de mar');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (104, '104.- Procesamiento de frutas y vegetales');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (105, '105.- Molino de aceite');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (106, '106.- Fábrica de lácteos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (107, '107.- Molino de granos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (110, '110.- Panadería');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (111, '111.- Fabricación de azúcar');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (112, '112.- Trapiche');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (113, '113.- Refinación de azúcar');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (114, '114.- Fábrica de confites');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (115, '115.- Fábrica de pasta (fideo)');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (116, '116.- Fábrica de preparación de comida ');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (119, '119.- Fábrica de alimento animal');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (120, '120.- Fábrica  de hielo');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (121, '121.- Destilería');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (122, '122.- Lagar ');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (123, '123.- Cervecería');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (124, '124.- Fábrica de gaseosas');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (125, '125.- Fábrica de productos del tabaco');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (130, '130.- Fábrica de fibras textiles');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (140, '140.- Confección y sastrería');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (150, '150.- Fábrica de productos de cuero');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (155, '155.- Fábrica de calzado');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (161, '161.- Aserradero');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (165, '165.- Fabricación de productos de madera para construcción');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (171, '171.- Fábrica de papel');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (181, '181.- Imprenta');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (191, '191.- Fábrica de coque');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (192, '192.- Refinación del petróleo');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (195, '195.- Fábrica de productos químicos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (210, '210.- Fábrica de productos medicinales');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (221, '221.- Fábrica de productos de caucho');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (225, '225.- Fábrica de productos plásticos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (231, '231.- Fábrica de productos de vidrio');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (232, '232.- Fábrica de productos refractarios');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (233, '233.- Fábrica de productos de arcilla');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (234, '234.- Fábrica de productos de cerámica');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (235, '235.- Fábrica de cemento');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (236, '236.- Fábrica de productos de cemento ');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (237, '237.- Fábrica de productos de piedra');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (241, '241.- Siderúrgica');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (242, '242.- Refinación de metal');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (243, '243.- Fundidora');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (251, '251.- Fábrica de productos metálicos estructurales');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (255, '255.- Fábrica de municiones');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (257, '257.- Fabricá de productos metálicos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (260, '260.- Fábrica de equipos electrónicos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (270, '270.- Fábrica de equipos eléctricos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (272, '272.- Venta de propano');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (280, '280.- Fábrica de maquinaria');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (290, '290.- Fábrica de vehículos de motor');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (301, '301.- Construcción de navíos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (304, '304.- Fábrica de ferrocarriles');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (305, '305.- Fábrica de aviones');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (306, '306.- Fábrica de vehículos militares');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (310, '310.- Fábrica de muebles');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (321, '321.- Fábrica de joyas');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (322, '322.- Fábrica de instrumentos musicales');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (323, '323.- Fábrica de artículos deportivos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (324, '324.- Fábrica de juego y juguetes');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (325, '325.- Fábrica de equipos médicos y dentales');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (330, '330.- Reparación general');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (331, '331.- Reparación de productos fabricados metálicos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (332, '332.- Reparación de equipos electrónicos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (333, '333.- Reparación de aparatos eléctricos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (334, '334.- Reparación de maquinaria');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (340, '340.- Reparación de navíos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (341, '341.- Reparación de aeronaves');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (342, '342.- Reparación de ferrocarriles');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (343, '343.- Reparación de vehículos de motor');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (350, '350.- Empresa de servicios públicos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (351, '351.- Generación eléctrica');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (355, '355.- Enfriamiento');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (356, '356.- Calefactor');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (361, '361.- Captación de agua');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (362, '362.- Tratamiento de agua');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (363, '363.- Distribución de agua');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (370, '370.- Alcantarillado');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (372, '372.- Alcantarillado de detección');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (382, '382.- Baño');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (383, '383.- Tratamiento y disposición de residuos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (385, '385.- Material recuperado ');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (440, '440.- Comercio');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (459, '459.- Comerciante al por mayor');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (464, '464.- Tienda especializada');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (465, '465.- Tienda no-especializada');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (466, '466.- Tienda conveniencia');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (470, '470.- Venta de gasolina');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (473, '473.- Venta materiales de construcción');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (474, '474.- Comercio de metales preciosos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (475, '475.- Mercado');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (476, '476.- Bodega de alimentos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (477, '477.- Farmacia');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (478, '478.- Tienda de mascotas');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (480, '480.- Transporte');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (481, '481.- Terminal');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (482, '482.- Estación');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (483, '483.- Parada');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (484, '484.- Punto transferencia ');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (486, '486.- Señalización');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (487, '487.- Mantenimiento del sistema de transporte');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (488, '488.- Navegación');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (490, '490.- Transporte Ferroviario');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (491, '491.- Transporte ferroviario de pasajeros');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (494, '494.- Transporte peatonal');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (495, '495.- Transporte por carretera');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (496, '496.- Transporte de pasajeros por carretera');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (497, '497.- Transporte de mercancías por carretera');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (500, '500.- Transporte por tubería');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (501, '501.- Bombeo');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (505, '505.- Transporte por agua');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (507, '507.- Transporte en aguas continentales');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (508, '508.- Canal de transporte');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (510, '510.- Puerto de control');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (511, '511.- Pilotage Marítimo');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (512, '512.- Estación piloto');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (513, '513.- Muelles  de control');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (514, '514.- Amarradero');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (520, '520.- Transporte aéreo');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (525, '525.- Control de tráfico aéreo');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (530, '530.- Depósito y almacenamiento');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (535, '535.- Aparcamiento de vehículos de motor');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (536, '536.- Manejo de carga');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (537, '537.- Puesto de control de aduana');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (538, '538.- Estación de inspección');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (540, '540.- Apartado postal');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (545, '545.- Correo');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (550, '550.- Alojamiento');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (551, '551.- Hotel');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (552, '552.- Hotel resort');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (553, '553.- Motel');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (554, '554.- Pensión');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (555, '555.- Hostal');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (556, '556.- Dormitorio');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (557, '557.- Casa de vacaciones');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (558, '558.- Vivienda dependiente');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (559, '559.- Apartamento');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (560, '560.- Vivienda independiente');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (561, '561.- Casa adosada');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (562, '562.- Casa fabricada');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (563, '563.- Residencia');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (572, '572.- Restaurante');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (573, '573.- Bar');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (574, '574.- Comedor');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (578, '578.- Banquete');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (579, '579.- Centro de conveciones');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (582, '582.- Publicación impresa');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (594, '594.- Cinema');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (601, '601.- Radiodifusión');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (604, '604.- Televisión abierta');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (610, '610.- Telecomunicaciones');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (612, '612.- Telecomunicación minorista');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (614, '614.- Conexión de cable de telecomunicaciones');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (615, '615.- Central telefónica principal');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (616, '616.- Central Telefónica');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (617, '617.- Conexión de cable repetidor');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (620, '620.- Telecomunicaciones inalámbricas');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (621, '621.- Servicio de telefonía móvil');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (622, '622.- Repetidor inalámbrico');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (625, '625.- Telecomunicación por satélite');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (626, '626.- Control de satélites de tierra');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (633, '633.- Registros públicos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (640, '640.- Servicio Financiero');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (642, '642.- Banca Central');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (643, '643.- Banca Minorista');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (651, '651.- Seguro');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (662, '662.- Administración financiera de mercado');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (663, '663.- Servicio de correduría');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (671, '671.- Fondo de gestión');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (680, '680.- Actividad Inmobiliaria');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (691, '691.- Actividades legales ( Abogacía)');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (696, '696.- Contabilidad ');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (701, '701.- Oficina central');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (706, '706.- Administración de empresas');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (711, '711.- Consultoría de arquitectura');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (714, '714.- Ingeniería de diseño');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (717, '717.- Levantamientos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (720, '720.- Desarrollo de investigación científica');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (721, '721.- Observatorio');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (722, '722.- Estación meteorológica');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (725, '725.- Centro de investigación nuclear');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (730, '730.- Túnel aerodinámico');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (741, '741.- Publicidad');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (752, '752.- Fotografía');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (757, '757.- Veterinaria');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (761, '761.- Renta de vehículos de motor');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (770, '770.- Agencia de empleos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (775, '775.- Agencia de viajes');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (780, '780.- Aplicación de seguridad');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (781, '781.- Guardia');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (791, '791.- Servicio de limpieza');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (795, '795.- Servicio de jardinería');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (801, '801.- Oficina administrativa');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (807, '807.- Central telefónica');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (809, '809.- Jefatura');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (810, '810.- Administración');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (811, '811.- Gobierno');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (812, '812.- Gobierno local');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (813, '813.- Funciones del Estado');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (815, '815.- Palacio');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (817, '817.- Capitolio');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (821, '821.- Sitio de votación');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (822, '822.- Actividades civiles');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (825, '825.- Diplomacia');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (826, '826.- Misón diplomática');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (827, '827.- Embajada');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (828, '828.- Cónsul');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (829, '829.- Defensa Marítima');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (835, '835.- Actividades de Defensa');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (836, '836.- Arsenal');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (837, '837.- Actividades militares de reserva');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (838, '838.- Reclutamiento militar');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (839, '839.- Apoyo Civil CBRNE');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (840, '840.- Actividades judiciales');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (841, '841.- Aplicación de ley');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (842, '842.- Control de inmigración');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (843, '843.- Prisión');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (844, '844.- Correcional de menores');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (845, '845.- Bomberos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (846, '846.- Servicio de rescate y paramédicos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (847, '847.- Operaciones de emergencia');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (848, '848.- Inteligencia Civil');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (850, '850.- Educación');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (851, '851.- Educación primaria');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (852, '852.- Educación secundaria');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (855, '855.- Educación superior');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (857, '857.- Formación profesional');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (859, '859.- Institución');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (860, '860.- Actividades para salud humana');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (861, '861.- Atención al paciente interno');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (862, '862.- Atención al paciente externo');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (863, '863.- Ayuda médica urgente');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (864, '864.- Repositorio de tejido humano');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (865, '865.- Actividades de salud pública');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (866, '866.- Atención a leprosos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (871, '871.- Cuidados intermedios');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (873, '873.- Atención a pacientes psiquiátricos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (875, '875.- Cuidado residencial');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (881, '881.- Refugio de emergencia');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (882, '882.- Albergue para personas sin hogar');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (883, '883.- Albergue para refugiados');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (884, '884.- Albergue juvenil');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (885, '885.- Guardería');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (887, '887.- Trabajo social');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (888, '888.- Mitigación de servicios de emergencia');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (891, '891.- Teatro');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (892, '892.- Auditorio');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (893, '893.- Centro comunitario');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (894, '894.- Casa de opera');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (895, '895.- Night Club   ');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (902, '902.- Biblioteca');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (905, '905.- Museo');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (906, '906.- Acuario');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (907, '907.- Reserva botánica y/o zoológico');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (909, '909.- Juegos de azar');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (912, '912.- Centro deportivo');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (913, '913.- Gimnasio');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (914, '914.- Campo de tiro');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (919, '919.- Hotel de animales');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (921, '921.- Recreación ');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (922, '922.- Entretenimiento   ');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (923, '923.- Recreación y hobbies');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (930, '930.- Actividades religiosas');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (931, '931.- Lugar de culto');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (932, '932.- Sala de oración islámica');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (954, '954.- Club');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (955, '955.- Club de navegación');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (960, '960.- Servicio de venta minorista');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (961, '961.- Servicio de lavandería');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (962, '962.- Salón de Belleza');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (963, '963.- Funeraria');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (964, '964.- Cremación');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (965, '965.- Servicios mortuarios');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (966, '966.- Entretenimiento de adultos');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (970, '970.- Lugar de reunión');
INSERT INTO catalogo_objetos.ffn (ffn, ffn_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7980 (class 0 OID 2452428)
-- Dependencies: 327
-- Data for Name: fti; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.fti (fti, fti_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.fti (fti, fti_desc) VALUES (1, '1.- Metal');
INSERT INTO catalogo_objetos.fti (fti, fti_desc) VALUES (2, '2.- Madera');
INSERT INTO catalogo_objetos.fti (fti, fti_desc) VALUES (3, '3.- Mampostería');
INSERT INTO catalogo_objetos.fti (fti, fti_desc) VALUES (4, '4.- Roca');
INSERT INTO catalogo_objetos.fti (fti, fti_desc) VALUES (5, '5.- Alambre de púas');
INSERT INTO catalogo_objetos.fti (fti, fti_desc) VALUES (6, '6.- Malla');
INSERT INTO catalogo_objetos.fti (fti, fti_desc) VALUES (7, '7.- Cable electrificado');
INSERT INTO catalogo_objetos.fti (fti, fti_desc) VALUES (8, '8.- Geotextil');
INSERT INTO catalogo_objetos.fti (fti, fti_desc) VALUES (9, '9.- Redes');
INSERT INTO catalogo_objetos.fti (fti, fti_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7981 (class 0 OID 2452431)
-- Dependencies: 328
-- Data for Name: fuc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (1, '1.- Industrial');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (2, '2.- Comercial');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (3, '3.- Institucional');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (4, '4.- Residencial');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (5, '5.- Agricultura');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (6, '6.- Marítimo');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (8, '8.- Refugio');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (9, '9.- Correccional');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (10, '10.- Santuario de vida salvaje');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (12, '12.- Reserva');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (13, '13.- Recreacional');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (19, '19.- Urbanización multifuncional');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (20, '20.- Transportación');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (23, '23.- Medicina');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (24, '24.- Preservación forestal');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (26, '26.- Educacional');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (27, '27.- No comercial');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (31, '31.- Cultural');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (32, '32.- Gubernamental');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (33, '33.- Área prohibida');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (34, '34.- Servicio público');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (35, '35.- Religioso');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (36, '36.- Seguridad');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (37, '37.- Militar');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (38, '38.- Empresa de Servicio Público');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (39, '39.- Recursos para ingeniería o construcción');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (40, '40.- Almacenamiento al granel');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (41, '41.- Área de oficina');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (42, '42.- Investigación');
INSERT INTO catalogo_objetos.fuc (fuc, fuc_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7982 (class 0 OID 2452434)
-- Dependencies: 329
-- Data for Name: hct; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.hct (hct, hct_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.hct (hct, hct_desc) VALUES (1, '1.- Ruta primaria');
INSERT INTO catalogo_objetos.hct (hct, hct_desc) VALUES (2, '2.- Ruta secundaria');
INSERT INTO catalogo_objetos.hct (hct, hct_desc) VALUES (3, '3.- Autopista nacional');
INSERT INTO catalogo_objetos.hct (hct, hct_desc) VALUES (4, '4.- Ruta local');
INSERT INTO catalogo_objetos.hct (hct, hct_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7983 (class 0 OID 2452437)
-- Dependencies: 330
-- Data for Name: hyp; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.hyp (hyp, hyp_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.hyp (hyp, hyp_desc) VALUES (1, '1.- Perenne');
INSERT INTO catalogo_objetos.hyp (hyp, hyp_desc) VALUES (2, '2.- Intermitente');
INSERT INTO catalogo_objetos.hyp (hyp, hyp_desc) VALUES (3, '3.- Eventual');
INSERT INTO catalogo_objetos.hyp (hyp, hyp_desc) VALUES (4, '4.- Seco');
INSERT INTO catalogo_objetos.hyp (hyp, hyp_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7984 (class 0 OID 2452440)
-- Dependencies: 331
-- Data for Name: kos; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.kos (kos, kos_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.kos (kos, kos_desc) VALUES (1, '1.- Fútbol');
INSERT INTO catalogo_objetos.kos (kos, kos_desc) VALUES (2, '2.- Campo de atletismo');
INSERT INTO catalogo_objetos.kos (kos, kos_desc) VALUES (3, '3.- Tenis');
INSERT INTO catalogo_objetos.kos (kos, kos_desc) VALUES (4, '4.- Equitación');
INSERT INTO catalogo_objetos.kos (kos, kos_desc) VALUES (5, '5.- Natación');
INSERT INTO catalogo_objetos.kos (kos, kos_desc) VALUES (6, '6.- Pista de esquí');
INSERT INTO catalogo_objetos.kos (kos, kos_desc) VALUES (7, '7.- Patinaje de hielo');
INSERT INTO catalogo_objetos.kos (kos, kos_desc) VALUES (8, '8.- Deportes de motor');
INSERT INTO catalogo_objetos.kos (kos, kos_desc) VALUES (10, '10.- Carreras de perros');
INSERT INTO catalogo_objetos.kos (kos, kos_desc) VALUES (11, '11.- Esquí a campo traviesa');
INSERT INTO catalogo_objetos.kos (kos, kos_desc) VALUES (12, '12.- Golf');
INSERT INTO catalogo_objetos.kos (kos, kos_desc) VALUES (13, '13.- Navegación a vela');
INSERT INTO catalogo_objetos.kos (kos, kos_desc) VALUES (14, '14.- Pista de obstáculos');
INSERT INTO catalogo_objetos.kos (kos, kos_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7985 (class 0 OID 2452443)
-- Dependencies: 332
-- Data for Name: loc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.loc (loc, loc_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.loc (loc, loc_desc) VALUES (17, '17.- Sobre el fondo de un cuerpo de agua');
INSERT INTO catalogo_objetos.loc (loc, loc_desc) VALUES (23, '23.- Bajo el fondo del cuerpo de agua');
INSERT INTO catalogo_objetos.loc (loc, loc_desc) VALUES (40, '40.- Bajo la superficie');
INSERT INTO catalogo_objetos.loc (loc, loc_desc) VALUES (44, '44.- En la superficie');
INSERT INTO catalogo_objetos.loc (loc, loc_desc) VALUES (45, '45.- Sobre la superficie');
INSERT INTO catalogo_objetos.loc (loc, loc_desc) VALUES (46, '46.- Sobre el fondo del cuerpo de agua');
INSERT INTO catalogo_objetos.loc (loc, loc_desc) VALUES (47, '47.- Bajo la superficie del cuerpo de agua');
INSERT INTO catalogo_objetos.loc (loc, loc_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 8069 (class 0 OID 3372882)
-- Dependencies: 447
-- Data for Name: mcc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (2, '2.- Aluminio');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (4, '4.- Ceniza');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (5, '5.- Asfalto');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (6, '6.- Basalto');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (7, '7.- Roca Madre');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (8, '8.- Cantos rodados ');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (9, '9.- Ladrillo');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (10, '10.- Calcáreo');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (12, '12.- Tiza');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (14, '14.- Cenizas');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (15, '15.- Cirripedia');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (16, '16.- Arcilla');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (17, '17.- Hulla');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (18, '18.- Guijarro');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (19, '19.- Coque');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (20, '20.- Composición');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (21, '21.- Concreto u Hormigón');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (22, '22.- Conglomerado');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (23, '23.- Cobre');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (24, '24.- Coral');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (25, '25.- Cabeza de coral');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (28, '28.- Tierra de diatomeas');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (29, '29.- Dolomita');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (34, '34.- Flysch');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (36, '36.- Foraminífera');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (37, '37.- Fucus');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (40, '40.- Vidrio');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (42, '42.- Oro');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (43, '43.- Granito');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (45, '45.- Materia vegetal ');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (46, '46.- Grava');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (47, '47.- Diorita');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (49, '49.- Tierra de conchas');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (51, '51.- Hierro');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (52, '52.- Lava');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (54, '54.- Plomo');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (55, '55.- Loess');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (56, '56.- Madera  ');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (57, '57.- Macadán');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (58, '58.- Madrepore');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (59, '59.- Manganeso');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (60, '60.- Mármol');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (61, '61.- Marga');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (62, '62.- Mampostería');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (63, '63.- Mate');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (64, '64.- Metal');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (65, '65.- Barro');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (66, '66.- Mejillones');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (67, '67.- Aceite');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (69, '69.- Cieno');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (70, '70.- Ostras');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (71, '71.- Papel ');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (72, '72.- Parte  Metálica');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (73, '73.- Guijarro de piedra');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (74, '74.- Plástico');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (75, '75.- Algas marinas');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (76, '76.- Pórfido');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (77, '77.- Hormigón pretensado');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (79, '79.- Piedra Pómez');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (80, '80.- Cuarzo');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (81, '81.- Radiolaria');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (82, '82.- Material Radioactivo');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (83, '83.- Hormigón armado');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (84, '84.- Roca');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (85, '85.- Caucho');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (86, '86.- Escombros ');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (87, '87.- Sal');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (88, '88.- Arena');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (89, '89.- Arenisca');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (90, '90.- Esquisto');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (91, '91.- Desperdicio de minas (Spoil)');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (92, '92.- Escoria');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (95, '95.- Agua residual de mar');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (96, '96.- Concha');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (98, '98.- Guijarro de playa');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (99, '99.- Limo');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (100, '100.- Plata');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (101, '101.- Desechos de metales');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (102, '102.- Lodos');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (103, '103.- Agua congelada');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (104, '104.- Suelo');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (105, '105.- Espículas');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (106, '106.- Esponja');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (107, '107.- Acero');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (108, '108.- Piedra');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (110, '110.- Travertine');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (111, '111.- Toba');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (112, '112.- Mineral de uranio');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (113, '113.- Vegetación ');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (115, '115.- Ceniza volcánica');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (116, '116.- Agua');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (117, '117.- Madera');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (118, '118.- Zinc');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (119, '119.- Evaporita');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (120, '120.- Plástico reforzado con vidrio');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (121, '121.- Roca Metamórfica');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (122, '122.- Roca ígnea');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (123, '123.- Dolerita');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (124, '124.- Gneiss');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (125, '125.- Cuarcita');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (126, '126.- Slate');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (127, '127.- Breccia');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (128, '128.- Esquisto (shale)');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (129, '129.- Mudstone (Limolita)');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (130, '130.- Piedra caliza');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (131, '131.- Cerámica');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (132, '132.- Hielo');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (133, '133.- Laterita');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (134, '134.- Techo de teja (Roof shingle)');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (135, '135.- Nieve');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (136, '136.- Pedazo de césped');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (137, '137.- Paja');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (138, '138.- Madero');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (139, '139.- Roca Sedimentaria');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (140, '140.- Arcilla y Limo');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (141, '141.- Arena limosa');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (142, '142.- Arena y Grava');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (143, '143.- Grava y cobre');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (144, '144.- Roca y  cantos rodados');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (145, '145.- Pavimentado');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (146, '146.- Turba');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (147, '147.- Slash');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (148, '148.- Arena y barro');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (149, '149.- Ladrillo de Adobe');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (150, '150.- Madera tratada');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (151, '151.- Construcción de barro');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (152, '152.- Fibra de vidrio');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (153, '153.- Piel y/o textil');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (154, '154.- Fibra natural');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (155, '155.- Fibra óptica');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (156, '156.- Ferrocemento');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (157, '157.- Escollera');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (158, '158.- Césped');
INSERT INTO catalogo_objetos.mcc (mcc, mcc_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7986 (class 0 OID 2452446)
-- Dependencies: 333
-- Data for Name: mes; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.mes (mes, mes_desc) VALUES (0, '0.- Falso');
INSERT INTO catalogo_objetos.mes (mes, mes_desc) VALUES (1, '1.- Verdadero');


--
-- TOC entry 8070 (class 0 OID 3372892)
-- Dependencies: 448
-- Data for Name: ppo; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (1, '1.- Aeronave');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (2, '2.- Aluminio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (3, '3.- Municiones de artillería');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (4, '4.- Asfalto');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (5, '5.- Automóviles');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (6, '6.- Bambú');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (7, '7.- Plátano');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (8, '8.- Basalto');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (9, '9.- Bauxita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (11, '11.- Molusco bivalvo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (13, '13.- Ladrillo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (14, '14.- Calcáreo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (15, '15.- Cemento');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (16, '16.- Química');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (17, '17.- Arcilla');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (18, '18.- Carbón');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (19, '19.- Cantos rodados');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (20, '20.- Café');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (21, '21.- Coque');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (23, '23.- Concreto');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (24, '24.- Conglomerado');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (25, '25.- Bienes de consumo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (26, '26.- Cobre');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (27, '27.- Coral');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (28, '28.- Algodón');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (29, '29.- Crustáceos');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (30, '30.- Criadero de mariscos ');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (31, '31.- Criadero de perla');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (32, '32.- Agua desalinizada');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (33, '33.- Diamante');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (34, '34.- Tierra de diatomeas');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (35, '35.- Dolomita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (37, '37.- Energía eléctrica');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (38, '38.- Explosivo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (39, '39.- Pescado');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (41, '41.- Comida ');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (43, '43.- Agua congelada');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (44, '44.- Fruta');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (45, '45.- Gas');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (46, '46.- Gasolina o nafta');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (47, '47.- Vidrio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (48, '48.- Oro');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (49, '49.- Granos');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (50, '50.- Granito');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (52, '52.- Material vegetal');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (53, '53.- Grava');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (54, '54.- Roca verde (Jade)');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (55, '55.- Tierra de conchas');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (56, '56.- Calor');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (57, '57.- Hielo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (58, '58.- Hierro');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (59, '59.- Plomo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (60, '60.- Limo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (61, '61.- Gas natural licuado (LNG)');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (62, '62.- Gas de petróleo licuado (LPG)');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (63, '63.- Madera ');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (64, '64.- Macadán');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (65, '65.- Manganeso');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (66, '66.- Mármol');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (67, '67.- Mampostería ');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (68, '68.- Suministros médicos');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (69, '69.- Metal');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (70, '70.- Leche');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (71, '71.- Aceite mineral');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (72, '72.- Mejillones');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (73, '73.- Ningún producto');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (74, '74.- Hidrocarburos de combustible no sólidos');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (75, '75.- Aceite ');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (76, '76.- Mineral ');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (77, '77.- Ostras');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (78, '78.- Palmito');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (79, '79.- Palma');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (80, '80.- Papel');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (81, '81.- Guijarros');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (83, '83.- Petróleo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (84, '84.- Plástico');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (85, '85.- Pórfido');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (86, '86.- Agua potable');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (87, '87.- Hormigón pretensado');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (88, '88.- Pómez');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (89, '89.- Cuarzo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (90, '90.- Material radiactivo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (91, '91.- Hormigón armado');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (92, '92.- Arroz');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (93, '93.- Roca');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (94, '94.- Caucho (goma)');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (95, '95.- Sal');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (96, '96.- Arena');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (97, '97.- Arenisca');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (98, '98.- Esquisto');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (99, '99.- Escoria');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (100, '100.- Alga');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (101, '101.- Aguas residuales');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (102, '102.- Concha');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (103, '103.- Teja');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (104, '104.- Seda');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (105, '105.- Plata');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (106, '106.- Nieve');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (107, '107.- Suelo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (108, '108.- Esponja');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (109, '109.- Acero');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (110, '110.- Piedra');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (111, '111.- Azúcar');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (112, '112.- Talco');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (114, '114.- Textiles');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (115, '115.- Techo de Paja ');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (116, '116.- Madero');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (117, '117.- Tabaco');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (118, '118.- Travertino');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (119, '119.- Toba');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (120, '120.- Uranio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (121, '121.- Productos vegetales');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (122, '122.- Agua');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (123, '123.- Vino');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (124, '124.- Maderos');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (125, '125.- Pedazos de madera');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (126, '126.- Zinc');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (127, '127.- Agua destilada');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (129, '129.- Madrepora');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (130, '130.- Tiza');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (133, '133.- Marga');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (134, '134.- Algas marinas');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (135, '135.- Radiolaria');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (136, '136.- Bioquímica');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (137, '137.- Petroquímica');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (138, '138.- Brecha');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (139, '139.- Dolerita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (140, '140.- Gneis');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (141, '141.- Caliza');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (142, '142.- Cuarcita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (143, '143.- Pizarra');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (144, '144.- Paja ');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (145, '145.- Diesel');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (146, '146.- Calefacción a vapor y/o agua');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (147, '147.- Equipo electrónico');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (148, '148.- Equipo eléctrico');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (149, '149.- Salmuera');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (150, '150.- Fertilizante');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (151, '151.- Cromo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (152, '152.- Níquel');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (153, '153.- Estaño ');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (154, '154.- Municiones');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (155, '155.- Aceite de oliva');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (156, '156.- Productos de ballena');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (157, '157.- Petróleo y/o gas natural');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (158, '158.- Cerámica');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (159, '159.- Carbón Vegetal');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (160, '160.- Grano molido');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (161, '161.- Metano en capas de carbón');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (162, '162.- Gas natural condensado');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (163, '163.- Helio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (164, '164.- Fluído hidrotermal');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (165, '165.- Vestimenta');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (166, '166.- Emulsión');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (167, '167.- Roca suelta');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (169, '169.- Color de arcilla');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (171, '171.- Feldespato');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (172, '172.- Carne');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (173, '173.- Fluorita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (174, '174.- Alimentación animal');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (175, '175.- Vegetales');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (176, '176.- Especia');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (177, '177.- Yeso');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (178, '178.- Graniodiorita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (179, '179.- Grafito');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (180, '180.- Grauvaca');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (182, '182.- Yute');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (183, '183.- Cacao');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (184, '184.- Sal de potasio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (185, '185.- Calcita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (186, '186.- Caolín');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (187, '187.- Pipfruit ');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (188, '188.- Tierra silícea');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (189, '189.- Kiwi');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (190, '190.- Ácido carbónico');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (191, '191.- Estiércol');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (192, '192.- Lubricante de petróleo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (193, '193.- Combustible');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (194, '194.- Loam');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (196, '196.- Almendra');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (199, '199.- Monacita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (201, '201.- Aceitunas');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (202, '202.- Petróleo de esquistos');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (203, '203.- Arena pegmatita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (204, '204.- Fostato');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (205, '205.- Platino');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (206, '206.- Arena de cuarzo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (207, '207.- Mercurio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (208, '208.- Nitro (salitre)');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (210, '210.- Buque');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (211, '211.- Sulfuro');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (212, '212.- Barita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (214, '214.- Biodiesel');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (215, '215.- Carbón bituminoso');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (216, '216.- Hálito');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (217, '217.- Esquisto de talco');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (218, '218.- Teca');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (219, '219.- Té');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (220, '220.- Titanio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (221, '221.- Piedra de arcilla');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (222, '222.- Turba (peat)');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (223, '223.- Trass');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (224, '224.- Vanadio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (225, '225.- Copernicia');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (226, '226.- Nuez ');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (227, '227.- Incienso');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (228, '228.- Bismuto');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (229, '229.- Tungsteno');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (231, '231.- Frutas cítricas');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (233, '233.- Desperdicio de  minas');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (234, '234.- Aceite de palma');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (235, '235.- Cerveza');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (236, '236.- Kerosene');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (250, '250.- Mineral de alumnio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (251, '251.- Antracita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (252, '252.- Mineral de antimonio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (253, '253.- Arsénico');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (254, '254.- Bario');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (256, '256.- Ámbar');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (257, '257.- Berilo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (258, '258.- Berilio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (259, '259.- Mineral de berilio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (260, '260.- Mineral de plomo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (261, '261.- Boro');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (262, '262.- Borato');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (263, '263.- Sal de boro o borax');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (264, '264.- Lignito (Brown coal)');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (265, '265.- Bromo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (266, '266.- Sal de bromo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (267, '267.- Cadmio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (268, '268.- Cesio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (269, '269.- Mineral de Cesio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (270, '270.- Calcio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (271, '271.- Cerio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (272, '272.- Cloro');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (273, '273.- Mineral de cromo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (274, '274.- Metal precioso');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (275, '275.- Mineral de hierro');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (276, '276.- Gas natural');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (277, '277.- Aleaciones de hierro');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (278, '278.- Combustible sólido de hidrocarburo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (279, '279.- Flúor');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (280, '280.- Fluoruro');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (281, '281.- Galio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (282, '282.- Germanio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (283, '283.- Mica');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (284, '284.- Mineral de oro');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (285, '285.- Granate');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (286, '286.- Metaloide');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (287, '287.- Indio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (288, '288.- Industria mineral');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (289, '289.- Arena industrial');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (290, '290.- Iridio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (291, '291.- Yodo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (292, '292.- Sal yodada');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (293, '293.- Potasio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (294, '294.- Caolinita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (295, '295.- Cobalto');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (296, '296.- Mineral de cobalto');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (297, '297.- Carbono');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (298, '298.- Corindón');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (299, '299.- Mineral de cobre');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (300, '300.- Lantano');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (301, '301.- Lazurita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (302, '302.- Metal ligero');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (303, '303.- Litio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (304, '304.- Mineral Litio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (305, '305.- Magnesito');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (306, '306.- Magnesio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (308, '308.- Mineral magnesio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (309, '309.- Mineral manganeso');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (310, '310.- Mineral metal');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (311, '311.- Molibdeno');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (312, '312.- Mineral molibdeno');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (313, '313.- Sodio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (314, '314.- Sulfato de sodio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (317, '317.- Minerales no metálicos');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (318, '318.- Mineral níquel');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (319, '319.- Niobio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (320, '320.- Mineral niobio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (321, '321.- Arenisca con petróleo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (322, '322.- Ópalo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (323, '323.- Osmio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (324, '324.- Paladio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (325, '325.- Fósforo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (326, '326.- Metales de  platino');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (327, '327.- Mineral de metales de platino');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (328, '328.- Mineral mercurio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (329, '329.- Renio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (330, '330.- Rodio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (331, '331.- Rubidio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (332, '332.- Rubí');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (333, '333.- Rutenio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (334, '334.- Sal (química)');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (335, '335.- Zafiro');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (336, '336.- Escandio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (337, '337.- Aceite de lutita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (338, '338.- Mineral de sulfuro');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (339, '339.- Selenio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (340, '340.- Raros minerales de la tierra');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (341, '341.- Raros elementos de la tierra');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (342, '342.- Mineral de plata');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (343, '343.- Silicio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (344, '344.- Esmeralda');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (346, '346.- Estroncio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (347, '347.- Tantalio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (348, '348.- Mineral de tantalio ');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (349, '349.- Alquitrán de arenisca');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (350, '350.- Teluro');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (351, '351.- Talio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (352, '352.- Torio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (353, '353.- Mineral torio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (354, '354.- Mineral titanio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (355, '355.- Topacio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (356, '356.- Mineral uranio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (357, '357.- Mineral vanadio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (358, '358.- Vermiculita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (359, '359.- Mineral bismuto');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (360, '360.- Mineral tungsteno');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (361, '361.- Wollastonita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (362, '362.- Itrio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (363, '363.- Zeolita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (364, '364.- Mineral zinc');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (365, '365.- Mineral estaño');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (366, '366.- Circón');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (367, '367.- Circonio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (368, '368.- Mineral de circonio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (369, '369.- Loess');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (371, '371.- Pastos marinos');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (372, '372.- Fragmentos de madera');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (373, '373.- Andesita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (374, '374.- Anhidrita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (375, '375.- Antimonio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (376, '376.- Asbesto');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (377, '377.- Material de construcción');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (378, '378.- Bentonita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (379, '379.- Industria de agua');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (380, '380.- Minerales no ferrosos');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (381, '381.- Aguamarina');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (382, '382.- Diabasa');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (383, '383.- Diatomita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (384, '384.- Diorita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (385, '385.- Plutonite');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (386, '386.- Flint');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (387, '387.- Gabro');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (388, '388.- Gypsolithe');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (389, '389.- Chert');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (390, '390.- Jade');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (391, '391.- Roca de cal de silicato');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (392, '392.- Roca silícea');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (393, '393.- Dióxido de carbono');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (394, '394.- Arenas de aceite');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (395, '395.- Periodite ');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (396, '396.- Radiolarite');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (397, '397.- Roca acuosa');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (398, '398.- Limo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (399, '399.- Limolita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (400, '400.- Sienita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (402, '402.- Arena de alquitrán');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (403, '403.- Traquita');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (404, '404.- Tuff  (toba)');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (405, '405.- Tuffite');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (407, '407.- Turmalina');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (408, '408.- Ceniza volcánica');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (409, '409.- Rocas volcánicas sueltas');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (410, '410.- Pintura');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (411, '411.- Armas');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (412, '412.- Ferrocarril');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (413, '413.- Basura');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (414, '414.- Container');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (415, '415.- Casas móviles');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (416, '416.- Productos de arcilla');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (417, '417.- Componentes de maquinaria');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (419, '419.- Líquidos Inflamables');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (421, '421.- Combustible sólido');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (422, '422.- Elementos férreos');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (423, '423.- Elementos sin hierro ');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (425, '425.- Misiles militares');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (426, '426.- Heroína');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (427, '427.- Cocaína');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (428, '428.- Opio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (429, '429.- Marihuana');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (430, '430.- Hachís');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (431, '431.- Armas Nbc');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (432, '432.- Armas nucleares');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (433, '433.- Armas químicas');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (434, '434.- Armas biológicas');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (435, '435.- Combustible nuclear');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (436, '436.- Metales no ferrosos');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (437, '437.- Alúmina');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (438, '438.- Plutonio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (439, '439.- Esponja de titanio ');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (440, '440.- Ferrocolumbite');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (441, '441.- Aluminio en polvo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (442, '442.- Arseniuro de galio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (443, '443.- Ferrocromo');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (444, '444.- Ferromanganeso');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (445, '445.- Ferroníquel');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (446, '446.- Ferromolibdeno');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (447, '447.- Ferrotungsten');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (448, '448.- Ferrovanadio');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (449, '449.- Azafrán');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (450, '450.- Aceite de rosas');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (451, '451.- Neumáticos');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (452, '452.- Productos farmaceúticos');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (453, '453.- Coltán');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (454, '454.- Acumulador');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (455, '455.- Narcóticos');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (456, '456.- Mineral de metales preciosos');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (457, '457.- Piedras preciosas');
INSERT INTO catalogo_objetos.ppo (ppo, ppo_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 8064 (class 0 OID 3372831)
-- Dependencies: 442
-- Data for Name: psf; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (1, '1.- Hospital');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (2, '2.- Estación de policía');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (3, '3.- Estación de guardabosques');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (4, '4.- Oficina de salud');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (5, '5.- Oficina de correos');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (6, '6.- Estación de bomberos');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (8, '8.- Estación de vehículos a motor');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (9, '9.- Estación de policía fluvial');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (10, '10.- Estación de rescate');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (12, '12.- Centro médico');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (13, '13.- Sanatorio');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (16, '16.- Estación de bomberos y policía');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (19, '19.- Dependencia ');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (21, '21.- Información turística');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (22, '22.- Congreso ');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (23, '23.- Organización de mitigación (Refugio)');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (24, '24.- Veterinaria');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (25, '25.- Orfanato');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (26, '26.- Estación de guardacostas');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (27, '27.- Estación de bomberos de mar ');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (28, '28.- Refugio de montaña');
INSERT INTO catalogo_objetos.psf (psf, psf_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 8071 (class 0 OID 3372898)
-- Dependencies: 449
-- Data for Name: pwc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (1, '1.- Muelle (conjunto de muelles)');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (2, '2.- Muelle (muelle largo)');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (3, '3.- Muelle');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (4, '4.- Rompeolas (breakwater)');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (5, '5.- Groin ');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (6, '6.- Mole');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (7, '7.- Muelle recreativo');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (8, '8.- Muro en formación');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (9, '9.- Escollera');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (10, '10.- Revestimiento');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (11, '11.- Rompeolas (seawall)');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (12, '12.- Pasos de aterrizaje');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (13, '13.- Rampa');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (14, '14.- Varadero');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (15, '15.- Muelle de cara sólida');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (16, '16.- Muelle de cara abierta');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (17, '17.- Rampa conectada');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (18, '18.- Espolón');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (21, '21.- Defensa');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (22, '22.- Obstáculo artificial');
INSERT INTO catalogo_objetos.pwc (pwc, pwc_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7987 (class 0 OID 2452449)
-- Dependencies: 334
-- Data for Name: rdt; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rdt (rdt, rdt_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rdt (rdt, rdt_desc) VALUES (2, '2.- Tránsito rápido');
INSERT INTO catalogo_objetos.rdt (rdt, rdt_desc) VALUES (3, '3.- Privada');
INSERT INTO catalogo_objetos.rdt (rdt, rdt_desc) VALUES (4, '4.- Servicio');
INSERT INTO catalogo_objetos.rdt (rdt, rdt_desc) VALUES (5, '5.- Alta velocidad');
INSERT INTO catalogo_objetos.rdt (rdt, rdt_desc) VALUES (6, '6.- Ruta');
INSERT INTO catalogo_objetos.rdt (rdt, rdt_desc) VALUES (7, '7.- Circunvalación');
INSERT INTO catalogo_objetos.rdt (rdt, rdt_desc) VALUES (11, '11.- Camino corto');
INSERT INTO catalogo_objetos.rdt (rdt, rdt_desc) VALUES (45, '45.- Camino de herradura');
INSERT INTO catalogo_objetos.rdt (rdt, rdt_desc) VALUES (46, '46.- Cruce/intersección de caminos');
INSERT INTO catalogo_objetos.rdt (rdt, rdt_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7988 (class 0 OID 2452452)
-- Dependencies: 335
-- Data for Name: rel; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rel (rel, rel_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rel (rel, rel_desc) VALUES (1, '1.- Budismo');
INSERT INTO catalogo_objetos.rel (rel, rel_desc) VALUES (2, '2.- Islam');
INSERT INTO catalogo_objetos.rel (rel, rel_desc) VALUES (3, '3.- Católica Romana');
INSERT INTO catalogo_objetos.rel (rel, rel_desc) VALUES (4, '4.- Cristiana');
INSERT INTO catalogo_objetos.rel (rel, rel_desc) VALUES (5, '5.- Judaísmo');
INSERT INTO catalogo_objetos.rel (rel, rel_desc) VALUES (6, '6.- Ortodoxa');
INSERT INTO catalogo_objetos.rel (rel, rel_desc) VALUES (7, '7.- Protestante');
INSERT INTO catalogo_objetos.rel (rel, rel_desc) VALUES (8, '8.- Sintoísmo');
INSERT INTO catalogo_objetos.rel (rel, rel_desc) VALUES (9, '9.- Hinduismo');
INSERT INTO catalogo_objetos.rel (rel, rel_desc) VALUES (10, '10.- Chiísmo');
INSERT INTO catalogo_objetos.rel (rel, rel_desc) VALUES (11, '11.- Suníes');
INSERT INTO catalogo_objetos.rel (rel, rel_desc) VALUES (12, '12.- Nestoriana');
INSERT INTO catalogo_objetos.rel (rel, rel_desc) VALUES (13, '13.- Caldea');
INSERT INTO catalogo_objetos.rel (rel, rel_desc) VALUES (15, '15.- Religión tribal');
INSERT INTO catalogo_objetos.rel (rel, rel_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 8072 (class 0 OID 3372904)
-- Dependencies: 450
-- Data for Name: res; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.res (res, res_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.res (res, res_desc) VALUES (1, '1.- Estación astronómica');
INSERT INTO catalogo_objetos.res (res, res_desc) VALUES (2, '2.- Observatorio');
INSERT INTO catalogo_objetos.res (res, res_desc) VALUES (3, '3.- Centro de investigación');
INSERT INTO catalogo_objetos.res (res, res_desc) VALUES (4, '4.- Estación meteorológica');
INSERT INTO catalogo_objetos.res (res, res_desc) VALUES (5, '5.- Investigación nuclear');
INSERT INTO catalogo_objetos.res (res, res_desc) VALUES (6, '6.- Acelerador de partículas');
INSERT INTO catalogo_objetos.res (res, res_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7989 (class 0 OID 2452455)
-- Dependencies: 336
-- Data for Name: rgc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rgc (rgc, rgc_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rgc (rgc, rgc_desc) VALUES (1, '1.- Amplia');
INSERT INTO catalogo_objetos.rgc (rgc, rgc_desc) VALUES (2, '2.- Angosta/estrecha');
INSERT INTO catalogo_objetos.rgc (rgc, rgc_desc) VALUES (3, '3.- Estándar/normal');
INSERT INTO catalogo_objetos.rgc (rgc, rgc_desc) VALUES (6, '6.- Monocarril');
INSERT INTO catalogo_objetos.rgc (rgc, rgc_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7990 (class 0 OID 2452458)
-- Dependencies: 337
-- Data for Name: rra; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rra (rra, rra_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rra (rra, rra_desc) VALUES (1, '1.- Carril electrificado');
INSERT INTO catalogo_objetos.rra (rra, rra_desc) VALUES (3, '3.- Electrificación aérea');
INSERT INTO catalogo_objetos.rra (rra, rra_desc) VALUES (4, '4.- No electrificada');
INSERT INTO catalogo_objetos.rra (rra, rra_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7991 (class 0 OID 2452461)
-- Dependencies: 338
-- Data for Name: rrc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rrc (rrc, rrc_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rrc (rrc, rrc_desc) VALUES (2, '2.- Carline');
INSERT INTO catalogo_objetos.rrc (rrc, rrc_desc) VALUES (6, '6.- Ferrocarril subterráneo');
INSERT INTO catalogo_objetos.rrc (rrc, rrc_desc) VALUES (8, '8.- Transporte para madera');
INSERT INTO catalogo_objetos.rrc (rrc, rrc_desc) VALUES (10, '10.- Miniatura');
INSERT INTO catalogo_objetos.rrc (rrc, rrc_desc) VALUES (11, '11.- Tránsito rápido (Metro)');
INSERT INTO catalogo_objetos.rrc (rrc, rrc_desc) VALUES (13, '13.- Ferrocarril ayuda marina');
INSERT INTO catalogo_objetos.rrc (rrc, rrc_desc) VALUES (14, '14.- Tranvía');
INSERT INTO catalogo_objetos.rrc (rrc, rrc_desc) VALUES (15, '15.- Funicular');
INSERT INTO catalogo_objetos.rrc (rrc, rrc_desc) VALUES (24, '24.- Museo');
INSERT INTO catalogo_objetos.rrc (rrc, rrc_desc) VALUES (32, '32.- Sistema de tránsito automatizado');
INSERT INTO catalogo_objetos.rrc (rrc, rrc_desc) VALUES (33, '33.- Larga distancia');
INSERT INTO catalogo_objetos.rrc (rrc, rrc_desc) VALUES (998, '998.-  No aplica');


--
-- TOC entry 7992 (class 0 OID 2452464)
-- Dependencies: 339
-- Data for Name: rst; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (1, '1.- Duro/pavimentado');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (2, '2.- Suelto/no pavimentado');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (3, '3.- Suelto/ligero');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (4, '4.- Troncos entrecruzados');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (5, '5.- Hierba/césped');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (6, '6.- Sin mejoras');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (7, '7.- Permanente');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (8, '8.- Temporal');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (9, '9.- Composición dura');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (10, '10.- PEM');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (11, '11.- Bituminosas');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (12, '12.- Composición suave');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (13, '13.- Tierra clasificada');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (14, '14.- Tierra sin clasificar');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (15, '15.- Hielo');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (16, '16.- Nieve');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (17, '17.- Macadán');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (18, '18.- Membrana');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (19, '19.- Mezcla');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (20, '20.- Laterita');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (21, '21.- Arena');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (22, '22.- Asfalto sobre concreto');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (23, '23.- Encofrado de acero perforado');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (24, '24.- Grava');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (25, '25.- Coral');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (26, '26.- Arcilla');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (27, '27.- Concreto');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (28, '28.- Ladrillo');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (29, '29.- Asfáltica');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (30, '30.- Ceniza');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (31, '31.- Empedrada');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (32, '32.- Concha');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (33, '33.- Tablón de madera');
INSERT INTO catalogo_objetos.rst (rst, rst_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 8073 (class 0 OID 3372921)
-- Dependencies: 451
-- Data for Name: scc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.scc (scc, scc_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.scc (scc, scc_desc) VALUES (1, '1.- Alcalina');
INSERT INTO catalogo_objetos.scc (scc, scc_desc) VALUES (4, '4.- Mineral');
INSERT INTO catalogo_objetos.scc (scc, scc_desc) VALUES (9, '9.- Potable');
INSERT INTO catalogo_objetos.scc (scc, scc_desc) VALUES (10, '10.- Salada');
INSERT INTO catalogo_objetos.scc (scc, scc_desc) VALUES (11, '11.- Fresca');
INSERT INTO catalogo_objetos.scc (scc, scc_desc) VALUES (12, '12.- Salobre');
INSERT INTO catalogo_objetos.scc (scc, scc_desc) VALUES (13, '13.- Agua de mar');
INSERT INTO catalogo_objetos.scc (scc, scc_desc) VALUES (14, '14.- Más salada que el agua de mar');
INSERT INTO catalogo_objetos.scc (scc, scc_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7993 (class 0 OID 2452467)
-- Dependencies: 340
-- Data for Name: slt; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.slt (slt, slt_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.slt (slt, slt_desc) VALUES (6, '6.- Manglar');
INSERT INTO catalogo_objetos.slt (slt, slt_desc) VALUES (8, '8.- Pantano');
INSERT INTO catalogo_objetos.slt (slt, slt_desc) VALUES (11, '11.- Escombros de construcción');
INSERT INTO catalogo_objetos.slt (slt, slt_desc) VALUES (12, '12.- Escombros de erosión');
INSERT INTO catalogo_objetos.slt (slt, slt_desc) VALUES (13, '13.- Arenoso');
INSERT INTO catalogo_objetos.slt (slt, slt_desc) VALUES (14, '14.- Guijarros');
INSERT INTO catalogo_objetos.slt (slt, slt_desc) VALUES (15, '15.- Rocoso');
INSERT INTO catalogo_objetos.slt (slt, slt_desc) VALUES (16, '16.- Coral');
INSERT INTO catalogo_objetos.slt (slt, slt_desc) VALUES (17, '17.- Hielo');
INSERT INTO catalogo_objetos.slt (slt, slt_desc) VALUES (18, '18.- Barro');
INSERT INTO catalogo_objetos.slt (slt, slt_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7994 (class 0 OID 2452470)
-- Dependencies: 341
-- Data for Name: smc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (2, '2.- Aluminio');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (4, '4.- Ceniza');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (5, '5.- Asfalto');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (6, '6.- Basalto');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (7, '7.- Roca Madre');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (8, '8.- Cantos Rodados');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (9, '9.- Ladrillo');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (10, '10.- Calcáreo');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (12, '12.- Tiza');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (14, '14.- Cenizas');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (15, '15.- Cirripedia');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (16, '16.- Arcilla');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (17, '17.- Carbón');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (18, '18.- Empedrado');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (19, '19.- Coque');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (20, '20.- Composición');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (21, '21.- Concreto u Hormigón');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (22, '22.- Conglomerado');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (23, '23.- Cobre');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (24, '24.- Coral');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (25, '25.- Coral Head');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (28, '28.- Tierra de diatomeas');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (29, '29.- Dolomita');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (34, '34.- Flysch');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (36, '36.- Foraminíferos');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (37, '37.- Fucus');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (40, '40.- Vidrio');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (42, '42.- Oro');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (43, '43.- Granito');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (45, '45.- Materia vegetal');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (46, '46.- Grava');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (47, '47.- Rocaverde (Jade)');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (49, '49.- Suelo  de conchas');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (51, '51.- Hierro');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (52, '52.- Lava');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (54, '54.- Plomo');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (55, '55.- Loess');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (56, '56.- Maderos');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (57, '57.- Macadán');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (58, '58.- Madrépora');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (59, '59.- Manganeso');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (60, '60.- Mármol');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (61, '61.- Marga');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (62, '62.- Mampostería');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (63, '63.- Mate');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (64, '64.- Metal');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (65, '65.- Barro');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (66, '66.- Mejillones');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (67, '67.- Aceite');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (69, '69.- Cieno');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (70, '70.- Ostras');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (71, '71.- Papel');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (72, '72.- Parte  Metálica');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (73, '73.- Guijarros');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (74, '74.- Plástico');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (75, '75.- Algas marinas');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (76, '76.- Pórfido');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (77, '77.- Hormigón pretensado');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (79, '79.- Piedra Pómez');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (80, '80.- Cuarzo');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (81, '81.- Radiolario');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (82, '82.- Material radiactivo');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (83, '83.- Hormigón armado');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (84, '84.- Piedras');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (85, '85.- Caucho');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (86, '86.- Escombros');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (87, '87.- Sal');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (88, '88.- Arena');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (89, '89.- Arenisca');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (90, '90.- Esquisto');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (91, '91.- Desperdicio de minas');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (92, '92.- Escoria');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (95, '95.- Aguas Residuales');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (96, '96.- Concha');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (98, '98.- Guijarro');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (99, '99.- Limo');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (100, '100.- Plata');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (101, '101.- Desechos de metales');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (102, '102.- Lodos');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (103, '103.- Agua congelada');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (104, '104.- Suelo');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (105, '105.- Espículas');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (106, '106.- Esponja');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (107, '107.- Acero');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (108, '108.- Piedra preciosa');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (110, '110.- Travertino');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (111, '111.- Toba');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (112, '112.- Mineral de  uranio');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (113, '113.- Vegetación');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (115, '115.- Ceniza Volcánica');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (116, '116.- Agua');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (117, '117.- Madera');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (118, '118.- Zinc');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (120, '120.- Arena y Grava');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (121, '121.- Escollera');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (122, '122.- Evaporita');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (124, '124.- Arena y rocas');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (126, '126.- Arena y barro');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (128, '128.- Plástico reforzado con vidrio (GRP)');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (129, '129.- Roca metomórfica');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (130, '130.- Roca  ígnea');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (131, '131.- Dolerita');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (205, '205.- Pintura');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (257, '257.- Hielo');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (258, '258.- Nieve');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (262, '262.- Laterita');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (266, '266.- Breccia');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (267, '267.- Cerámica');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (268, '268.- Gneis');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (269, '269.- Caliza');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (270, '270.- Cuarcita');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (271, '271.- Teja');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (272, '272.- Lutita – esquisto');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (273, '273.- Pizarra');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (274, '274.- Césped');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (275, '275.- Paja');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (276, '276.- Madero');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (277, '277.- Roca sedimentaria');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (278, '278.- Adobe');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (279, '279.- Madera tratada');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (280, '280.- Pasto');
INSERT INTO catalogo_objetos.smc (smc, smc_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 8074 (class 0 OID 3372927)
-- Dependencies: 452
-- Data for Name: tfc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (1, '1.- Rotonda para  locomotoras');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (2, '2.- Reparación de ferrocarriles');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (3, '3.- Terminal de depósito');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (4, '4.- Taller de mantenimiento de aviones ');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (5, '5.- Hangar de aviones');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (6, '6.- Casa de descanso en la carretera');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (7, '7.- Estación de mantenimiento de carreteras');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (8, '8.- Club de yates');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (9, '9.- Estación de observación');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (10, '10.- Señal de ferrocarril');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (11, '11.- Capitanía marítima');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (12, '12.- Control de puerto');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (13, '13.- Estación marítima');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (14, '14.- Faro');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (15, '15.- Estación de ferrocarril');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (16, '16.- Estación de Pesaje');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (17, '17.- Terminal de aeródromo');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (18, '18.- Terminal de autobuses');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (19, '19.- Oficina pilota');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (20, '20.- Estación de vigilancia pilota');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (21, '21.- Dependencia');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (22, '22.- Parada de taxis');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (23, '23.- Refugio de autobús');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (24, '24.- Parada de autobús');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (27, '27.- Estación de transbordador');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (28, '28.- Estación de automóviles');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (29, '29.- Garaje residencial');
INSERT INTO catalogo_objetos.tfc (tfc, tfc_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7995 (class 0 OID 2452473)
-- Dependencies: 342
-- Data for Name: tra; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.tra (tra, tra_desc) VALUES (0, '0.- Falso');
INSERT INTO catalogo_objetos.tra (tra, tra_desc) VALUES (1, '1.- Verdadero');


--
-- TOC entry 7996 (class 0 OID 2452476)
-- Dependencies: 343
-- Data for Name: tuc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.tuc (tuc, tuc_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.tuc (tuc, tuc_desc) VALUES (19, '19.- Ganadería');
INSERT INTO catalogo_objetos.tuc (tuc, tuc_desc) VALUES (25, '25.- Carga');
INSERT INTO catalogo_objetos.tuc (tuc, tuc_desc) VALUES (26, '26.- Pasajeros');
INSERT INTO catalogo_objetos.tuc (tuc, tuc_desc) VALUES (33, '33.- Minerales');
INSERT INTO catalogo_objetos.tuc (tuc, tuc_desc) VALUES (35, '35.- No para transporte');
INSERT INTO catalogo_objetos.tuc (tuc, tuc_desc) VALUES (45, '45.- General');
INSERT INTO catalogo_objetos.tuc (tuc, tuc_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7997 (class 0 OID 2452479)
-- Dependencies: 344
-- Data for Name: typ; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (1, '1.- Carretera');
INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (5, '5.- Bulevar');
INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (9, '9.- Avenida');
INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (13, '13.- Paseo');
INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (17, '17.- Curva de retorno');
INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (21, '21.- Cerrada');
INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (25, '25.- Ruta verde (Parkway)');
INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (29, '29.- Pasaje');
INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (33, '33.- Calle');
INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (37, '37.- Terraza');
INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (41, '41.- Autopista');
INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (45, '45.- Plaza');
INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (46, '46.- Rodera');
INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (47, '47.- Autopista de acceso restringido');
INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (48, '48.- Redondel');
INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (49, '49.- Sendero');
INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (50, '50.- Rampa');
INSERT INTO catalogo_objetos.typ (typ, typ_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7998 (class 0 OID 2452482)
-- Dependencies: 345
-- Data for Name: uuc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.uuc (uuc, uuc_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.uuc (uuc, uuc_desc) VALUES (4, '4.- Transformador');
INSERT INTO catalogo_objetos.uuc (uuc, uuc_desc) VALUES (5, '5.- Desagüe');
INSERT INTO catalogo_objetos.uuc (uuc, uuc_desc) VALUES (6, '6.- Represa');
INSERT INTO catalogo_objetos.uuc (uuc, uuc_desc) VALUES (7, '7.- Agua potable');
INSERT INTO catalogo_objetos.uuc (uuc, uuc_desc) VALUES (9, '9.- Dependencia');
INSERT INTO catalogo_objetos.uuc (uuc, uuc_desc) VALUES (10, '10.- Central eléctrica');
INSERT INTO catalogo_objetos.uuc (uuc, uuc_desc) VALUES (11, '11.- Planta de filtración');
INSERT INTO catalogo_objetos.uuc (uuc, uuc_desc) VALUES (12, '12.- Refrigeración');
INSERT INTO catalogo_objetos.uuc (uuc, uuc_desc) VALUES (18, '18.- Central de abastecimiento de agua');
INSERT INTO catalogo_objetos.uuc (uuc, uuc_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 7999 (class 0 OID 2452485)
-- Dependencies: 346
-- Data for Name: wtc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.wtc (wtc, wtc_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.wtc (wtc, wtc_desc) VALUES (1, '1.- Todo el tiempo (todo el año)');
INSERT INTO catalogo_objetos.wtc (wtc, wtc_desc) VALUES (3, '3.- Solamente en invierno');
INSERT INTO catalogo_objetos.wtc (wtc, wtc_desc) VALUES (4, '4.- Limitada todo el tiempo');
INSERT INTO catalogo_objetos.wtc (wtc, wtc_desc) VALUES (5, '5.- Cerrada en invierno');
INSERT INTO catalogo_objetos.wtc (wtc, wtc_desc) VALUES (998, '998.- No aplica');
INSERT INTO catalogo_objetos.wtc (wtc, wtc_desc) VALUES (2, '2.- Buen clima (época seca)');


--
-- TOC entry 8000 (class 0 OID 2452488)
-- Dependencies: 347
-- Data for Name: wti; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.wti (wti, wti_desc) VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.wti (wti, wti_desc) VALUES (1, '1.- Independiente');
INSERT INTO catalogo_objetos.wti (wti, wti_desc) VALUES (2, '2.- Retener (obstaculizar)');
INSERT INTO catalogo_objetos.wti (wti, wti_desc) VALUES (4, '4.- Cercado con árboles');
INSERT INTO catalogo_objetos.wti (wti, wti_desc) VALUES (5, '5.- Cerramiento');
INSERT INTO catalogo_objetos.wti (wti, wti_desc) VALUES (998, '998.- No aplica');


--
-- TOC entry 8116 (class 0 OID 3376060)
-- Dependencies: 512
-- Data for Name: zona_sin_informacion_a; Type: TABLE DATA; Schema: ct_miscelaneos; Owner: postgres
--



--
-- TOC entry 8112 (class 0 OID 3375809)
-- Dependencies: 507
-- Data for Name: limite_administrativo_l; Type: TABLE DATA; Schema: d_limite_politico_administrativo; Owner: postgres
--



--
-- TOC entry 8134 (class 0 OID 3484355)
-- Dependencies: 541
-- Data for Name: zona_administrativa_a; Type: TABLE DATA; Schema: d_limite_politico_administrativo; Owner: postgres
--



--
-- TOC entry 8001 (class 0 OID 2452491)
-- Dependencies: 348
-- Data for Name: punto_control_p; Type: TABLE DATA; Schema: d_linderos_propiedad; Owner: postgres
--



--
-- TOC entry 8003 (class 0 OID 2452503)
-- Dependencies: 350
-- Data for Name: cementerio_a; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 8005 (class 0 OID 2452515)
-- Dependencies: 352
-- Data for Name: cerca_l; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 8076 (class 0 OID 3373061)
-- Dependencies: 454
-- Data for Name: choza_a; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 8007 (class 0 OID 2452527)
-- Dependencies: 354
-- Data for Name: escalinata_a; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 8118 (class 0 OID 3376095)
-- Dependencies: 515
-- Data for Name: muro_a; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 8009 (class 0 OID 2452539)
-- Dependencies: 356
-- Data for Name: muro_l; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 8011 (class 0 OID 2452551)
-- Dependencies: 358
-- Data for Name: plaza_publica_a; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 8108 (class 0 OID 3375731)
-- Dependencies: 501
-- Data for Name: estructura_no_construida_a; Type: TABLE DATA; Schema: gs_comercio; Owner: postgres
--



--
-- TOC entry 8110 (class 0 OID 3375762)
-- Dependencies: 503
-- Data for Name: instalacion_a; Type: TABLE DATA; Schema: gs_comercio; Owner: postgres
--



--
-- TOC entry 8078 (class 0 OID 3373130)
-- Dependencies: 456
-- Data for Name: edificio_a; Type: TABLE DATA; Schema: gs_construcciones; Owner: postgres
--



--
-- TOC entry 8013 (class 0 OID 2452575)
-- Dependencies: 360
-- Data for Name: cancha_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 8015 (class 0 OID 2452587)
-- Dependencies: 362
-- Data for Name: estadio_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 8017 (class 0 OID 2452599)
-- Dependencies: 364
-- Data for Name: parque_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 8086 (class 0 OID 3373597)
-- Dependencies: 467
-- Data for Name: paseo_maritimo_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 8019 (class 0 OID 2452611)
-- Dependencies: 366
-- Data for Name: piscina_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 8021 (class 0 OID 2452623)
-- Dependencies: 368
-- Data for Name: plaza_toros_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 8080 (class 0 OID 3373202)
-- Dependencies: 459
-- Data for Name: recinto_ferial_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 8082 (class 0 OID 3373241)
-- Dependencies: 462
-- Data for Name: sitio_arqueologico_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 8084 (class 0 OID 3373528)
-- Dependencies: 465
-- Data for Name: zoologico_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 8120 (class 0 OID 3376136)
-- Dependencies: 518
-- Data for Name: acequia_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 8023 (class 0 OID 2452635)
-- Dependencies: 370
-- Data for Name: acequia_l; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 8025 (class 0 OID 2452647)
-- Dependencies: 372
-- Data for Name: acueducto_canal_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 8122 (class 0 OID 3376170)
-- Dependencies: 520
-- Data for Name: acueducto_canal_l; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 8088 (class 0 OID 3373652)
-- Dependencies: 470
-- Data for Name: estanque_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 8027 (class 0 OID 2452659)
-- Dependencies: 374
-- Data for Name: lago_laguna_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 8090 (class 0 OID 3373692)
-- Dependencies: 473
-- Data for Name: presa_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 8124 (class 0 OID 3376264)
-- Dependencies: 526
-- Data for Name: presa_l; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 8029 (class 0 OID 2452671)
-- Dependencies: 376
-- Data for Name: rio_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 8031 (class 0 OID 2452683)
-- Dependencies: 378
-- Data for Name: rio_l; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 8126 (class 0 OID 3376309)
-- Dependencies: 529
-- Data for Name: zanja_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 8033 (class 0 OID 2452695)
-- Dependencies: 380
-- Data for Name: zanja_l; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 8092 (class 0 OID 3373735)
-- Dependencies: 476
-- Data for Name: malecon_a; Type: TABLE DATA; Schema: ho_puertos_muelles; Owner: postgres
--



--
-- TOC entry 8096 (class 0 OID 3373844)
-- Dependencies: 482
-- Data for Name: malecon_l; Type: TABLE DATA; Schema: ho_puertos_muelles; Owner: postgres
--



--
-- TOC entry 8094 (class 0 OID 3373782)
-- Dependencies: 479
-- Data for Name: muelle_a; Type: TABLE DATA; Schema: ho_puertos_muelles; Owner: postgres
--



--
-- TOC entry 8098 (class 0 OID 3373877)
-- Dependencies: 485
-- Data for Name: muelle_l; Type: TABLE DATA; Schema: ho_puertos_muelles; Owner: postgres
--



--
-- TOC entry 8035 (class 0 OID 2452707)
-- Dependencies: 382
-- Data for Name: puerto_a; Type: TABLE DATA; Schema: ho_puertos_muelles; Owner: postgres
--



--
-- TOC entry 8037 (class 0 OID 2452719)
-- Dependencies: 384
-- Data for Name: granja_acuatica_a; Type: TABLE DATA; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--



--
-- TOC entry 8039 (class 0 OID 2452731)
-- Dependencies: 386
-- Data for Name: isla_a; Type: TABLE DATA; Schema: ho_zonas_costeras; Owner: postgres
--



--
-- TOC entry 8041 (class 0 OID 2452743)
-- Dependencies: 388
-- Data for Name: orilla_l; Type: TABLE DATA; Schema: ho_zonas_costeras; Owner: postgres
--



--
-- TOC entry 8043 (class 0 OID 2452755)
-- Dependencies: 390
-- Data for Name: invernadero_a; Type: TABLE DATA; Schema: ii_agropecuaria; Owner: postgres
--



--
-- TOC entry 8128 (class 0 OID 3376343)
-- Dependencies: 532
-- Data for Name: invernadero_p; Type: TABLE DATA; Schema: ii_agropecuaria; Owner: postgres
--



--
-- TOC entry 8106 (class 0 OID 3375680)
-- Dependencies: 498
-- Data for Name: tuberia_l; Type: TABLE DATA; Schema: ii_estructura_asociada_industria; Owner: postgres
--



--
-- TOC entry 8102 (class 0 OID 3375515)
-- Dependencies: 492
-- Data for Name: campo_petroleo_gas_a; Type: TABLE DATA; Schema: ii_extraccion; Owner: postgres
--



--
-- TOC entry 8104 (class 0 OID 3375572)
-- Dependencies: 494
-- Data for Name: cantera_a; Type: TABLE DATA; Schema: ii_extraccion; Owner: postgres
--



--
-- TOC entry 8045 (class 0 OID 2452804)
-- Dependencies: 392
-- Data for Name: parqueadero_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 8047 (class 0 OID 2452816)
-- Dependencies: 394
-- Data for Name: paseo_peatonal_ciclovia_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 8130 (class 0 OID 3376404)
-- Dependencies: 535
-- Data for Name: paseo_peatonal_ciclovia_l; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 8049 (class 0 OID 2452828)
-- Dependencies: 396
-- Data for Name: tunel_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 8051 (class 0 OID 2452840)
-- Dependencies: 398
-- Data for Name: puente_a; Type: TABLE DATA; Schema: it_cruces_enlaces; Owner: postgres
--



--
-- TOC entry 8100 (class 0 OID 3374039)
-- Dependencies: 489
-- Data for Name: estacion_ferrocarril_a; Type: TABLE DATA; Schema: it_ferrocarriles; Owner: postgres
--



--
-- TOC entry 8132 (class 0 OID 3376438)
-- Dependencies: 538
-- Data for Name: ferrocarril_l; Type: TABLE DATA; Schema: it_ferrocarriles; Owner: postgres
--



--
-- TOC entry 8053 (class 0 OID 2452864)
-- Dependencies: 400
-- Data for Name: gasolinera_a; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 8055 (class 0 OID 2452876)
-- Dependencies: 402
-- Data for Name: intercambiador_vial_a; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 8057 (class 0 OID 2452888)
-- Dependencies: 404
-- Data for Name: rodera_l; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 8059 (class 0 OID 2452900)
-- Dependencies: 406
-- Data for Name: sendero_l; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 8061 (class 0 OID 2452912)
-- Dependencies: 408
-- Data for Name: via_ruta_a; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 8114 (class 0 OID 3376016)
-- Dependencies: 509
-- Data for Name: base_militar_a; Type: TABLE DATA; Schema: m_infraestructura_defensa_operaciones; Owner: postgres
--



--
-- TOC entry 8063 (class 0 OID 2452924)
-- Dependencies: 410
-- Data for Name: qgis_projects; Type: TABLE DATA; Schema: proyecto_qgis3; Owner: postgres
--

INSERT INTO proyecto_qgis3.qgis_projects (name, metadata, content) VALUES ('CARTOGRAFIA BASE CATASTRAL', '{"last_modified_time": "2022-12-14 22:08:02.434511", "last_modified_user": "postgres"}', '\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');


--
-- TOC entry 6660 (class 0 OID 16696)
-- Dependencies: 245
-- Data for Name: spatial_ref_sys; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- TOC entry 6663 (class 0 OID 17633)
-- Dependencies: 257
-- Data for Name: geocode_settings; Type: TABLE DATA; Schema: tiger; Owner: postgres
--



--
-- TOC entry 6664 (class 0 OID 17965)
-- Dependencies: 302
-- Data for Name: pagc_gaz; Type: TABLE DATA; Schema: tiger; Owner: postgres
--



--
-- TOC entry 6665 (class 0 OID 17975)
-- Dependencies: 304
-- Data for Name: pagc_lex; Type: TABLE DATA; Schema: tiger; Owner: postgres
--



--
-- TOC entry 6666 (class 0 OID 17985)
-- Dependencies: 306
-- Data for Name: pagc_rules; Type: TABLE DATA; Schema: tiger; Owner: postgres
--



--
-- TOC entry 6661 (class 0 OID 17423)
-- Dependencies: 250
-- Data for Name: topology; Type: TABLE DATA; Schema: topology; Owner: postgres
--



--
-- TOC entry 6662 (class 0 OID 17435)
-- Dependencies: 251
-- Data for Name: layer; Type: TABLE DATA; Schema: topology; Owner: postgres
--



--
-- TOC entry 8292 (class 0 OID 0)
-- Dependencies: 318
-- Name: aeropuerto_a_gid_seq; Type: SEQUENCE SET; Schema: a_aeropuerto_superficie; Owner: postgres
--

SELECT pg_catalog.setval('a_aeropuerto_superficie.aeropuerto_a_gid_seq', 7, true);


--
-- TOC entry 8293 (class 0 OID 0)
-- Dependencies: 323
-- Name: catalogo_objetos_gid_seq; Type: SEQUENCE SET; Schema: catalogo_objetos; Owner: postgres
--

SELECT pg_catalog.setval('catalogo_objetos.catalogo_objetos_gid_seq', 200, true);


--
-- TOC entry 8294 (class 0 OID 0)
-- Dependencies: 511
-- Name: zona_sin_informacion_a_gid_seq; Type: SEQUENCE SET; Schema: ct_miscelaneos; Owner: postgres
--

SELECT pg_catalog.setval('ct_miscelaneos.zona_sin_informacion_a_gid_seq', 1, false);


--
-- TOC entry 8295 (class 0 OID 0)
-- Dependencies: 506
-- Name: limite_administrativo_l_gid_seq; Type: SEQUENCE SET; Schema: d_limite_politico_administrativo; Owner: postgres
--

SELECT pg_catalog.setval('d_limite_politico_administrativo.limite_administrativo_l_gid_seq', 1, false);


--
-- TOC entry 8296 (class 0 OID 0)
-- Dependencies: 540
-- Name: zona_administrativa_a_gid_seq; Type: SEQUENCE SET; Schema: d_limite_politico_administrativo; Owner: postgres
--

SELECT pg_catalog.setval('d_limite_politico_administrativo.zona_administrativa_a_gid_seq', 1, false);


--
-- TOC entry 8297 (class 0 OID 0)
-- Dependencies: 349
-- Name: vertice_geodesico_p_gid_seq; Type: SEQUENCE SET; Schema: d_linderos_propiedad; Owner: postgres
--

SELECT pg_catalog.setval('d_linderos_propiedad.vertice_geodesico_p_gid_seq', 1, true);


--
-- TOC entry 8298 (class 0 OID 0)
-- Dependencies: 351
-- Name: cementerio_a_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.cementerio_a_gid_seq', 1, false);


--
-- TOC entry 8299 (class 0 OID 0)
-- Dependencies: 353
-- Name: cerca_l_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.cerca_l_gid_seq', 1, false);


--
-- TOC entry 8300 (class 0 OID 0)
-- Dependencies: 453
-- Name: choza_a_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.choza_a_gid_seq', 1, false);


--
-- TOC entry 8301 (class 0 OID 0)
-- Dependencies: 355
-- Name: escalinata_a_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.escalinata_a_gid_seq', 1, false);


--
-- TOC entry 8302 (class 0 OID 0)
-- Dependencies: 514
-- Name: muro_a_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.muro_a_gid_seq', 1, false);


--
-- TOC entry 8303 (class 0 OID 0)
-- Dependencies: 357
-- Name: muro_l_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.muro_l_gid_seq', 1, false);


--
-- TOC entry 8304 (class 0 OID 0)
-- Dependencies: 359
-- Name: plaza_publica_a_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.plaza_publica_a_gid_seq', 1, false);


--
-- TOC entry 8305 (class 0 OID 0)
-- Dependencies: 500
-- Name: estructura_no_construida_a_gid_seq; Type: SEQUENCE SET; Schema: gs_comercio; Owner: postgres
--

SELECT pg_catalog.setval('gs_comercio.estructura_no_construida_a_gid_seq', 1, false);


--
-- TOC entry 8306 (class 0 OID 0)
-- Dependencies: 502
-- Name: instalacion_a_gid_seq; Type: SEQUENCE SET; Schema: gs_comercio; Owner: postgres
--

SELECT pg_catalog.setval('gs_comercio.instalacion_a_gid_seq', 1, false);


--
-- TOC entry 8307 (class 0 OID 0)
-- Dependencies: 455
-- Name: edificio_a_gid_seq; Type: SEQUENCE SET; Schema: gs_construcciones; Owner: postgres
--

SELECT pg_catalog.setval('gs_construcciones.edificio_a_gid_seq', 1, false);


--
-- TOC entry 8308 (class 0 OID 0)
-- Dependencies: 361
-- Name: cancha_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.cancha_a_gid_seq', 1, false);


--
-- TOC entry 8309 (class 0 OID 0)
-- Dependencies: 363
-- Name: estadio_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.estadio_a_gid_seq', 1, false);


--
-- TOC entry 8310 (class 0 OID 0)
-- Dependencies: 365
-- Name: parque_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.parque_a_gid_seq', 1, false);


--
-- TOC entry 8311 (class 0 OID 0)
-- Dependencies: 466
-- Name: paseo_maritimo_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.paseo_maritimo_a_gid_seq', 1, false);


--
-- TOC entry 8312 (class 0 OID 0)
-- Dependencies: 367
-- Name: piscina_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.piscina_a_gid_seq', 1, false);


--
-- TOC entry 8313 (class 0 OID 0)
-- Dependencies: 369
-- Name: plaza_toros_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.plaza_toros_a_gid_seq', 1, false);


--
-- TOC entry 8314 (class 0 OID 0)
-- Dependencies: 458
-- Name: recinto_ferial_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.recinto_ferial_a_gid_seq', 1, false);


--
-- TOC entry 8315 (class 0 OID 0)
-- Dependencies: 461
-- Name: sitio_arqueologico_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.sitio_arqueologico_a_gid_seq', 1, false);


--
-- TOC entry 8316 (class 0 OID 0)
-- Dependencies: 464
-- Name: zoologico_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.zoologico_a_gid_seq', 1, false);


--
-- TOC entry 8317 (class 0 OID 0)
-- Dependencies: 517
-- Name: acequia_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.acequia_a_gid_seq', 1, false);


--
-- TOC entry 8318 (class 0 OID 0)
-- Dependencies: 371
-- Name: acequia_l_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.acequia_l_gid_seq', 1, false);


--
-- TOC entry 8319 (class 0 OID 0)
-- Dependencies: 373
-- Name: acueducto_canal_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.acueducto_canal_a_gid_seq', 1, false);


--
-- TOC entry 8320 (class 0 OID 0)
-- Dependencies: 519
-- Name: acueducto_canal_l_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.acueducto_canal_l_gid_seq', 1, false);


--
-- TOC entry 8321 (class 0 OID 0)
-- Dependencies: 469
-- Name: estanque_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.estanque_a_gid_seq', 1, false);


--
-- TOC entry 8322 (class 0 OID 0)
-- Dependencies: 375
-- Name: lago_laguna_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.lago_laguna_a_gid_seq', 1, false);


--
-- TOC entry 8323 (class 0 OID 0)
-- Dependencies: 472
-- Name: presa_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.presa_a_gid_seq', 1, false);


--
-- TOC entry 8324 (class 0 OID 0)
-- Dependencies: 525
-- Name: presa_l_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.presa_l_gid_seq', 1, false);


--
-- TOC entry 8325 (class 0 OID 0)
-- Dependencies: 377
-- Name: rio_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.rio_a_gid_seq', 1, false);


--
-- TOC entry 8326 (class 0 OID 0)
-- Dependencies: 379
-- Name: rio_l_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.rio_l_gid_seq', 1, false);


--
-- TOC entry 8327 (class 0 OID 0)
-- Dependencies: 528
-- Name: zanja_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.zanja_a_gid_seq', 1, false);


--
-- TOC entry 8328 (class 0 OID 0)
-- Dependencies: 381
-- Name: zanja_l_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.zanja_l_gid_seq', 1, false);


--
-- TOC entry 8329 (class 0 OID 0)
-- Dependencies: 475
-- Name: malecon_a_gid_seq; Type: SEQUENCE SET; Schema: ho_puertos_muelles; Owner: postgres
--

SELECT pg_catalog.setval('ho_puertos_muelles.malecon_a_gid_seq', 1, false);


--
-- TOC entry 8330 (class 0 OID 0)
-- Dependencies: 481
-- Name: malecon_l_gid_seq; Type: SEQUENCE SET; Schema: ho_puertos_muelles; Owner: postgres
--

SELECT pg_catalog.setval('ho_puertos_muelles.malecon_l_gid_seq', 1, false);


--
-- TOC entry 8331 (class 0 OID 0)
-- Dependencies: 478
-- Name: muelle_a_gid_seq; Type: SEQUENCE SET; Schema: ho_puertos_muelles; Owner: postgres
--

SELECT pg_catalog.setval('ho_puertos_muelles.muelle_a_gid_seq', 1, false);


--
-- TOC entry 8332 (class 0 OID 0)
-- Dependencies: 484
-- Name: muelle_l_gid_seq; Type: SEQUENCE SET; Schema: ho_puertos_muelles; Owner: postgres
--

SELECT pg_catalog.setval('ho_puertos_muelles.muelle_l_gid_seq', 1, false);


--
-- TOC entry 8333 (class 0 OID 0)
-- Dependencies: 383
-- Name: puerto_a_gid_seq; Type: SEQUENCE SET; Schema: ho_puertos_muelles; Owner: postgres
--

SELECT pg_catalog.setval('ho_puertos_muelles.puerto_a_gid_seq', 1, false);


--
-- TOC entry 8334 (class 0 OID 0)
-- Dependencies: 385
-- Name: granja_acuatica_a_gid_seq; Type: SEQUENCE SET; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

SELECT pg_catalog.setval('ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq', 1, false);


--
-- TOC entry 8335 (class 0 OID 0)
-- Dependencies: 387
-- Name: isla_a_gid_seq; Type: SEQUENCE SET; Schema: ho_zonas_costeras; Owner: postgres
--

SELECT pg_catalog.setval('ho_zonas_costeras.isla_a_gid_seq', 1, false);


--
-- TOC entry 8336 (class 0 OID 0)
-- Dependencies: 389
-- Name: orilla_l_gid_seq; Type: SEQUENCE SET; Schema: ho_zonas_costeras; Owner: postgres
--

SELECT pg_catalog.setval('ho_zonas_costeras.orilla_l_gid_seq', 1, false);


--
-- TOC entry 8337 (class 0 OID 0)
-- Dependencies: 391
-- Name: invernadero_a_gid_seq; Type: SEQUENCE SET; Schema: ii_agropecuaria; Owner: postgres
--

SELECT pg_catalog.setval('ii_agropecuaria.invernadero_a_gid_seq', 1, false);


--
-- TOC entry 8338 (class 0 OID 0)
-- Dependencies: 531
-- Name: invernadero_p_gid_seq; Type: SEQUENCE SET; Schema: ii_agropecuaria; Owner: postgres
--

SELECT pg_catalog.setval('ii_agropecuaria.invernadero_p_gid_seq', 1, false);


--
-- TOC entry 8339 (class 0 OID 0)
-- Dependencies: 497
-- Name: tuberia_l_gid_seq; Type: SEQUENCE SET; Schema: ii_estructura_asociada_industria; Owner: postgres
--

SELECT pg_catalog.setval('ii_estructura_asociada_industria.tuberia_l_gid_seq', 1, false);


--
-- TOC entry 8340 (class 0 OID 0)
-- Dependencies: 491
-- Name: campo_petroleo_gas_a_gid_seq; Type: SEQUENCE SET; Schema: ii_extraccion; Owner: postgres
--

SELECT pg_catalog.setval('ii_extraccion.campo_petroleo_gas_a_gid_seq', 1, false);


--
-- TOC entry 8341 (class 0 OID 0)
-- Dependencies: 493
-- Name: cantera_a_gid_seq; Type: SEQUENCE SET; Schema: ii_extraccion; Owner: postgres
--

SELECT pg_catalog.setval('ii_extraccion.cantera_a_gid_seq', 1, false);


--
-- TOC entry 8342 (class 0 OID 0)
-- Dependencies: 393
-- Name: parqueadero_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.parqueadero_a_gid_seq', 1, false);


--
-- TOC entry 8343 (class 0 OID 0)
-- Dependencies: 395
-- Name: paseo_peatonal_ciclovia_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq', 1, false);


--
-- TOC entry 8344 (class 0 OID 0)
-- Dependencies: 534
-- Name: paseo_peatonal_ciclovia_l_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.paseo_peatonal_ciclovia_l_gid_seq', 1, false);


--
-- TOC entry 8345 (class 0 OID 0)
-- Dependencies: 397
-- Name: tunel_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.tunel_a_gid_seq', 1, false);


--
-- TOC entry 8346 (class 0 OID 0)
-- Dependencies: 399
-- Name: puente_a_gid_seq; Type: SEQUENCE SET; Schema: it_cruces_enlaces; Owner: postgres
--

SELECT pg_catalog.setval('it_cruces_enlaces.puente_a_gid_seq', 1, false);


--
-- TOC entry 8347 (class 0 OID 0)
-- Dependencies: 488
-- Name: estacion_ferrocarril_a_gid_seq; Type: SEQUENCE SET; Schema: it_ferrocarriles; Owner: postgres
--

SELECT pg_catalog.setval('it_ferrocarriles.estacion_ferrocarril_a_gid_seq', 1, false);


--
-- TOC entry 8348 (class 0 OID 0)
-- Dependencies: 537
-- Name: ferrocarril_l_gid_seq; Type: SEQUENCE SET; Schema: it_ferrocarriles; Owner: postgres
--

SELECT pg_catalog.setval('it_ferrocarriles.ferrocarril_l_gid_seq', 1, false);


--
-- TOC entry 8349 (class 0 OID 0)
-- Dependencies: 401
-- Name: gasolinera_a_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.gasolinera_a_gid_seq', 1, false);


--
-- TOC entry 8350 (class 0 OID 0)
-- Dependencies: 403
-- Name: intercambiador_vial_a_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.intercambiador_vial_a_gid_seq', 1, false);


--
-- TOC entry 8351 (class 0 OID 0)
-- Dependencies: 405
-- Name: rodera_l_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.rodera_l_gid_seq', 14157, true);


--
-- TOC entry 8352 (class 0 OID 0)
-- Dependencies: 407
-- Name: sendero_l_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.sendero_l_gid_seq', 1, false);


--
-- TOC entry 8353 (class 0 OID 0)
-- Dependencies: 409
-- Name: via_ruta_a_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.via_ruta_a_gid_seq', 105, true);


--
-- TOC entry 8354 (class 0 OID 0)
-- Dependencies: 508
-- Name: base_militar_a_gid_seq; Type: SEQUENCE SET; Schema: m_infraestructura_defensa_operaciones; Owner: postgres
--

SELECT pg_catalog.setval('m_infraestructura_defensa_operaciones.base_militar_a_gid_seq', 1, false);


--
-- TOC entry 7290 (class 2606 OID 2453145)
-- Name: aeropuerto_a aeropuerto_a_pkey; Type: CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7293 (class 2606 OID 2453147)
-- Name: acc acc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.acc
    ADD CONSTRAINT acc_pkey PRIMARY KEY (acc);


--
-- TOC entry 7446 (class 2606 OID 3372854)
-- Name: agg agg_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.agg
    ADD CONSTRAINT agg_pkey PRIMARY KEY (agg);


--
-- TOC entry 7295 (class 2606 OID 2453149)
-- Name: atc atc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.atc
    ADD CONSTRAINT atc_pkey PRIMARY KEY (atc);


--
-- TOC entry 7448 (class 2606 OID 3372861)
-- Name: bcp bcp_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.bcp
    ADD CONSTRAINT bcp_pkey PRIMARY KEY (bcp);


--
-- TOC entry 7297 (class 2606 OID 2453151)
-- Name: bsc bsc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.bsc
    ADD CONSTRAINT bsc_pkey PRIMARY KEY (bsc);


--
-- TOC entry 7299 (class 2606 OID 2453153)
-- Name: catalogo_objetos catalogo_objetos_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.catalogo_objetos
    ADD CONSTRAINT catalogo_objetos_pkey PRIMARY KEY (fcode);


--
-- TOC entry 7450 (class 2606 OID 3372867)
-- Name: cpa cpa_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.cpa
    ADD CONSTRAINT cpa_pkey PRIMARY KEY (cpa);


--
-- TOC entry 7301 (class 2606 OID 2453155)
-- Name: dit dit_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.dit
    ADD CONSTRAINT dit_pkey PRIMARY KEY (dit);


--
-- TOC entry 7303 (class 2606 OID 2453157)
-- Name: ela ela_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.ela
    ADD CONSTRAINT ela_pkey PRIMARY KEY (ela);


--
-- TOC entry 7305 (class 2606 OID 2453159)
-- Name: fco fco_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.fco
    ADD CONSTRAINT fco_pkey PRIMARY KEY (fco);


--
-- TOC entry 7452 (class 2606 OID 3372876)
-- Name: ffn ffn_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.ffn
    ADD CONSTRAINT ffn_pkey PRIMARY KEY (ffn);


--
-- TOC entry 7307 (class 2606 OID 2453161)
-- Name: fti fti_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.fti
    ADD CONSTRAINT fti_pkey PRIMARY KEY (fti);


--
-- TOC entry 7309 (class 2606 OID 2453163)
-- Name: fuc fuc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.fuc
    ADD CONSTRAINT fuc_pkey PRIMARY KEY (fuc);


--
-- TOC entry 7311 (class 2606 OID 2453165)
-- Name: hct hct_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.hct
    ADD CONSTRAINT hct_pkey PRIMARY KEY (hct);


--
-- TOC entry 7313 (class 2606 OID 2453167)
-- Name: hyp hyp_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.hyp
    ADD CONSTRAINT hyp_pkey PRIMARY KEY (hyp);


--
-- TOC entry 7315 (class 2606 OID 2453169)
-- Name: kos kos_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.kos
    ADD CONSTRAINT kos_pkey PRIMARY KEY (kos);


--
-- TOC entry 7317 (class 2606 OID 2453171)
-- Name: loc loc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.loc
    ADD CONSTRAINT loc_pkey PRIMARY KEY (loc);


--
-- TOC entry 7454 (class 2606 OID 3372886)
-- Name: mcc mcc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.mcc
    ADD CONSTRAINT mcc_pkey PRIMARY KEY (mcc);


--
-- TOC entry 7319 (class 2606 OID 2453173)
-- Name: mes mes_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.mes
    ADD CONSTRAINT mes_pkey PRIMARY KEY (mes);


--
-- TOC entry 7456 (class 2606 OID 3372896)
-- Name: ppo ppo_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.ppo
    ADD CONSTRAINT ppo_pkey PRIMARY KEY (ppo);


--
-- TOC entry 7444 (class 2606 OID 3372835)
-- Name: psf psf_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.psf
    ADD CONSTRAINT psf_pkey PRIMARY KEY (psf);


--
-- TOC entry 7458 (class 2606 OID 3372902)
-- Name: pwc pwc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.pwc
    ADD CONSTRAINT pwc_pkey PRIMARY KEY (pwc);


--
-- TOC entry 7321 (class 2606 OID 2453175)
-- Name: rdt rdt_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rdt
    ADD CONSTRAINT rdt_pkey PRIMARY KEY (rdt);


--
-- TOC entry 7323 (class 2606 OID 2453177)
-- Name: rel rel_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rel
    ADD CONSTRAINT rel_pkey PRIMARY KEY (rel);


--
-- TOC entry 7460 (class 2606 OID 3372908)
-- Name: res res_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.res
    ADD CONSTRAINT res_pkey PRIMARY KEY (res);


--
-- TOC entry 7325 (class 2606 OID 2453179)
-- Name: rgc rgc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rgc
    ADD CONSTRAINT rgc_pkey PRIMARY KEY (rgc);


--
-- TOC entry 7327 (class 2606 OID 2453181)
-- Name: rra rra_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rra
    ADD CONSTRAINT rra_pkey PRIMARY KEY (rra);


--
-- TOC entry 7329 (class 2606 OID 2453183)
-- Name: rrc rrc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rrc
    ADD CONSTRAINT rrc_pkey PRIMARY KEY (rrc);


--
-- TOC entry 7331 (class 2606 OID 2453185)
-- Name: rst rst_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rst
    ADD CONSTRAINT rst_pkey PRIMARY KEY (rst);


--
-- TOC entry 7462 (class 2606 OID 3372925)
-- Name: scc scc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.scc
    ADD CONSTRAINT scc_pkey PRIMARY KEY (scc);


--
-- TOC entry 7333 (class 2606 OID 2453187)
-- Name: slt slt_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.slt
    ADD CONSTRAINT slt_pkey PRIMARY KEY (slt);


--
-- TOC entry 7335 (class 2606 OID 2453189)
-- Name: smc smc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.smc
    ADD CONSTRAINT smc_pkey PRIMARY KEY (smc);


--
-- TOC entry 7464 (class 2606 OID 3372931)
-- Name: tfc tfc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.tfc
    ADD CONSTRAINT tfc_pkey PRIMARY KEY (tfc);


--
-- TOC entry 7337 (class 2606 OID 2453191)
-- Name: tra tra_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.tra
    ADD CONSTRAINT tra_pkey PRIMARY KEY (tra);


--
-- TOC entry 7339 (class 2606 OID 2453193)
-- Name: tuc tuc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.tuc
    ADD CONSTRAINT tuc_pkey PRIMARY KEY (tuc);


--
-- TOC entry 7341 (class 2606 OID 2453195)
-- Name: typ typ_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.typ
    ADD CONSTRAINT typ_pkey PRIMARY KEY (typ);


--
-- TOC entry 7343 (class 2606 OID 2453197)
-- Name: uuc uuc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.uuc
    ADD CONSTRAINT uuc_pkey PRIMARY KEY (uuc);


--
-- TOC entry 7345 (class 2606 OID 2453199)
-- Name: wtc wtc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.wtc
    ADD CONSTRAINT wtc_pkey PRIMARY KEY (wtc);


--
-- TOC entry 7347 (class 2606 OID 2453201)
-- Name: wti wti_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.wti
    ADD CONSTRAINT wti_pkey PRIMARY KEY (wti);


--
-- TOC entry 7525 (class 2606 OID 3376073)
-- Name: zona_sin_informacion_a zona_sin_informacion_a_pkey; Type: CONSTRAINT; Schema: ct_miscelaneos; Owner: postgres
--

ALTER TABLE ONLY ct_miscelaneos.zona_sin_informacion_a
    ADD CONSTRAINT zona_sin_informacion_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7519 (class 2606 OID 3375822)
-- Name: limite_administrativo_l limite_administrativo_l_pkey; Type: CONSTRAINT; Schema: d_limite_politico_administrativo; Owner: postgres
--

ALTER TABLE ONLY d_limite_politico_administrativo.limite_administrativo_l
    ADD CONSTRAINT limite_administrativo_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7552 (class 2606 OID 3484368)
-- Name: zona_administrativa_a zona_administrativa_a_pkey; Type: CONSTRAINT; Schema: d_limite_politico_administrativo; Owner: postgres
--

ALTER TABLE ONLY d_limite_politico_administrativo.zona_administrativa_a
    ADD CONSTRAINT zona_administrativa_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7349 (class 2606 OID 2453203)
-- Name: punto_control_p punto_control_p_pkey; Type: CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_pkey PRIMARY KEY (gid);


--
-- TOC entry 7352 (class 2606 OID 2453205)
-- Name: cementerio_a cementerio_a_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a
    ADD CONSTRAINT cementerio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7355 (class 2606 OID 2453207)
-- Name: cerca_l cerca_l_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7466 (class 2606 OID 3373074)
-- Name: choza_a choza_a_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.choza_a
    ADD CONSTRAINT choza_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7358 (class 2606 OID 2453209)
-- Name: escalinata_a escalinata_a_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a
    ADD CONSTRAINT escalinata_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7528 (class 2606 OID 3376108)
-- Name: muro_a muro_a_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_a
    ADD CONSTRAINT muro_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7361 (class 2606 OID 2453211)
-- Name: muro_l muro_l_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l
    ADD CONSTRAINT muro_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7364 (class 2606 OID 2453213)
-- Name: plaza_publica_a plaza_publica_a_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a
    ADD CONSTRAINT plaza_publica_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7513 (class 2606 OID 3375744)
-- Name: estructura_no_construida_a estructura_no_construida_a_pkey; Type: CONSTRAINT; Schema: gs_comercio; Owner: postgres
--

ALTER TABLE ONLY gs_comercio.estructura_no_construida_a
    ADD CONSTRAINT estructura_no_construida_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7516 (class 2606 OID 3375775)
-- Name: instalacion_a instalacion_a_pkey; Type: CONSTRAINT; Schema: gs_comercio; Owner: postgres
--

ALTER TABLE ONLY gs_comercio.instalacion_a
    ADD CONSTRAINT instalacion_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7469 (class 2606 OID 3373143)
-- Name: edificio_a edificio_a_pkey; Type: CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7367 (class 2606 OID 2453217)
-- Name: cancha_a cancha_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7370 (class 2606 OID 2453219)
-- Name: estadio_a estadio_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a
    ADD CONSTRAINT estadio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7373 (class 2606 OID 2453221)
-- Name: parque_a parque_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a
    ADD CONSTRAINT parque_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7480 (class 2606 OID 3373610)
-- Name: paseo_maritimo_a paseo_maritimo_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.paseo_maritimo_a
    ADD CONSTRAINT paseo_maritimo_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7376 (class 2606 OID 2453223)
-- Name: piscina_a piscina_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.piscina_a
    ADD CONSTRAINT piscina_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7379 (class 2606 OID 2453225)
-- Name: plaza_toros_a plaza_toros_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.plaza_toros_a
    ADD CONSTRAINT plaza_toros_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7471 (class 2606 OID 3373215)
-- Name: recinto_ferial_a recinto_ferial_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.recinto_ferial_a
    ADD CONSTRAINT recinto_ferial_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7474 (class 2606 OID 3373254)
-- Name: sitio_arqueologico_a sitio_arqueologico_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.sitio_arqueologico_a
    ADD CONSTRAINT sitio_arqueologico_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7477 (class 2606 OID 3373541)
-- Name: zoologico_a zoologico_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.zoologico_a
    ADD CONSTRAINT zoologico_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7531 (class 2606 OID 3376149)
-- Name: acequia_a acequia_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_a
    ADD CONSTRAINT acequia_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7382 (class 2606 OID 2453227)
-- Name: acequia_l acequia_l_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7385 (class 2606 OID 2453229)
-- Name: acueducto_canal_a acueducto_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7534 (class 2606 OID 3376183)
-- Name: acueducto_canal_l acueducto_canal_l_acueducto_l_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_l
    ADD CONSTRAINT acueducto_canal_l_acueducto_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7483 (class 2606 OID 3373665)
-- Name: estanque_a estanque_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.estanque_a
    ADD CONSTRAINT estanque_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7388 (class 2606 OID 2453231)
-- Name: lago_laguna_a lago_laguna_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a
    ADD CONSTRAINT lago_laguna_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7486 (class 2606 OID 3373705)
-- Name: presa_a presa_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.presa_a
    ADD CONSTRAINT presa_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7537 (class 2606 OID 3376277)
-- Name: presa_l presa_l_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.presa_l
    ADD CONSTRAINT presa_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7391 (class 2606 OID 2453233)
-- Name: rio_a rio_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7394 (class 2606 OID 2453235)
-- Name: rio_l rio_l_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7540 (class 2606 OID 3376322)
-- Name: zanja_a zanja_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_a
    ADD CONSTRAINT zanja_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7398 (class 2606 OID 2453237)
-- Name: zanja_l zanja_l_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l
    ADD CONSTRAINT zanja_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7489 (class 2606 OID 3373748)
-- Name: malecon_a malecon_a_pkey; Type: CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.malecon_a
    ADD CONSTRAINT malecon_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7495 (class 2606 OID 3373857)
-- Name: malecon_l malecon_l_pkey; Type: CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.malecon_l
    ADD CONSTRAINT malecon_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7492 (class 2606 OID 3373795)
-- Name: muelle_a muelle_a_pkey; Type: CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.muelle_a
    ADD CONSTRAINT muelle_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7498 (class 2606 OID 3373890)
-- Name: muelle_l muelle_l_pkey; Type: CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.muelle_l
    ADD CONSTRAINT muelle_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7400 (class 2606 OID 2453239)
-- Name: puerto_a puerto_a_pkey; Type: CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.puerto_a
    ADD CONSTRAINT puerto_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7403 (class 2606 OID 2453241)
-- Name: granja_acuatica_a granja_acuatica_a_pkey; Type: CONSTRAINT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER TABLE ONLY ho_regulacion_zonas_restringidas.granja_acuatica_a
    ADD CONSTRAINT granja_acuatica_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7406 (class 2606 OID 2453243)
-- Name: isla_a isla_a_pkey; Type: CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.isla_a
    ADD CONSTRAINT isla_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7409 (class 2606 OID 2453245)
-- Name: orilla_l orilla_l_pkey; Type: CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7412 (class 2606 OID 2453247)
-- Name: invernadero_a hacienda_a_pkey; Type: CONSTRAINT; Schema: ii_agropecuaria; Owner: postgres
--

ALTER TABLE ONLY ii_agropecuaria.invernadero_a
    ADD CONSTRAINT hacienda_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7543 (class 2606 OID 3376356)
-- Name: invernadero_p invernadero_p_hacienda_a_pkey; Type: CONSTRAINT; Schema: ii_agropecuaria; Owner: postgres
--

ALTER TABLE ONLY ii_agropecuaria.invernadero_p
    ADD CONSTRAINT invernadero_p_hacienda_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7510 (class 2606 OID 3375693)
-- Name: tuberia_l tuberia_l_pkey; Type: CONSTRAINT; Schema: ii_estructura_asociada_industria; Owner: postgres
--

ALTER TABLE ONLY ii_estructura_asociada_industria.tuberia_l
    ADD CONSTRAINT tuberia_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7504 (class 2606 OID 3375528)
-- Name: campo_petroleo_gas_a campo_petroleo_gas_a_pkey; Type: CONSTRAINT; Schema: ii_extraccion; Owner: postgres
--

ALTER TABLE ONLY ii_extraccion.campo_petroleo_gas_a
    ADD CONSTRAINT campo_petroleo_gas_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7507 (class 2606 OID 3375585)
-- Name: cantera_a cantera_a_pkey; Type: CONSTRAINT; Schema: ii_extraccion; Owner: postgres
--

ALTER TABLE ONLY ii_extraccion.cantera_a
    ADD CONSTRAINT cantera_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7415 (class 2606 OID 2453255)
-- Name: parqueadero_a parqueadero_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a
    ADD CONSTRAINT parqueadero_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7418 (class 2606 OID 2453257)
-- Name: paseo_peatonal_ciclovia_a paseo_peatonal_ciclovia_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a
    ADD CONSTRAINT paseo_peatonal_ciclovia_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7546 (class 2606 OID 3376417)
-- Name: paseo_peatonal_ciclovia_l paseo_peatonal_ciclovia_l_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_l
    ADD CONSTRAINT paseo_peatonal_ciclovia_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7421 (class 2606 OID 2453259)
-- Name: tunel_a tunel_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7424 (class 2606 OID 2453261)
-- Name: puente_a puente_a_pkey; Type: CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7501 (class 2606 OID 3374052)
-- Name: estacion_ferrocarril_a estacion_ferrocarril_a_pkey; Type: CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.estacion_ferrocarril_a
    ADD CONSTRAINT estacion_ferrocarril_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7549 (class 2606 OID 3376451)
-- Name: ferrocarril_l ferrocarril_l_pkey; Type: CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_l
    ADD CONSTRAINT ferrocarril_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7427 (class 2606 OID 2453265)
-- Name: gasolinera_a gasolinera_a_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.gasolinera_a
    ADD CONSTRAINT gasolinera_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7430 (class 2606 OID 2453267)
-- Name: intercambiador_vial_a intercambiador_vial_a_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7433 (class 2606 OID 2453269)
-- Name: rodera_l rodera_l_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7436 (class 2606 OID 2453271)
-- Name: sendero_l sendero_l_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l
    ADD CONSTRAINT sendero_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7440 (class 2606 OID 2453273)
-- Name: via_ruta_a via_ruta_a_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7522 (class 2606 OID 3376029)
-- Name: base_militar_a base_militar_a_pkey; Type: CONSTRAINT; Schema: m_infraestructura_defensa_operaciones; Owner: postgres
--

ALTER TABLE ONLY m_infraestructura_defensa_operaciones.base_militar_a
    ADD CONSTRAINT base_militar_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7442 (class 2606 OID 2453275)
-- Name: qgis_projects qgis_projects_pkey; Type: CONSTRAINT; Schema: proyecto_qgis3; Owner: postgres
--

ALTER TABLE ONLY proyecto_qgis3.qgis_projects
    ADD CONSTRAINT qgis_projects_pkey PRIMARY KEY (name);


--
-- TOC entry 7291 (class 1259 OID 2453276)
-- Name: sidx_aeropuerto_a; Type: INDEX; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE INDEX sidx_aeropuerto_a ON a_aeropuerto_superficie.aeropuerto_a USING gist (the_geom);

ALTER TABLE a_aeropuerto_superficie.aeropuerto_a CLUSTER ON sidx_aeropuerto_a;


--
-- TOC entry 7526 (class 1259 OID 3376079)
-- Name: zona_sin_informacion_a_sidx_zona_sin_informacion_a; Type: INDEX; Schema: ct_miscelaneos; Owner: postgres
--

CREATE INDEX zona_sin_informacion_a_sidx_zona_sin_informacion_a ON ct_miscelaneos.zona_sin_informacion_a USING gist (the_geom);


--
-- TOC entry 7520 (class 1259 OID 3375828)
-- Name: limite_administrativo_l_sidx_limite_administrativo_l; Type: INDEX; Schema: d_limite_politico_administrativo; Owner: postgres
--

CREATE INDEX limite_administrativo_l_sidx_limite_administrativo_l ON d_limite_politico_administrativo.limite_administrativo_l USING gist (the_geom);


--
-- TOC entry 7553 (class 1259 OID 3484374)
-- Name: zona_administrativa_a_sidx_zona_administrativa_a; Type: INDEX; Schema: d_limite_politico_administrativo; Owner: postgres
--

CREATE INDEX zona_administrativa_a_sidx_zona_administrativa_a ON d_limite_politico_administrativo.zona_administrativa_a USING gist (the_geom);


--
-- TOC entry 7350 (class 1259 OID 2453277)
-- Name: sidx_punto_control_p; Type: INDEX; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE INDEX sidx_punto_control_p ON d_linderos_propiedad.punto_control_p USING gist (the_geom);


--
-- TOC entry 7467 (class 1259 OID 3373085)
-- Name: choza_a_sidx_choza_a; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX choza_a_sidx_choza_a ON gs_asociado_poblados.choza_a USING gist (the_geom);


--
-- TOC entry 7529 (class 1259 OID 3376119)
-- Name: muro_a_sidx_muro_a; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX muro_a_sidx_muro_a ON gs_asociado_poblados.muro_a USING gist (the_geom);


--
-- TOC entry 7353 (class 1259 OID 2453278)
-- Name: sidx_cementerio_a; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_cementerio_a ON gs_asociado_poblados.cementerio_a USING gist (the_geom);


--
-- TOC entry 7356 (class 1259 OID 2453279)
-- Name: sidx_cerca_l; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_cerca_l ON gs_asociado_poblados.cerca_l USING gist (the_geom);


--
-- TOC entry 7359 (class 1259 OID 2453280)
-- Name: sidx_escalinata_a; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_escalinata_a ON gs_asociado_poblados.escalinata_a USING gist (the_geom);


--
-- TOC entry 7362 (class 1259 OID 2453281)
-- Name: sidx_muro_l; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_muro_l ON gs_asociado_poblados.muro_l USING gist (the_geom);


--
-- TOC entry 7365 (class 1259 OID 2453282)
-- Name: sidx_plaza_publica_a; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_plaza_publica_a ON gs_asociado_poblados.plaza_publica_a USING gist (the_geom);


--
-- TOC entry 7514 (class 1259 OID 3375755)
-- Name: estructura_no_construida_a_sidx_estructura_no_construida_a; Type: INDEX; Schema: gs_comercio; Owner: postgres
--

CREATE INDEX estructura_no_construida_a_sidx_estructura_no_construida_a ON gs_comercio.estructura_no_construida_a USING gist (the_geom);


--
-- TOC entry 7517 (class 1259 OID 3375786)
-- Name: instalacion_a_sidx_instalacion_a; Type: INDEX; Schema: gs_comercio; Owner: postgres
--

CREATE INDEX instalacion_a_sidx_instalacion_a ON gs_comercio.instalacion_a USING gist (the_geom);


--
-- TOC entry 7481 (class 1259 OID 3373621)
-- Name: paseo_maritimo_a_sidx_estadio_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX paseo_maritimo_a_sidx_estadio_a ON gs_recreacion.paseo_maritimo_a USING gist (the_geom);


--
-- TOC entry 7472 (class 1259 OID 3373221)
-- Name: recinto_ferial_a_sidx_recinto_ferial_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX recinto_ferial_a_sidx_recinto_ferial_a ON gs_recreacion.recinto_ferial_a USING gist (the_geom);


--
-- TOC entry 7368 (class 1259 OID 2453284)
-- Name: sidx_cancha_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_cancha_a ON gs_recreacion.cancha_a USING gist (the_geom);


--
-- TOC entry 7371 (class 1259 OID 2453285)
-- Name: sidx_estadio_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_estadio_a ON gs_recreacion.estadio_a USING gist (the_geom);


--
-- TOC entry 7374 (class 1259 OID 2453286)
-- Name: sidx_parque_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_parque_a ON gs_recreacion.parque_a USING gist (the_geom);


--
-- TOC entry 7377 (class 1259 OID 2453287)
-- Name: sidx_piscina_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_piscina_a ON gs_recreacion.piscina_a USING gist (the_geom);


--
-- TOC entry 7380 (class 1259 OID 2453288)
-- Name: sidx_plaza_toros_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_plaza_toros_a ON gs_recreacion.plaza_toros_a USING gist (the_geom);


--
-- TOC entry 7475 (class 1259 OID 3373260)
-- Name: sitio_arqueologico_a_sidx_sitio_arqueologico_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sitio_arqueologico_a_sidx_sitio_arqueologico_a ON gs_recreacion.sitio_arqueologico_a USING gist (the_geom);


--
-- TOC entry 7478 (class 1259 OID 3373547)
-- Name: zoologico_a_sidx_sitio_arqueologico_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX zoologico_a_sidx_sitio_arqueologico_a ON gs_recreacion.zoologico_a USING gist (the_geom);


--
-- TOC entry 7532 (class 1259 OID 3376165)
-- Name: acequia_a_sidx_acequia_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX acequia_a_sidx_acequia_a ON ho_aguas_interiores.acequia_a USING gist (the_geom);


--
-- TOC entry 7535 (class 1259 OID 3376199)
-- Name: acueducto_canal_l_sidx_acueducto_l; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX acueducto_canal_l_sidx_acueducto_l ON ho_aguas_interiores.acueducto_canal_l USING gist (the_geom);


--
-- TOC entry 7484 (class 1259 OID 3373671)
-- Name: estanque_a_sidx_lago_laguna_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX estanque_a_sidx_lago_laguna_a ON ho_aguas_interiores.estanque_a USING gist (the_geom);


--
-- TOC entry 7487 (class 1259 OID 3373721)
-- Name: presa_a_sidx_presa_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX presa_a_sidx_presa_a ON ho_aguas_interiores.presa_a USING gist (the_geom);


--
-- TOC entry 7538 (class 1259 OID 3376293)
-- Name: presa_l_sidx_presa_l; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX presa_l_sidx_presa_l ON ho_aguas_interiores.presa_l USING gist (the_geom);


--
-- TOC entry 7383 (class 1259 OID 2453289)
-- Name: sidx_acequia_l; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_acequia_l ON ho_aguas_interiores.acequia_l USING gist (the_geom);


--
-- TOC entry 7386 (class 1259 OID 2453290)
-- Name: sidx_acueducto_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_acueducto_a ON ho_aguas_interiores.acueducto_canal_a USING gist (the_geom);


--
-- TOC entry 7389 (class 1259 OID 2453291)
-- Name: sidx_lago_laguna_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_lago_laguna_a ON ho_aguas_interiores.lago_laguna_a USING gist (the_geom);


--
-- TOC entry 7392 (class 1259 OID 2453292)
-- Name: sidx_rio_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_rio_a ON ho_aguas_interiores.rio_a USING gist (the_geom);


--
-- TOC entry 7395 (class 1259 OID 2453293)
-- Name: sidx_rio_l; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_rio_l ON ho_aguas_interiores.rio_l USING gist (the_geom);

ALTER TABLE ho_aguas_interiores.rio_l CLUSTER ON sidx_rio_l;


--
-- TOC entry 7396 (class 1259 OID 2453294)
-- Name: sidx_zanja_l; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_zanja_l ON ho_aguas_interiores.zanja_l USING gist (the_geom);


--
-- TOC entry 7541 (class 1259 OID 3376333)
-- Name: zanja_a_sidx_zanja_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX zanja_a_sidx_zanja_a ON ho_aguas_interiores.zanja_a USING gist (the_geom);


--
-- TOC entry 7490 (class 1259 OID 3373759)
-- Name: malecon_a_sidx_parqueadero_a; Type: INDEX; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE INDEX malecon_a_sidx_parqueadero_a ON ho_puertos_muelles.malecon_a USING gist (the_geom);


--
-- TOC entry 7496 (class 1259 OID 3373868)
-- Name: malecon_l_sidx_parqueadero_a; Type: INDEX; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE INDEX malecon_l_sidx_parqueadero_a ON ho_puertos_muelles.malecon_l USING gist (the_geom);


--
-- TOC entry 7493 (class 1259 OID 3373816)
-- Name: muelle_a_sidx_ferrocarril_a; Type: INDEX; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE INDEX muelle_a_sidx_ferrocarril_a ON ho_puertos_muelles.muelle_a USING gist (the_geom);


--
-- TOC entry 7499 (class 1259 OID 3373911)
-- Name: muelle_l_sidx_ferrocarril_a; Type: INDEX; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE INDEX muelle_l_sidx_ferrocarril_a ON ho_puertos_muelles.muelle_l USING gist (the_geom);


--
-- TOC entry 7401 (class 1259 OID 2453295)
-- Name: sidx_puerto_a; Type: INDEX; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE INDEX sidx_puerto_a ON ho_puertos_muelles.puerto_a USING gist (the_geom);


--
-- TOC entry 7404 (class 1259 OID 2453296)
-- Name: sidx_granja_acuatica_a; Type: INDEX; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE INDEX sidx_granja_acuatica_a ON ho_regulacion_zonas_restringidas.granja_acuatica_a USING gist (the_geom);


--
-- TOC entry 7407 (class 1259 OID 2453297)
-- Name: sidx_isla_a; Type: INDEX; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE INDEX sidx_isla_a ON ho_zonas_costeras.isla_a USING gist (the_geom);


--
-- TOC entry 7410 (class 1259 OID 2453298)
-- Name: sidx_orilla_l; Type: INDEX; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE INDEX sidx_orilla_l ON ho_zonas_costeras.orilla_l USING gist (the_geom);


--
-- TOC entry 7544 (class 1259 OID 3376362)
-- Name: invernadero_p_sidx_hacienda_a; Type: INDEX; Schema: ii_agropecuaria; Owner: postgres
--

CREATE INDEX invernadero_p_sidx_hacienda_a ON ii_agropecuaria.invernadero_p USING gist (the_geom);


--
-- TOC entry 7413 (class 1259 OID 2453299)
-- Name: sidx_hacienda_a; Type: INDEX; Schema: ii_agropecuaria; Owner: postgres
--

CREATE INDEX sidx_hacienda_a ON ii_agropecuaria.invernadero_a USING gist (the_geom);


--
-- TOC entry 7511 (class 1259 OID 3375709)
-- Name: tuberia_l_sidx_tuberia_l; Type: INDEX; Schema: ii_estructura_asociada_industria; Owner: postgres
--

CREATE INDEX tuberia_l_sidx_tuberia_l ON ii_estructura_asociada_industria.tuberia_l USING gist (the_geom);


--
-- TOC entry 7505 (class 1259 OID 3375534)
-- Name: campo_petroleo_gas_a_sidx_campo_petroleo_gas_a; Type: INDEX; Schema: ii_extraccion; Owner: postgres
--

CREATE INDEX campo_petroleo_gas_a_sidx_campo_petroleo_gas_a ON ii_extraccion.campo_petroleo_gas_a USING gist (the_geom);


--
-- TOC entry 7508 (class 1259 OID 3375601)
-- Name: cantera_a_sidx_cantera_a; Type: INDEX; Schema: ii_extraccion; Owner: postgres
--

CREATE INDEX cantera_a_sidx_cantera_a ON ii_extraccion.cantera_a USING gist (the_geom);


--
-- TOC entry 7547 (class 1259 OID 3376428)
-- Name: paseo_peatonal_ciclovia_l_sidx_paseo_peatonal_ciclovia_l; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX paseo_peatonal_ciclovia_l_sidx_paseo_peatonal_ciclovia_l ON it_asociado_transportacion.paseo_peatonal_ciclovia_l USING gist (the_geom);


--
-- TOC entry 7416 (class 1259 OID 2453303)
-- Name: sidx_parqueadero_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX sidx_parqueadero_a ON it_asociado_transportacion.parqueadero_a USING gist (the_geom);


--
-- TOC entry 7419 (class 1259 OID 2453304)
-- Name: sidx_paseo_peatonal_ciclovia_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX sidx_paseo_peatonal_ciclovia_a ON it_asociado_transportacion.paseo_peatonal_ciclovia_a USING gist (the_geom);


--
-- TOC entry 7422 (class 1259 OID 2453305)
-- Name: tunel_a_sidx_tunel_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX tunel_a_sidx_tunel_a ON it_asociado_transportacion.tunel_a USING gist (the_geom);


--
-- TOC entry 7425 (class 1259 OID 2453306)
-- Name: sidx_puente_a; Type: INDEX; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE INDEX sidx_puente_a ON it_cruces_enlaces.puente_a USING gist (the_geom);


--
-- TOC entry 7502 (class 1259 OID 3374058)
-- Name: estacion_ferrocarril_a_sidx_ferrocarril_a; Type: INDEX; Schema: it_ferrocarriles; Owner: postgres
--

CREATE INDEX estacion_ferrocarril_a_sidx_ferrocarril_a ON it_ferrocarriles.estacion_ferrocarril_a USING gist (the_geom);


--
-- TOC entry 7550 (class 1259 OID 3376482)
-- Name: ferrocarril_l_sidx_ferrocarril_l; Type: INDEX; Schema: it_ferrocarriles; Owner: postgres
--

CREATE INDEX ferrocarril_l_sidx_ferrocarril_l ON it_ferrocarriles.ferrocarril_l USING gist (the_geom);


--
-- TOC entry 7428 (class 1259 OID 2453308)
-- Name: sidx_gasolinera_a; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_gasolinera_a ON it_transporte_terrestre.gasolinera_a USING gist (the_geom);


--
-- TOC entry 7431 (class 1259 OID 2453309)
-- Name: sidx_intercambiador_vial_a; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_intercambiador_vial_a ON it_transporte_terrestre.intercambiador_vial_a USING gist (the_geom);


--
-- TOC entry 7434 (class 1259 OID 2453310)
-- Name: sidx_rodera_l; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_rodera_l ON it_transporte_terrestre.rodera_l USING gist (the_geom);


--
-- TOC entry 7437 (class 1259 OID 2453311)
-- Name: sidx_sendero_l; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_sendero_l ON it_transporte_terrestre.sendero_l USING gist (the_geom);


--
-- TOC entry 7438 (class 1259 OID 2453312)
-- Name: sidx_via_ruta_a; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_via_ruta_a ON it_transporte_terrestre.via_ruta_a USING gist (the_geom);


--
-- TOC entry 7523 (class 1259 OID 3376035)
-- Name: base_militar_a_sidx_base_militar_a; Type: INDEX; Schema: m_infraestructura_defensa_operaciones; Owner: postgres
--

CREATE INDEX base_militar_a_sidx_base_militar_a ON m_infraestructura_defensa_operaciones.base_militar_a USING gist (the_geom);


--
-- TOC entry 7880 (class 2618 OID 2453313)
-- Name: aeropuerto_a omitir_duplicados; Type: RULE; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO a_aeropuerto_superficie.aeropuerto_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM a_aeropuerto_superficie.aeropuerto_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7949 (class 2618 OID 3376080)
-- Name: zona_sin_informacion_a omitir_duplicados; Type: RULE; Schema: ct_miscelaneos; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ct_miscelaneos.zona_sin_informacion_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ct_miscelaneos.zona_sin_informacion_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO INSTEAD NOTHING;


--
-- TOC entry 7946 (class 2618 OID 3375829)
-- Name: limite_administrativo_l omitir_duplicados; Type: RULE; Schema: d_limite_politico_administrativo; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO d_limite_politico_administrativo.limite_administrativo_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM d_limite_politico_administrativo.limite_administrativo_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO INSTEAD NOTHING;


--
-- TOC entry 7969 (class 2618 OID 3484375)
-- Name: zona_administrativa_a omitir_duplicados; Type: RULE; Schema: d_limite_politico_administrativo; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO d_limite_politico_administrativo.zona_administrativa_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM d_limite_politico_administrativo.zona_administrativa_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO INSTEAD NOTHING;


--
-- TOC entry 7881 (class 2618 OID 2453315)
-- Name: punto_control_p omitir_duplicados; Type: RULE; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO d_linderos_propiedad.punto_control_p
   WHERE (0 <> ( SELECT count(*) AS count
           FROM d_linderos_propiedad.punto_control_p a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7882 (class 2618 OID 2453317)
-- Name: plaza_publica_a omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.plaza_publica_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.plaza_publica_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7883 (class 2618 OID 2453319)
-- Name: muro_l omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.muro_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.muro_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7884 (class 2618 OID 2453321)
-- Name: escalinata_a omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.escalinata_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.escalinata_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7885 (class 2618 OID 2453323)
-- Name: cerca_l omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.cerca_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.cerca_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7886 (class 2618 OID 2453325)
-- Name: cementerio_a omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.cementerio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.cementerio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7912 (class 2618 OID 3373086)
-- Name: choza_a omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.choza_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.choza_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7951 (class 2618 OID 3376120)
-- Name: muro_a omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.muro_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.muro_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO INSTEAD NOTHING;


--
-- TOC entry 7942 (class 2618 OID 3375756)
-- Name: estructura_no_construida_a omitir_duplicados; Type: RULE; Schema: gs_comercio; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_comercio.estructura_no_construida_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_comercio.estructura_no_construida_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO INSTEAD NOTHING;


--
-- TOC entry 7943 (class 2618 OID 3375787)
-- Name: instalacion_a omitir_duplicados; Type: RULE; Schema: gs_comercio; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_comercio.instalacion_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_comercio.instalacion_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO INSTEAD NOTHING;


--
-- TOC entry 7887 (class 2618 OID 2453329)
-- Name: plaza_toros_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.plaza_toros_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.plaza_toros_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7888 (class 2618 OID 2453331)
-- Name: piscina_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.piscina_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.piscina_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7889 (class 2618 OID 2453333)
-- Name: parque_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.parque_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.parque_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7890 (class 2618 OID 2453335)
-- Name: estadio_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.estadio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.estadio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7891 (class 2618 OID 2453337)
-- Name: cancha_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.cancha_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.cancha_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7914 (class 2618 OID 3373222)
-- Name: recinto_ferial_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.recinto_ferial_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.recinto_ferial_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7916 (class 2618 OID 3373261)
-- Name: sitio_arqueologico_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.sitio_arqueologico_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.sitio_arqueologico_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7918 (class 2618 OID 3373548)
-- Name: zoologico_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.zoologico_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.zoologico_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7919 (class 2618 OID 3373622)
-- Name: paseo_maritimo_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.paseo_maritimo_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.paseo_maritimo_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7892 (class 2618 OID 2453339)
-- Name: zanja_l omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.zanja_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.zanja_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7893 (class 2618 OID 2453341)
-- Name: rio_l omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.rio_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.rio_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7894 (class 2618 OID 2453343)
-- Name: rio_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.rio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.rio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7895 (class 2618 OID 2453345)
-- Name: lago_laguna_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.lago_laguna_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.lago_laguna_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7896 (class 2618 OID 2453347)
-- Name: acueducto_canal_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.acueducto_canal_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.acueducto_canal_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7897 (class 2618 OID 2453349)
-- Name: acequia_l omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.acequia_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.acequia_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7921 (class 2618 OID 3373672)
-- Name: estanque_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.estanque_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.estanque_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7923 (class 2618 OID 3373722)
-- Name: presa_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.presa_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.presa_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7953 (class 2618 OID 3376166)
-- Name: acequia_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.acequia_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.acequia_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO INSTEAD NOTHING;


--
-- TOC entry 7954 (class 2618 OID 3376200)
-- Name: acueducto_canal_l omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.acueducto_canal_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.acueducto_canal_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO INSTEAD NOTHING;


--
-- TOC entry 7959 (class 2618 OID 3376294)
-- Name: presa_l omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.presa_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.presa_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO INSTEAD NOTHING;


--
-- TOC entry 7961 (class 2618 OID 3376334)
-- Name: zanja_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.zanja_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.zanja_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO INSTEAD NOTHING;


--
-- TOC entry 7898 (class 2618 OID 2453351)
-- Name: puerto_a omitir_duplicados; Type: RULE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_puertos_muelles.puerto_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_puertos_muelles.puerto_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7925 (class 2618 OID 3373760)
-- Name: malecon_a omitir_duplicados; Type: RULE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_puertos_muelles.malecon_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_puertos_muelles.malecon_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7927 (class 2618 OID 3373817)
-- Name: muelle_a omitir_duplicados; Type: RULE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_puertos_muelles.muelle_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_puertos_muelles.muelle_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7929 (class 2618 OID 3373869)
-- Name: malecon_l omitir_duplicados; Type: RULE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_puertos_muelles.malecon_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_puertos_muelles.malecon_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7931 (class 2618 OID 3373912)
-- Name: muelle_l omitir_duplicados; Type: RULE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_puertos_muelles.muelle_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_puertos_muelles.muelle_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7899 (class 2618 OID 2453353)
-- Name: granja_acuatica_a omitir_duplicados; Type: RULE; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_regulacion_zonas_restringidas.granja_acuatica_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_regulacion_zonas_restringidas.granja_acuatica_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7900 (class 2618 OID 2453355)
-- Name: orilla_l omitir_duplicados; Type: RULE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_zonas_costeras.orilla_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_zonas_costeras.orilla_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7901 (class 2618 OID 2453357)
-- Name: isla_a omitir_duplicados; Type: RULE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_zonas_costeras.isla_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_zonas_costeras.isla_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7902 (class 2618 OID 2453359)
-- Name: invernadero_a omitir_duplicados; Type: RULE; Schema: ii_agropecuaria; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ii_agropecuaria.invernadero_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ii_agropecuaria.invernadero_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7963 (class 2618 OID 3376363)
-- Name: invernadero_p omitir_duplicados; Type: RULE; Schema: ii_agropecuaria; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ii_agropecuaria.invernadero_p
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ii_agropecuaria.invernadero_p a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7940 (class 2618 OID 3375710)
-- Name: tuberia_l omitir_duplicados; Type: RULE; Schema: ii_estructura_asociada_industria; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ii_estructura_asociada_industria.tuberia_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ii_estructura_asociada_industria.tuberia_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO INSTEAD NOTHING;


--
-- TOC entry 7936 (class 2618 OID 3375535)
-- Name: campo_petroleo_gas_a omitir_duplicados; Type: RULE; Schema: ii_extraccion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ii_extraccion.campo_petroleo_gas_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ii_extraccion.campo_petroleo_gas_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO INSTEAD NOTHING;


--
-- TOC entry 7937 (class 2618 OID 3375602)
-- Name: cantera_a omitir_duplicados; Type: RULE; Schema: ii_extraccion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ii_extraccion.cantera_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ii_extraccion.cantera_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO INSTEAD NOTHING;


--
-- TOC entry 7903 (class 2618 OID 2453361)
-- Name: paseo_peatonal_ciclovia_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.paseo_peatonal_ciclovia_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.paseo_peatonal_ciclovia_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7904 (class 2618 OID 2453363)
-- Name: parqueadero_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.parqueadero_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.parqueadero_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7905 (class 2618 OID 2453369)
-- Name: tunel_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.tunel_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.tunel_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7965 (class 2618 OID 3376429)
-- Name: paseo_peatonal_ciclovia_l omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.paseo_peatonal_ciclovia_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.paseo_peatonal_ciclovia_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO INSTEAD NOTHING;


--
-- TOC entry 7906 (class 2618 OID 2453373)
-- Name: puente_a omitir_duplicados; Type: RULE; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_cruces_enlaces.puente_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_cruces_enlaces.puente_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7934 (class 2618 OID 3374059)
-- Name: estacion_ferrocarril_a omitir_duplicados; Type: RULE; Schema: it_ferrocarriles; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_ferrocarriles.estacion_ferrocarril_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_ferrocarriles.estacion_ferrocarril_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7967 (class 2618 OID 3376483)
-- Name: ferrocarril_l omitir_duplicados; Type: RULE; Schema: it_ferrocarriles; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_ferrocarriles.ferrocarril_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_ferrocarriles.ferrocarril_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO INSTEAD NOTHING;


--
-- TOC entry 7907 (class 2618 OID 2453377)
-- Name: via_ruta_a omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.via_ruta_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.via_ruta_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7908 (class 2618 OID 2453379)
-- Name: sendero_l omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.sendero_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.sendero_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7909 (class 2618 OID 2453381)
-- Name: rodera_l omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.rodera_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.rodera_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7910 (class 2618 OID 2453383)
-- Name: intercambiador_vial_a omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.intercambiador_vial_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.intercambiador_vial_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7911 (class 2618 OID 2453385)
-- Name: gasolinera_a omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.gasolinera_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.gasolinera_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7947 (class 2618 OID 3376036)
-- Name: base_militar_a omitir_duplicados; Type: RULE; Schema: m_infraestructura_defensa_operaciones; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO m_infraestructura_defensa_operaciones.base_militar_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM m_infraestructura_defensa_operaciones.base_militar_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO INSTEAD NOTHING;


--
-- TOC entry 7554 (class 2606 OID 2453387)
-- Name: aeropuerto_a aeropuerto_a_fk; Type: FK CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_fk FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7555 (class 2606 OID 2453392)
-- Name: aeropuerto_a aeropuerto_a_fk1; Type: FK CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_fk1 FOREIGN KEY (fuc) REFERENCES catalogo_objetos.fuc(fuc);


--
-- TOC entry 7556 (class 2606 OID 2453397)
-- Name: aeropuerto_a aeropuerto_a_fk2; Type: FK CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_fk2 FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7679 (class 2606 OID 3376074)
-- Name: zona_sin_informacion_a zona_sin_informacion_a_fk; Type: FK CONSTRAINT; Schema: ct_miscelaneos; Owner: postgres
--

ALTER TABLE ONLY ct_miscelaneos.zona_sin_informacion_a
    ADD CONSTRAINT zona_sin_informacion_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7677 (class 2606 OID 3375823)
-- Name: limite_administrativo_l limite_administrativo_l_fk; Type: FK CONSTRAINT; Schema: d_limite_politico_administrativo; Owner: postgres
--

ALTER TABLE ONLY d_limite_politico_administrativo.limite_administrativo_l
    ADD CONSTRAINT limite_administrativo_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7702 (class 2606 OID 3484369)
-- Name: zona_administrativa_a zona_administrativa_a_fk; Type: FK CONSTRAINT; Schema: d_limite_politico_administrativo; Owner: postgres
--

ALTER TABLE ONLY d_limite_politico_administrativo.zona_administrativa_a
    ADD CONSTRAINT zona_administrativa_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7557 (class 2606 OID 2453402)
-- Name: punto_control_p punto_control_p_fk; Type: FK CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7558 (class 2606 OID 2453407)
-- Name: punto_control_p punto_control_p_fk1; Type: FK CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7559 (class 2606 OID 2453412)
-- Name: punto_control_p punto_control_p_fk2; Type: FK CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_fk2 FOREIGN KEY (ela) REFERENCES catalogo_objetos.ela(ela);


--
-- TOC entry 7560 (class 2606 OID 2453417)
-- Name: cementerio_a cementerio_a_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a
    ADD CONSTRAINT cementerio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7561 (class 2606 OID 2453422)
-- Name: cementerio_a cementerio_a_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a
    ADD CONSTRAINT cementerio_a_fk1 FOREIGN KEY (rel) REFERENCES catalogo_objetos.rel(rel);


--
-- TOC entry 7562 (class 2606 OID 2453427)
-- Name: cerca_l cerca_l_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7563 (class 2606 OID 2453432)
-- Name: cerca_l cerca_l_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_fk1 FOREIGN KEY (fti) REFERENCES catalogo_objetos.fti(fti);


--
-- TOC entry 7564 (class 2606 OID 2453437)
-- Name: cerca_l cerca_l_fk2; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_fk2 FOREIGN KEY (wti) REFERENCES catalogo_objetos.wti(wti);


--
-- TOC entry 7637 (class 2606 OID 3373075)
-- Name: choza_a choza_a_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.choza_a
    ADD CONSTRAINT choza_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7565 (class 2606 OID 2453442)
-- Name: escalinata_a escalinata_a_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a
    ADD CONSTRAINT escalinata_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7566 (class 2606 OID 2453447)
-- Name: escalinata_a escalinata_a_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a
    ADD CONSTRAINT escalinata_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7680 (class 2606 OID 3376109)
-- Name: muro_a muro_a_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_a
    ADD CONSTRAINT muro_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7681 (class 2606 OID 3376114)
-- Name: muro_a muro_a_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_a
    ADD CONSTRAINT muro_a_fk1 FOREIGN KEY (wti) REFERENCES catalogo_objetos.wti(wti);


--
-- TOC entry 7567 (class 2606 OID 2453452)
-- Name: muro_l muro_l_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l
    ADD CONSTRAINT muro_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7568 (class 2606 OID 2453457)
-- Name: muro_l muro_l_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l
    ADD CONSTRAINT muro_l_fk1 FOREIGN KEY (wti) REFERENCES catalogo_objetos.wti(wti);


--
-- TOC entry 7569 (class 2606 OID 2453462)
-- Name: plaza_publica_a plaza_publica_a_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a
    ADD CONSTRAINT plaza_publica_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7570 (class 2606 OID 2453467)
-- Name: plaza_publica_a plaza_publica_a_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a
    ADD CONSTRAINT plaza_publica_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7673 (class 2606 OID 3375745)
-- Name: estructura_no_construida_a estructura_no_construida_a_fk; Type: FK CONSTRAINT; Schema: gs_comercio; Owner: postgres
--

ALTER TABLE ONLY gs_comercio.estructura_no_construida_a
    ADD CONSTRAINT estructura_no_construida_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7674 (class 2606 OID 3375750)
-- Name: estructura_no_construida_a estructura_no_construida_a_fk1; Type: FK CONSTRAINT; Schema: gs_comercio; Owner: postgres
--

ALTER TABLE ONLY gs_comercio.estructura_no_construida_a
    ADD CONSTRAINT estructura_no_construida_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7675 (class 2606 OID 3375776)
-- Name: instalacion_a instalacion_a_fk; Type: FK CONSTRAINT; Schema: gs_comercio; Owner: postgres
--

ALTER TABLE ONLY gs_comercio.instalacion_a
    ADD CONSTRAINT instalacion_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7676 (class 2606 OID 3375781)
-- Name: instalacion_a instalacion_a_fk1; Type: FK CONSTRAINT; Schema: gs_comercio; Owner: postgres
--

ALTER TABLE ONLY gs_comercio.instalacion_a
    ADD CONSTRAINT instalacion_a_fk1 FOREIGN KEY (ffn) REFERENCES catalogo_objetos.ffn(ffn);


--
-- TOC entry 7638 (class 2606 OID 3373144)
-- Name: edificio_a edificio_a_fk; Type: FK CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7639 (class 2606 OID 3373149)
-- Name: edificio_a edificio_a_fk1; Type: FK CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7640 (class 2606 OID 3373154)
-- Name: edificio_a edificio_a_fk2; Type: FK CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_fk2 FOREIGN KEY (uuc) REFERENCES catalogo_objetos.uuc(uuc);


--
-- TOC entry 7641 (class 2606 OID 3373171)
-- Name: edificio_a edificio_a_fk3; Type: FK CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_fk3 FOREIGN KEY (psf) REFERENCES catalogo_objetos.psf(psf);


--
-- TOC entry 7642 (class 2606 OID 3373177)
-- Name: edificio_a edificio_a_fk4; Type: FK CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_fk4 FOREIGN KEY (res) REFERENCES catalogo_objetos.res(res);


--
-- TOC entry 7643 (class 2606 OID 3373182)
-- Name: edificio_a edificio_a_fk5; Type: FK CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_fk5 FOREIGN KEY (tfc) REFERENCES catalogo_objetos.tfc(tfc);


--
-- TOC entry 7571 (class 2606 OID 2453487)
-- Name: cancha_a cancha_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7572 (class 2606 OID 2453492)
-- Name: cancha_a cancha_a_fk1; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7573 (class 2606 OID 2453497)
-- Name: cancha_a cancha_a_fk2; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_fk2 FOREIGN KEY (kos) REFERENCES catalogo_objetos.kos(kos);


--
-- TOC entry 7574 (class 2606 OID 2453502)
-- Name: estadio_a estadio_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a
    ADD CONSTRAINT estadio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7575 (class 2606 OID 2453507)
-- Name: estadio_a estadio_a_fk1; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a
    ADD CONSTRAINT estadio_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7576 (class 2606 OID 2453512)
-- Name: parque_a parque_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a
    ADD CONSTRAINT parque_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7577 (class 2606 OID 2453517)
-- Name: parque_a parque_a_fk1; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a
    ADD CONSTRAINT parque_a_fk1 FOREIGN KEY (fuc) REFERENCES catalogo_objetos.fuc(fuc);


--
-- TOC entry 7647 (class 2606 OID 3373611)
-- Name: paseo_maritimo_a paseo_maritimo_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.paseo_maritimo_a
    ADD CONSTRAINT paseo_maritimo_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7648 (class 2606 OID 3373616)
-- Name: paseo_maritimo_a paseo_maritimo_a_fk1; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.paseo_maritimo_a
    ADD CONSTRAINT paseo_maritimo_a_fk1 FOREIGN KEY (mcc) REFERENCES catalogo_objetos.mcc(mcc);


--
-- TOC entry 7578 (class 2606 OID 2453522)
-- Name: piscina_a piscina_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.piscina_a
    ADD CONSTRAINT piscina_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7579 (class 2606 OID 2453527)
-- Name: plaza_toros_a plaza_toros_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.plaza_toros_a
    ADD CONSTRAINT plaza_toros_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7644 (class 2606 OID 3373216)
-- Name: recinto_ferial_a recinto_ferial_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.recinto_ferial_a
    ADD CONSTRAINT recinto_ferial_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7645 (class 2606 OID 3373255)
-- Name: sitio_arqueologico_a sitio_arqueologico_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.sitio_arqueologico_a
    ADD CONSTRAINT sitio_arqueologico_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7646 (class 2606 OID 3373542)
-- Name: zoologico_a zoologico_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.zoologico_a
    ADD CONSTRAINT zoologico_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7682 (class 2606 OID 3376150)
-- Name: acequia_a acequia_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_a
    ADD CONSTRAINT acequia_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7683 (class 2606 OID 3376155)
-- Name: acequia_a acequia_a_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_a
    ADD CONSTRAINT acequia_a_fk2 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7684 (class 2606 OID 3376160)
-- Name: acequia_a acequia_a_fk3; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_a
    ADD CONSTRAINT acequia_a_fk3 FOREIGN KEY (dit) REFERENCES catalogo_objetos.dit(dit);


--
-- TOC entry 7580 (class 2606 OID 2453532)
-- Name: acequia_l acequia_l_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7581 (class 2606 OID 2453537)
-- Name: acequia_l acequia_l_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_fk1 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7582 (class 2606 OID 2453542)
-- Name: acequia_l acequia_l_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_fk2 FOREIGN KEY (dit) REFERENCES catalogo_objetos.dit(dit);


--
-- TOC entry 7583 (class 2606 OID 2453547)
-- Name: acueducto_canal_a acueducto_canal_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_canal_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7584 (class 2606 OID 2453552)
-- Name: acueducto_canal_a acueducto_canal_a_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_canal_a_fk1 FOREIGN KEY (atc) REFERENCES catalogo_objetos.atc(atc);


--
-- TOC entry 7585 (class 2606 OID 2453557)
-- Name: acueducto_canal_a acueducto_canal_a_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_canal_a_fk2 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7685 (class 2606 OID 3376184)
-- Name: acueducto_canal_l acueducto_canal_l_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_l
    ADD CONSTRAINT acueducto_canal_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7686 (class 2606 OID 3376189)
-- Name: acueducto_canal_l acueducto_canal_l_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_l
    ADD CONSTRAINT acueducto_canal_l_fk1 FOREIGN KEY (atc) REFERENCES catalogo_objetos.atc(atc);


--
-- TOC entry 7687 (class 2606 OID 3376194)
-- Name: acueducto_canal_l acueducto_canal_l_fk3; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_l
    ADD CONSTRAINT acueducto_canal_l_fk3 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7649 (class 2606 OID 3373666)
-- Name: estanque_a estanque_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.estanque_a
    ADD CONSTRAINT estanque_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7586 (class 2606 OID 2453562)
-- Name: lago_laguna_a lago_laguna_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a
    ADD CONSTRAINT lago_laguna_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7587 (class 2606 OID 2453567)
-- Name: lago_laguna_a lago_laguna_a_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a
    ADD CONSTRAINT lago_laguna_a_fk1 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7650 (class 2606 OID 3373706)
-- Name: presa_a presa_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.presa_a
    ADD CONSTRAINT presa_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7651 (class 2606 OID 3373711)
-- Name: presa_a presa_a_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.presa_a
    ADD CONSTRAINT presa_a_fk1 FOREIGN KEY (mcc) REFERENCES catalogo_objetos.mcc(mcc);


--
-- TOC entry 7652 (class 2606 OID 3373716)
-- Name: presa_a presa_a_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.presa_a
    ADD CONSTRAINT presa_a_fk2 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


--
-- TOC entry 7688 (class 2606 OID 3376278)
-- Name: presa_l presa_l_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.presa_l
    ADD CONSTRAINT presa_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7689 (class 2606 OID 3376283)
-- Name: presa_l presa_l_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.presa_l
    ADD CONSTRAINT presa_l_fk1 FOREIGN KEY (mcc) REFERENCES catalogo_objetos.mcc(mcc);


--
-- TOC entry 7690 (class 2606 OID 3376288)
-- Name: presa_l presa_l_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.presa_l
    ADD CONSTRAINT presa_l_fk2 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


--
-- TOC entry 7588 (class 2606 OID 2453572)
-- Name: rio_a rio_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7589 (class 2606 OID 2453577)
-- Name: rio_a rio_a_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7590 (class 2606 OID 2453582)
-- Name: rio_a rio_a_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_fk2 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7591 (class 2606 OID 2453587)
-- Name: rio_l rio_l_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7592 (class 2606 OID 2453592)
-- Name: rio_l rio_l_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7593 (class 2606 OID 2453597)
-- Name: rio_l rio_l_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_fk2 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7691 (class 2606 OID 3376323)
-- Name: zanja_a zanja_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_a
    ADD CONSTRAINT zanja_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7692 (class 2606 OID 3376328)
-- Name: zanja_a zanja_a_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_a
    ADD CONSTRAINT zanja_a_fk1 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7594 (class 2606 OID 2453602)
-- Name: zanja_l zanja_l_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l
    ADD CONSTRAINT zanja_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7595 (class 2606 OID 2453607)
-- Name: zanja_l zanja_l_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l
    ADD CONSTRAINT zanja_l_fk1 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7653 (class 2606 OID 3373749)
-- Name: malecon_a malecon_a_fk; Type: FK CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.malecon_a
    ADD CONSTRAINT malecon_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7654 (class 2606 OID 3373754)
-- Name: malecon_a malecon_a_fk1; Type: FK CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.malecon_a
    ADD CONSTRAINT malecon_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7659 (class 2606 OID 3373858)
-- Name: malecon_l malecon_l_fk; Type: FK CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.malecon_l
    ADD CONSTRAINT malecon_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7660 (class 2606 OID 3373863)
-- Name: malecon_l malecon_l_fk1; Type: FK CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.malecon_l
    ADD CONSTRAINT malecon_l_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7655 (class 2606 OID 3373796)
-- Name: muelle_a muelle_a_fk; Type: FK CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.muelle_a
    ADD CONSTRAINT muelle_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7656 (class 2606 OID 3373801)
-- Name: muelle_a muelle_a_fk3; Type: FK CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.muelle_a
    ADD CONSTRAINT muelle_a_fk3 FOREIGN KEY (loc) REFERENCES catalogo_objetos.loc(loc);


--
-- TOC entry 7657 (class 2606 OID 3373806)
-- Name: muelle_a muelle_a_fk4; Type: FK CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.muelle_a
    ADD CONSTRAINT muelle_a_fk4 FOREIGN KEY (pwc) REFERENCES catalogo_objetos.pwc(pwc);


--
-- TOC entry 7658 (class 2606 OID 3373811)
-- Name: muelle_a muelle_a_fk6; Type: FK CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.muelle_a
    ADD CONSTRAINT muelle_a_fk6 FOREIGN KEY (fuc) REFERENCES catalogo_objetos.fuc(fuc);


--
-- TOC entry 7661 (class 2606 OID 3373891)
-- Name: muelle_l muelle_l_fk; Type: FK CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.muelle_l
    ADD CONSTRAINT muelle_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7662 (class 2606 OID 3373896)
-- Name: muelle_l muelle_l_fk3; Type: FK CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.muelle_l
    ADD CONSTRAINT muelle_l_fk3 FOREIGN KEY (loc) REFERENCES catalogo_objetos.loc(loc);


--
-- TOC entry 7663 (class 2606 OID 3373901)
-- Name: muelle_l muelle_l_fk4; Type: FK CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.muelle_l
    ADD CONSTRAINT muelle_l_fk4 FOREIGN KEY (pwc) REFERENCES catalogo_objetos.pwc(pwc);


--
-- TOC entry 7664 (class 2606 OID 3373906)
-- Name: muelle_l muelle_l_fk6; Type: FK CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.muelle_l
    ADD CONSTRAINT muelle_l_fk6 FOREIGN KEY (fuc) REFERENCES catalogo_objetos.fuc(fuc);


--
-- TOC entry 7596 (class 2606 OID 2453612)
-- Name: puerto_a puerto_a_fk; Type: FK CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.puerto_a
    ADD CONSTRAINT puerto_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7597 (class 2606 OID 2453617)
-- Name: granja_acuatica_a granja_acuatica_a_fk; Type: FK CONSTRAINT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER TABLE ONLY ho_regulacion_zonas_restringidas.granja_acuatica_a
    ADD CONSTRAINT granja_acuatica_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7598 (class 2606 OID 2453622)
-- Name: isla_a isla_a_fk; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.isla_a
    ADD CONSTRAINT isla_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7599 (class 2606 OID 2453627)
-- Name: orilla_l orilla_l_fk; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7600 (class 2606 OID 2453632)
-- Name: orilla_l orilla_l_fk1; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7601 (class 2606 OID 2453637)
-- Name: orilla_l orilla_l_fk2; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_fk2 FOREIGN KEY (slt) REFERENCES catalogo_objetos.slt(slt);


--
-- TOC entry 7602 (class 2606 OID 2453642)
-- Name: invernadero_a invernadero_a_fk; Type: FK CONSTRAINT; Schema: ii_agropecuaria; Owner: postgres
--

ALTER TABLE ONLY ii_agropecuaria.invernadero_a
    ADD CONSTRAINT invernadero_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7693 (class 2606 OID 3376357)
-- Name: invernadero_p invernadero_p_fk; Type: FK CONSTRAINT; Schema: ii_agropecuaria; Owner: postgres
--

ALTER TABLE ONLY ii_agropecuaria.invernadero_p
    ADD CONSTRAINT invernadero_p_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7670 (class 2606 OID 3375694)
-- Name: tuberia_l tuberia_l_fk; Type: FK CONSTRAINT; Schema: ii_estructura_asociada_industria; Owner: postgres
--

ALTER TABLE ONLY ii_estructura_asociada_industria.tuberia_l
    ADD CONSTRAINT tuberia_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7671 (class 2606 OID 3375699)
-- Name: tuberia_l tuberia_l_fk1; Type: FK CONSTRAINT; Schema: ii_estructura_asociada_industria; Owner: postgres
--

ALTER TABLE ONLY ii_estructura_asociada_industria.tuberia_l
    ADD CONSTRAINT tuberia_l_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7672 (class 2606 OID 3375704)
-- Name: tuberia_l tuberia_l_fk2; Type: FK CONSTRAINT; Schema: ii_estructura_asociada_industria; Owner: postgres
--

ALTER TABLE ONLY ii_estructura_asociada_industria.tuberia_l
    ADD CONSTRAINT tuberia_l_fk2 FOREIGN KEY (loc) REFERENCES catalogo_objetos.loc(loc);


--
-- TOC entry 7666 (class 2606 OID 3375529)
-- Name: campo_petroleo_gas_a campo_petroleo_gas_a_fk; Type: FK CONSTRAINT; Schema: ii_extraccion; Owner: postgres
--

ALTER TABLE ONLY ii_extraccion.campo_petroleo_gas_a
    ADD CONSTRAINT campo_petroleo_gas_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7667 (class 2606 OID 3375586)
-- Name: cantera_a cantera_a_fk; Type: FK CONSTRAINT; Schema: ii_extraccion; Owner: postgres
--

ALTER TABLE ONLY ii_extraccion.cantera_a
    ADD CONSTRAINT cantera_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7668 (class 2606 OID 3375591)
-- Name: cantera_a cantera_a_fk1; Type: FK CONSTRAINT; Schema: ii_extraccion; Owner: postgres
--

ALTER TABLE ONLY ii_extraccion.cantera_a
    ADD CONSTRAINT cantera_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7669 (class 2606 OID 3375596)
-- Name: cantera_a cantera_a_fk3; Type: FK CONSTRAINT; Schema: ii_extraccion; Owner: postgres
--

ALTER TABLE ONLY ii_extraccion.cantera_a
    ADD CONSTRAINT cantera_a_fk3 FOREIGN KEY (ppo) REFERENCES catalogo_objetos.ppo(ppo);


--
-- TOC entry 7603 (class 2606 OID 2453677)
-- Name: parqueadero_a parqueadero_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a
    ADD CONSTRAINT parqueadero_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7604 (class 2606 OID 2453682)
-- Name: parqueadero_a parqueadero_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a
    ADD CONSTRAINT parqueadero_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7605 (class 2606 OID 2453687)
-- Name: paseo_peatonal_ciclovia_a paseo_peatonal_ciclovia_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a
    ADD CONSTRAINT paseo_peatonal_ciclovia_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7606 (class 2606 OID 2453692)
-- Name: paseo_peatonal_ciclovia_a paseo_peatonal_ciclovia_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a
    ADD CONSTRAINT paseo_peatonal_ciclovia_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7694 (class 2606 OID 3376418)
-- Name: paseo_peatonal_ciclovia_l paseo_peatonal_ciclovia_l_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_l
    ADD CONSTRAINT paseo_peatonal_ciclovia_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7695 (class 2606 OID 3376423)
-- Name: paseo_peatonal_ciclovia_l paseo_peatonal_ciclovia_l_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_l
    ADD CONSTRAINT paseo_peatonal_ciclovia_l_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7607 (class 2606 OID 2453697)
-- Name: tunel_a tunel_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7608 (class 2606 OID 2453702)
-- Name: tunel_a tunel_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_fk1 FOREIGN KEY (tra) REFERENCES catalogo_objetos.tra(tra);


--
-- TOC entry 7609 (class 2606 OID 2453707)
-- Name: tunel_a tunel_a_fk2; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_fk2 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


--
-- TOC entry 7610 (class 2606 OID 2453712)
-- Name: puente_a puente_a_fk; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7611 (class 2606 OID 2453717)
-- Name: puente_a puente_a_fk1; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7612 (class 2606 OID 2453722)
-- Name: puente_a puente_a_fk2; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk2 FOREIGN KEY (bsc) REFERENCES catalogo_objetos.bsc(bsc);


--
-- TOC entry 7613 (class 2606 OID 2453732)
-- Name: puente_a puente_a_fk4; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk4 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


--
-- TOC entry 7665 (class 2606 OID 3374053)
-- Name: estacion_ferrocarril_a estacion_ferrocarril_a_fk; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.estacion_ferrocarril_a
    ADD CONSTRAINT estacion_ferrocarril_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7696 (class 2606 OID 3376452)
-- Name: ferrocarril_l ferrocarril_l_fk; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_l
    ADD CONSTRAINT ferrocarril_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7697 (class 2606 OID 3376457)
-- Name: ferrocarril_l ferrocarril_l_fk1; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_l
    ADD CONSTRAINT ferrocarril_l_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7698 (class 2606 OID 3376462)
-- Name: ferrocarril_l ferrocarril_l_fk4; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_l
    ADD CONSTRAINT ferrocarril_l_fk4 FOREIGN KEY (loc) REFERENCES catalogo_objetos.loc(loc);


--
-- TOC entry 7699 (class 2606 OID 3376467)
-- Name: ferrocarril_l ferrocarril_l_fk5; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_l
    ADD CONSTRAINT ferrocarril_l_fk5 FOREIGN KEY (rgc) REFERENCES catalogo_objetos.rgc(rgc);


--
-- TOC entry 7700 (class 2606 OID 3376472)
-- Name: ferrocarril_l ferrocarril_l_fk6; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_l
    ADD CONSTRAINT ferrocarril_l_fk6 FOREIGN KEY (rra) REFERENCES catalogo_objetos.rra(rra);


--
-- TOC entry 7701 (class 2606 OID 3376477)
-- Name: ferrocarril_l ferrocarril_l_fk7; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_l
    ADD CONSTRAINT ferrocarril_l_fk7 FOREIGN KEY (rrc) REFERENCES catalogo_objetos.rrc(rrc);


--
-- TOC entry 7614 (class 2606 OID 2453772)
-- Name: gasolinera_a gasolinera_a_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.gasolinera_a
    ADD CONSTRAINT gasolinera_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7615 (class 2606 OID 2453777)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7616 (class 2606 OID 2453782)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk1 FOREIGN KEY (hct) REFERENCES catalogo_objetos.hct(hct);


--
-- TOC entry 7617 (class 2606 OID 2453787)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk2; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk2 FOREIGN KEY (rst) REFERENCES catalogo_objetos.rst(rst);


--
-- TOC entry 7618 (class 2606 OID 2453792)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk3; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk3 FOREIGN KEY (loc) REFERENCES catalogo_objetos.loc(loc);


--
-- TOC entry 7619 (class 2606 OID 2453797)
-- Name: rodera_l rodera_l_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7620 (class 2606 OID 2453802)
-- Name: rodera_l rodera_l_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk1 FOREIGN KEY (typ) REFERENCES catalogo_objetos.typ(typ);


--
-- TOC entry 7621 (class 2606 OID 2453807)
-- Name: rodera_l rodera_l_fk2; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk2 FOREIGN KEY (rst) REFERENCES catalogo_objetos.rst(rst);


--
-- TOC entry 7622 (class 2606 OID 2453812)
-- Name: rodera_l rodera_l_fk3; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk3 FOREIGN KEY (hct) REFERENCES catalogo_objetos.hct(hct);


--
-- TOC entry 7623 (class 2606 OID 2453817)
-- Name: rodera_l rodera_l_fk4; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk4 FOREIGN KEY (rdt) REFERENCES catalogo_objetos.rdt(rdt);


--
-- TOC entry 7624 (class 2606 OID 2453822)
-- Name: rodera_l rodera_l_fk5; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk5 FOREIGN KEY (wtc) REFERENCES catalogo_objetos.wtc(wtc);


--
-- TOC entry 7625 (class 2606 OID 2453827)
-- Name: rodera_l rodera_l_fk6; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk6 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


--
-- TOC entry 7626 (class 2606 OID 2453832)
-- Name: sendero_l sendero_l_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l
    ADD CONSTRAINT sendero_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7627 (class 2606 OID 2453837)
-- Name: sendero_l sendero_l_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l
    ADD CONSTRAINT sendero_l_fk1 FOREIGN KEY (wtc) REFERENCES catalogo_objetos.wtc(wtc);


--
-- TOC entry 7628 (class 2606 OID 2453842)
-- Name: via_ruta_a via_ruta_a_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7629 (class 2606 OID 2453847)
-- Name: via_ruta_a via_ruta_a_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7630 (class 2606 OID 2453852)
-- Name: via_ruta_a via_ruta_a_fk2; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk2 FOREIGN KEY (rst) REFERENCES catalogo_objetos.rst(rst);


--
-- TOC entry 7631 (class 2606 OID 2453857)
-- Name: via_ruta_a via_ruta_a_fk3; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk3 FOREIGN KEY (typ) REFERENCES catalogo_objetos.typ(typ);


--
-- TOC entry 7632 (class 2606 OID 2453862)
-- Name: via_ruta_a via_ruta_a_fk4; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk4 FOREIGN KEY (hct) REFERENCES catalogo_objetos.hct(hct);


--
-- TOC entry 7633 (class 2606 OID 2453867)
-- Name: via_ruta_a via_ruta_a_fk5; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk5 FOREIGN KEY (loc) REFERENCES catalogo_objetos.loc(loc);


--
-- TOC entry 7634 (class 2606 OID 2453872)
-- Name: via_ruta_a via_ruta_a_fk6; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk6 FOREIGN KEY (mes) REFERENCES catalogo_objetos.mes(mes);


--
-- TOC entry 7635 (class 2606 OID 2453877)
-- Name: via_ruta_a via_ruta_a_fk7; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk7 FOREIGN KEY (rdt) REFERENCES catalogo_objetos.rdt(rdt);


--
-- TOC entry 7636 (class 2606 OID 2453882)
-- Name: via_ruta_a via_ruta_a_fk8; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk8 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


--
-- TOC entry 7678 (class 2606 OID 3376030)
-- Name: base_militar_a base_militar_a_fk; Type: FK CONSTRAINT; Schema: m_infraestructura_defensa_operaciones; Owner: postgres
--

ALTER TABLE ONLY m_infraestructura_defensa_operaciones.base_militar_a
    ADD CONSTRAINT base_militar_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 8140 (class 0 OID 0)
-- Dependencies: 27
-- Name: SCHEMA catalogo_objetos; Type: ACL; Schema: -; Owner: postgres
--

GRANT ALL ON SCHEMA catalogo_objetos TO editores_cartografico;
GRANT CREATE ON SCHEMA catalogo_objetos TO lchanaluisa;
GRANT ALL ON SCHEMA catalogo_objetos TO mzuniga;
GRANT USAGE ON SCHEMA catalogo_objetos TO fsalgado;
GRANT CREATE ON SCHEMA catalogo_objetos TO fsalgado WITH GRANT OPTION;
GRANT ALL ON SCHEMA catalogo_objetos TO dguallichico WITH GRANT OPTION;
GRANT USAGE ON SCHEMA catalogo_objetos TO kcopo;


--
-- TOC entry 8151 (class 0 OID 0)
-- Dependencies: 319
-- Name: TABLE acc; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.acc TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.acc TO editores;
GRANT ALL ON TABLE catalogo_objetos.acc TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.acc TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.acc TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.acc TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.acc TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.acc TO kcopo;


--
-- TOC entry 8152 (class 0 OID 0)
-- Dependencies: 320
-- Name: TABLE atc; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.atc TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.atc TO editores;
GRANT ALL ON TABLE catalogo_objetos.atc TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.atc TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.atc TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.atc TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.atc TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.atc TO kcopo;


--
-- TOC entry 8153 (class 0 OID 0)
-- Dependencies: 321
-- Name: TABLE bsc; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.bsc TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.bsc TO editores;
GRANT ALL ON TABLE catalogo_objetos.bsc TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.bsc TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.bsc TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.bsc TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.bsc TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.bsc TO kcopo;


--
-- TOC entry 8154 (class 0 OID 0)
-- Dependencies: 322
-- Name: TABLE catalogo_objetos; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.catalogo_objetos TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.catalogo_objetos TO editores;
GRANT ALL ON TABLE catalogo_objetos.catalogo_objetos TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.catalogo_objetos TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.catalogo_objetos TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.catalogo_objetos TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.catalogo_objetos TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.catalogo_objetos TO kcopo;


--
-- TOC entry 8156 (class 0 OID 0)
-- Dependencies: 323
-- Name: SEQUENCE catalogo_objetos_gid_seq; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT ALL ON SEQUENCE catalogo_objetos.catalogo_objetos_gid_seq TO editores_cartografico;
GRANT ALL ON SEQUENCE catalogo_objetos.catalogo_objetos_gid_seq TO editores;
GRANT ALL ON SEQUENCE catalogo_objetos.catalogo_objetos_gid_seq TO lchanaluisa;
GRANT ALL ON SEQUENCE catalogo_objetos.catalogo_objetos_gid_seq TO mzuniga;
GRANT ALL ON SEQUENCE catalogo_objetos.catalogo_objetos_gid_seq TO fsalgado;
GRANT ALL ON SEQUENCE catalogo_objetos.catalogo_objetos_gid_seq TO dguallichico;
GRANT USAGE ON SEQUENCE catalogo_objetos.catalogo_objetos_gid_seq TO kcopo;


--
-- TOC entry 8157 (class 0 OID 0)
-- Dependencies: 324
-- Name: TABLE dit; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.dit TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.dit TO editores;
GRANT ALL ON TABLE catalogo_objetos.dit TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.dit TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.dit TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.dit TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.dit TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.dit TO kcopo;


--
-- TOC entry 8158 (class 0 OID 0)
-- Dependencies: 325
-- Name: TABLE ela; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.ela TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.ela TO editores;
GRANT ALL ON TABLE catalogo_objetos.ela TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.ela TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.ela TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.ela TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.ela TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.ela TO kcopo;


--
-- TOC entry 8159 (class 0 OID 0)
-- Dependencies: 326
-- Name: TABLE fco; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.fco TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.fco TO editores;
GRANT ALL ON TABLE catalogo_objetos.fco TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.fco TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.fco TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.fco TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.fco TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.fco TO kcopo;


--
-- TOC entry 8160 (class 0 OID 0)
-- Dependencies: 327
-- Name: TABLE fti; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.fti TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.fti TO editores;
GRANT ALL ON TABLE catalogo_objetos.fti TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.fti TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.fti TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.fti TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.fti TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.fti TO kcopo;


--
-- TOC entry 8161 (class 0 OID 0)
-- Dependencies: 328
-- Name: TABLE fuc; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.fuc TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.fuc TO editores;
GRANT ALL ON TABLE catalogo_objetos.fuc TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.fuc TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.fuc TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.fuc TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.fuc TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.fuc TO kcopo;


--
-- TOC entry 8162 (class 0 OID 0)
-- Dependencies: 329
-- Name: TABLE hct; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.hct TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.hct TO editores;
GRANT ALL ON TABLE catalogo_objetos.hct TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.hct TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.hct TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.hct TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.hct TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.hct TO kcopo;


--
-- TOC entry 8163 (class 0 OID 0)
-- Dependencies: 330
-- Name: TABLE hyp; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.hyp TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.hyp TO editores;
GRANT ALL ON TABLE catalogo_objetos.hyp TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.hyp TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.hyp TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.hyp TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.hyp TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.hyp TO kcopo;


--
-- TOC entry 8164 (class 0 OID 0)
-- Dependencies: 331
-- Name: TABLE kos; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.kos TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.kos TO editores;
GRANT ALL ON TABLE catalogo_objetos.kos TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.kos TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.kos TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.kos TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.kos TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.kos TO kcopo;


--
-- TOC entry 8165 (class 0 OID 0)
-- Dependencies: 332
-- Name: TABLE loc; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.loc TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.loc TO editores;
GRANT ALL ON TABLE catalogo_objetos.loc TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.loc TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.loc TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.loc TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.loc TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.loc TO kcopo;


--
-- TOC entry 8166 (class 0 OID 0)
-- Dependencies: 333
-- Name: TABLE mes; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.mes TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.mes TO editores;
GRANT ALL ON TABLE catalogo_objetos.mes TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.mes TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.mes TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.mes TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.mes TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.mes TO kcopo;


--
-- TOC entry 8167 (class 0 OID 0)
-- Dependencies: 334
-- Name: TABLE rdt; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rdt TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rdt TO editores;
GRANT ALL ON TABLE catalogo_objetos.rdt TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rdt TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rdt TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.rdt TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rdt TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rdt TO kcopo;


--
-- TOC entry 8168 (class 0 OID 0)
-- Dependencies: 335
-- Name: TABLE rel; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rel TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rel TO editores;
GRANT ALL ON TABLE catalogo_objetos.rel TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rel TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rel TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.rel TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rel TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rel TO kcopo;


--
-- TOC entry 8169 (class 0 OID 0)
-- Dependencies: 336
-- Name: TABLE rgc; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rgc TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rgc TO editores;
GRANT ALL ON TABLE catalogo_objetos.rgc TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rgc TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rgc TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.rgc TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rgc TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rgc TO kcopo;


--
-- TOC entry 8170 (class 0 OID 0)
-- Dependencies: 337
-- Name: TABLE rra; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rra TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rra TO editores;
GRANT ALL ON TABLE catalogo_objetos.rra TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rra TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rra TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.rra TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rra TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rra TO kcopo;


--
-- TOC entry 8171 (class 0 OID 0)
-- Dependencies: 338
-- Name: TABLE rrc; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rrc TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rrc TO editores;
GRANT ALL ON TABLE catalogo_objetos.rrc TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rrc TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rrc TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.rrc TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rrc TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rrc TO kcopo;


--
-- TOC entry 8172 (class 0 OID 0)
-- Dependencies: 339
-- Name: TABLE rst; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rst TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rst TO editores;
GRANT ALL ON TABLE catalogo_objetos.rst TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rst TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rst TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.rst TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rst TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.rst TO kcopo;


--
-- TOC entry 8173 (class 0 OID 0)
-- Dependencies: 340
-- Name: TABLE slt; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.slt TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.slt TO editores;
GRANT ALL ON TABLE catalogo_objetos.slt TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.slt TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.slt TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.slt TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.slt TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.slt TO kcopo;


--
-- TOC entry 8174 (class 0 OID 0)
-- Dependencies: 341
-- Name: TABLE smc; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.smc TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.smc TO editores;
GRANT ALL ON TABLE catalogo_objetos.smc TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.smc TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.smc TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.smc TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.smc TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.smc TO kcopo;


--
-- TOC entry 8175 (class 0 OID 0)
-- Dependencies: 342
-- Name: TABLE tra; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.tra TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.tra TO editores;
GRANT ALL ON TABLE catalogo_objetos.tra TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.tra TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.tra TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.tra TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.tra TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.tra TO kcopo;


--
-- TOC entry 8176 (class 0 OID 0)
-- Dependencies: 343
-- Name: TABLE tuc; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.tuc TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.tuc TO editores;
GRANT ALL ON TABLE catalogo_objetos.tuc TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.tuc TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.tuc TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.tuc TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.tuc TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.tuc TO kcopo;


--
-- TOC entry 8177 (class 0 OID 0)
-- Dependencies: 344
-- Name: TABLE typ; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.typ TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.typ TO editores;
GRANT ALL ON TABLE catalogo_objetos.typ TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.typ TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.typ TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.typ TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.typ TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.typ TO kcopo;


--
-- TOC entry 8178 (class 0 OID 0)
-- Dependencies: 345
-- Name: TABLE uuc; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.uuc TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.uuc TO editores;
GRANT ALL ON TABLE catalogo_objetos.uuc TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.uuc TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.uuc TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.uuc TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.uuc TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.uuc TO kcopo;


--
-- TOC entry 8179 (class 0 OID 0)
-- Dependencies: 346
-- Name: TABLE wtc; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.wtc TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.wtc TO editores;
GRANT ALL ON TABLE catalogo_objetos.wtc TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.wtc TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.wtc TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.wtc TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.wtc TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.wtc TO kcopo;


--
-- TOC entry 8180 (class 0 OID 0)
-- Dependencies: 347
-- Name: TABLE wti; Type: ACL; Schema: catalogo_objetos; Owner: postgres
--

GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.wti TO editores_cartografico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.wti TO editores;
GRANT ALL ON TABLE catalogo_objetos.wti TO lchanaluisa;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.wti TO mzuniga;
GRANT INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.wti TO fsalgado;
GRANT SELECT ON TABLE catalogo_objetos.wti TO fsalgado WITH GRANT OPTION;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.wti TO dguallichico;
GRANT SELECT,INSERT,REFERENCES,DELETE,TRIGGER,UPDATE ON TABLE catalogo_objetos.wti TO kcopo;


-- Completed on 2022-12-21 15:10:55

--
-- PostgreSQL database dump complete
--

